/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub;

import com.google.bigtable.repackaged.com.google.api.core.ApiFunction;
import com.google.bigtable.repackaged.com.google.api.core.BetaApi;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.batching.Batcher;
import com.google.bigtable.repackaged.com.google.api.gax.batching.BatcherImpl;
import com.google.bigtable.repackaged.com.google.api.gax.batching.FlowController;
import com.google.bigtable.repackaged.com.google.api.gax.core.BackgroundResource;
import com.google.bigtable.repackaged.com.google.api.gax.core.CredentialsProvider;
import com.google.bigtable.repackaged.com.google.api.gax.core.FixedCredentialsProvider;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcCallContext;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcCallSettings;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcRawCallableFactory;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.BasicResultRetryAlgorithm;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.ExponentialRetryAlgorithm;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.RetryAlgorithm;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.ScheduledRetryingExecutor;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ClientContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StreamingCallSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.ApiTracerFactory;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.OpencensusTracerFactory;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.SpanName;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.TracedServerStreamingCallable;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.TracedUnaryCallable;
import com.google.bigtable.repackaged.com.google.auth.Credentials;
import com.google.bigtable.repackaged.com.google.auth.oauth2.ServiceAccountJwtAccessCredentials;
import com.google.bigtable.repackaged.com.google.bigtable.v2.BigtableGrpc;
import com.google.bigtable.repackaged.com.google.bigtable.v2.CheckAndMutateRowRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.CheckAndMutateRowResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.GenerateInitialChangeStreamPartitionsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.GenerateInitialChangeStreamPartitionsResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowsResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.PingAndWarmRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.PingAndWarmResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadChangeStreamRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadChangeStreamResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadModifyWriteRowRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadModifyWriteRowResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadRowsResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.SampleRowKeysRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.SampleRowKeysResponse;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.Version;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.JwtCredentialsWithAudience;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.BulkMutation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.ChangeStreamRecord;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.ChangeStreamRecordAdapter;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.DefaultChangeStreamRecordAdapter;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.DefaultRowAdapter;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Query;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Range;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.ReadChangeStreamQuery;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.ReadModifyWriteRow;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Row;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.RowAdapter;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.TargetId;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.BigtableChannelPrimer;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.CheckAndMutateRowCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.ConvertExceptionCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.CookiesInterceptor;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.CookiesServerStreamingCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.CookiesUnaryCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.DynamicFlowControlCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.DynamicFlowControlStats;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.MutateRowCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.MutateRowsErrorConverterUnaryCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.RateLimitingServerStreamingCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.ReadModifyWriteRowCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.SampleRowKeysCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.SampleRowKeysCallableWithRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.changestream.ChangeStreamRecordMergingCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.changestream.GenerateInitialChangeStreamPartitionsUserCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.changestream.ReadChangeStreamResumptionStrategy;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.changestream.ReadChangeStreamUserCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.BigtableTracerStreamingCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.BigtableTracerUnaryCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.BuiltinMetricsConstants;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.BuiltinMetricsTracerFactory;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.CompositeTracerFactory;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.CustomOpenTelemetryMetricsProvider;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.DefaultMetricsProvider;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.ErrorCountPerConnectionMetricTracker;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.MetricsProvider;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.MetricsTracerFactory;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.NoopMetricsProvider;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.RpcMeasureConstants;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.StatsHeadersServerStreamingCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.StatsHeadersUnaryCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.TracedBatcherUnaryCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.mutaterows.BulkMutateRowsUserFacingCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.mutaterows.MutateRowsAttemptResult;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.mutaterows.MutateRowsPartialErrorRetryAlgorithm;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.mutaterows.MutateRowsRetryingCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.readrows.FilterMarkerRowsCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.readrows.ReadRowsFirstCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.readrows.ReadRowsResumptionStrategy;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.readrows.ReadRowsRetryCompletedCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.readrows.ReadRowsUserCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.readrows.RowMergingCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.gaxx.retrying.ApiResultRetryAlgorithm;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.gaxx.retrying.Callables;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.gaxx.retrying.RetryInfoRetryAlgorithm;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.bigtable.repackaged.io.grpc.ManagedChannelBuilder;
import com.google.bigtable.repackaged.io.opencensus.stats.Stats;
import com.google.bigtable.repackaged.io.opencensus.stats.StatsRecorder;
import com.google.bigtable.repackaged.io.opencensus.tags.TagKey;
import com.google.bigtable.repackaged.io.opencensus.tags.TagValue;
import com.google.bigtable.repackaged.io.opencensus.tags.Tagger;
import com.google.bigtable.repackaged.io.opencensus.tags.Tags;
import com.google.bigtable.repackaged.io.opentelemetry.api.OpenTelemetry;
import com.google.bigtable.repackaged.io.opentelemetry.api.common.Attributes;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class EnhancedBigtableStub
implements AutoCloseable {
    private static final Logger logger = Logger.getLogger(EnhancedBigtableStub.class.getName());
    private static final String CLIENT_NAME = "Bigtable";
    private static final long FLOW_CONTROL_ADJUSTING_INTERVAL_MS = TimeUnit.SECONDS.toMillis(20L);
    private final EnhancedBigtableStubSettings settings;
    private final ClientContext clientContext;
    private final boolean closeClientContext;
    private final RequestContext requestContext;
    private final FlowController bulkMutationFlowController;
    private final DynamicFlowControlStats bulkMutationDynamicFlowControlStats;
    private final ServerStreamingCallable<Query, Row> readRowsCallable;
    private final UnaryCallable<Query, Row> readRowCallable;
    private final UnaryCallable<Query, List<Row>> bulkReadRowsCallable;
    private final UnaryCallable<String, List<KeyOffset>> sampleRowKeysCallable;
    private final UnaryCallable<com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.SampleRowKeysRequest, List<KeyOffset>> sampleRowKeysCallableWithRequest;
    private final UnaryCallable<RowMutation, Void> mutateRowCallable;
    private final UnaryCallable<BulkMutation, MutateRowsAttemptResult> bulkMutateRowsCallable;
    private final UnaryCallable<BulkMutation, Void> externalBulkMutateRowsCallable;
    private final UnaryCallable<ConditionalRowMutation, Boolean> checkAndMutateRowCallable;
    private final UnaryCallable<ReadModifyWriteRow, Row> readModifyWriteRowCallable;
    private final UnaryCallable<PingAndWarmRequest, PingAndWarmResponse> pingAndWarmCallable;
    private final ServerStreamingCallable<String, Range.ByteStringRange> generateInitialChangeStreamPartitionsCallable;
    private final ServerStreamingCallable<ReadChangeStreamQuery, ChangeStreamRecord> readChangeStreamCallable;

    public static EnhancedBigtableStub create(EnhancedBigtableStubSettings settings) throws IOException {
        ClientContext clientContext = EnhancedBigtableStub.createClientContext(settings);
        OpenTelemetry openTelemetry = null;
        try {
            openTelemetry = EnhancedBigtableStub.getOpenTelemetry(settings.getProjectId(), settings.getMetricsProvider(), clientContext.getCredentials());
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Failed to get OTEL, will skip exporting client side metrics", t);
        }
        ClientContext contextWithTracer = clientContext.toBuilder().setTracerFactory(EnhancedBigtableStub.createBigtableTracerFactory(settings, openTelemetry)).build();
        return new EnhancedBigtableStub(settings, contextWithTracer);
    }

    public static EnhancedBigtableStub createWithClientContext(EnhancedBigtableStubSettings settings, ClientContext clientContext) throws IOException {
        return new EnhancedBigtableStub(settings, clientContext, false);
    }

    public static ClientContext createClientContext(EnhancedBigtableStubSettings settings) throws IOException {
        ErrorCountPerConnectionMetricTracker errorCountPerConnectionMetricTracker;
        EnhancedBigtableStubSettings.Builder builder = settings.toBuilder();
        EnhancedBigtableStub.patchCredentials(builder);
        Credentials credentials = null;
        if (builder.getCredentialsProvider() != null) {
            credentials = builder.getCredentialsProvider().getCredentials();
        }
        builder.setCredentialsProvider(FixedCredentialsProvider.create(credentials));
        InstantiatingGrpcChannelProvider.Builder transportProvider = builder.getTransportChannelProvider() instanceof InstantiatingGrpcChannelProvider ? ((InstantiatingGrpcChannelProvider)builder.getTransportChannelProvider()).toBuilder() : null;
        OpenTelemetry openTelemetry = null;
        try {
            openTelemetry = EnhancedBigtableStub.getOpenTelemetry(settings.getProjectId(), settings.getMetricsProvider(), credentials);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Failed to get OTEL, will skip exporting client side metrics", t);
        }
        if (openTelemetry != null && transportProvider != null) {
            errorCountPerConnectionMetricTracker = new ErrorCountPerConnectionMetricTracker(openTelemetry, EnhancedBigtableStub.createBuiltinAttributes(settings));
            ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> oldChannelConfigurator = transportProvider.getChannelConfigurator();
            transportProvider.setChannelConfigurator(managedChannelBuilder -> {
                if (settings.getEnableRoutingCookie()) {
                    managedChannelBuilder.intercept(new CookiesInterceptor());
                }
                managedChannelBuilder.intercept(errorCountPerConnectionMetricTracker.getInterceptor());
                if (oldChannelConfigurator != null) {
                    managedChannelBuilder = (ManagedChannelBuilder)oldChannelConfigurator.apply((ManagedChannelBuilder)managedChannelBuilder);
                }
                return managedChannelBuilder;
            });
        } else {
            errorCountPerConnectionMetricTracker = null;
        }
        if (settings.isRefreshingChannel() && transportProvider != null) {
            transportProvider.setChannelPrimer(BigtableChannelPrimer.create(credentials, settings.getProjectId(), settings.getInstanceId(), settings.getAppProfileId()));
        }
        if (transportProvider != null) {
            builder.setTransportChannelProvider(transportProvider.build());
        }
        ClientContext clientContext = ClientContext.create(builder.build());
        if (errorCountPerConnectionMetricTracker != null) {
            errorCountPerConnectionMetricTracker.startConnectionErrorCountTracker(clientContext.getExecutor());
        }
        return clientContext;
    }

    public static ApiTracerFactory createBigtableTracerFactory(EnhancedBigtableStubSettings settings, @Nullable OpenTelemetry openTelemetry) throws IOException {
        return EnhancedBigtableStub.createBigtableTracerFactory(settings, Tags.getTagger(), Stats.getStatsRecorder(), openTelemetry);
    }

    @VisibleForTesting
    public static ApiTracerFactory createBigtableTracerFactory(EnhancedBigtableStubSettings settings, Tagger tagger, StatsRecorder stats, @Nullable OpenTelemetry openTelemetry) throws IOException {
        BuiltinMetricsTracerFactory builtinMetricsTracerFactory;
        String projectId = settings.getProjectId();
        String instanceId = settings.getInstanceId();
        String appProfileId = settings.getAppProfileId();
        ImmutableMap<TagKey, TagValue> attributes = ImmutableMap.builder().put(RpcMeasureConstants.BIGTABLE_PROJECT_ID, TagValue.create(projectId)).put(RpcMeasureConstants.BIGTABLE_INSTANCE_ID, TagValue.create(instanceId)).put(RpcMeasureConstants.BIGTABLE_APP_PROFILE_ID, TagValue.create(appProfileId)).build();
        ImmutableList.Builder tracerFactories = ImmutableList.builder();
        ((ImmutableList.Builder)((ImmutableList.Builder)tracerFactories.add(new OpencensusTracerFactory(ImmutableMap.builder().put(RpcMeasureConstants.BIGTABLE_PROJECT_ID.getName(), projectId).put(RpcMeasureConstants.BIGTABLE_INSTANCE_ID.getName(), instanceId).put(RpcMeasureConstants.BIGTABLE_APP_PROFILE_ID.getName(), appProfileId).put("gax", GaxGrpcProperties.getGaxGrpcVersion()).put("grpc", GaxGrpcProperties.getGrpcVersion()).put("gapic", Version.VERSION).build()))).add(MetricsTracerFactory.create(tagger, stats, attributes))).add(settings.getTracerFactory());
        BuiltinMetricsTracerFactory builtinMetricsTracerFactory2 = builtinMetricsTracerFactory = openTelemetry != null ? BuiltinMetricsTracerFactory.create(openTelemetry, EnhancedBigtableStub.createBuiltinAttributes(settings)) : null;
        if (builtinMetricsTracerFactory != null) {
            tracerFactories.add(builtinMetricsTracerFactory);
        }
        return new CompositeTracerFactory((List<ApiTracerFactory>)((Object)tracerFactories.build()));
    }

    @Nullable
    public static OpenTelemetry getOpenTelemetry(String projectId, MetricsProvider metricsProvider, @Nullable Credentials defaultCredentials) throws IOException {
        if (metricsProvider instanceof CustomOpenTelemetryMetricsProvider) {
            CustomOpenTelemetryMetricsProvider customMetricsProvider = (CustomOpenTelemetryMetricsProvider)metricsProvider;
            return customMetricsProvider.getOpenTelemetry();
        }
        if (metricsProvider instanceof DefaultMetricsProvider) {
            Credentials credentials = BigtableDataSettings.getMetricsCredentials() != null ? BigtableDataSettings.getMetricsCredentials() : defaultCredentials;
            DefaultMetricsProvider defaultMetricsProvider = (DefaultMetricsProvider)metricsProvider;
            return defaultMetricsProvider.getOpenTelemetry(projectId, credentials);
        }
        if (metricsProvider instanceof NoopMetricsProvider) {
            return null;
        }
        throw new IOException("Invalid MetricsProvider type " + metricsProvider);
    }

    private static Attributes createBuiltinAttributes(EnhancedBigtableStubSettings settings) {
        return Attributes.of(BuiltinMetricsConstants.BIGTABLE_PROJECT_ID_KEY, settings.getProjectId(), BuiltinMetricsConstants.INSTANCE_ID_KEY, settings.getInstanceId(), BuiltinMetricsConstants.APP_PROFILE_KEY, settings.getAppProfileId(), BuiltinMetricsConstants.CLIENT_NAME_KEY, "bigtable-java/" + Version.VERSION);
    }

    private static void patchCredentials(EnhancedBigtableStubSettings.Builder settings) throws IOException {
        int i = settings.getEndpoint().lastIndexOf(":");
        String host = settings.getEndpoint().substring(0, i);
        String audience = settings.getJwtAudienceMapping().get(host);
        if (audience == null) {
            return;
        }
        URI audienceUri = null;
        try {
            audienceUri = new URI(audience);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("invalid JWT audience override", e);
        }
        CredentialsProvider credentialsProvider = settings.getCredentialsProvider();
        if (credentialsProvider == null) {
            return;
        }
        Credentials credentials = credentialsProvider.getCredentials();
        if (credentials == null) {
            return;
        }
        if (!(credentials instanceof ServiceAccountJwtAccessCredentials)) {
            return;
        }
        ServiceAccountJwtAccessCredentials jwtCreds = (ServiceAccountJwtAccessCredentials)credentials;
        JwtCredentialsWithAudience patchedCreds = new JwtCredentialsWithAudience(jwtCreds, audienceUri);
        settings.setCredentialsProvider(FixedCredentialsProvider.create(patchedCreds));
    }

    public EnhancedBigtableStub(EnhancedBigtableStubSettings settings, ClientContext clientContext) {
        this(settings, clientContext, true);
    }

    public EnhancedBigtableStub(EnhancedBigtableStubSettings settings, ClientContext clientContext, boolean closeClientContext) {
        this.settings = settings;
        this.clientContext = clientContext;
        this.closeClientContext = closeClientContext;
        this.requestContext = RequestContext.create(settings.getProjectId(), settings.getInstanceId(), settings.getAppProfileId());
        this.bulkMutationFlowController = new FlowController(settings.bulkMutateRowsSettings().getDynamicFlowControlSettings());
        this.bulkMutationDynamicFlowControlStats = new DynamicFlowControlStats();
        this.readRowsCallable = this.createReadRowsCallable(new DefaultRowAdapter());
        this.readRowCallable = this.createReadRowCallable(new DefaultRowAdapter());
        this.bulkReadRowsCallable = this.createBulkReadRowsCallable(new DefaultRowAdapter());
        this.sampleRowKeysCallable = this.createSampleRowKeysCallable();
        this.sampleRowKeysCallableWithRequest = this.createSampleRowKeysCallableWithRequest();
        this.mutateRowCallable = this.createMutateRowCallable();
        this.bulkMutateRowsCallable = this.createMutateRowsBaseCallable();
        this.externalBulkMutateRowsCallable = new MutateRowsErrorConverterUnaryCallable(this.bulkMutateRowsCallable);
        this.checkAndMutateRowCallable = this.createCheckAndMutateRowCallable();
        this.readModifyWriteRowCallable = this.createReadModifyWriteRowCallable();
        this.generateInitialChangeStreamPartitionsCallable = this.createGenerateInitialChangeStreamPartitionsCallable();
        this.readChangeStreamCallable = this.createReadChangeStreamCallable(new DefaultChangeStreamRecordAdapter());
        this.pingAndWarmCallable = this.createPingAndWarmCallable();
    }

    @BetaApi(value="This surface is stable yet it might be removed in the future.")
    public <RowT> ServerStreamingCallable<ReadRowsRequest, RowT> createReadRowsRawCallable(RowAdapter<RowT> rowAdapter) {
        return this.createReadRowsBaseCallable(this.settings.readRowsSettings(), rowAdapter).withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    public <RowT> ServerStreamingCallable<Query, RowT> createReadRowsCallable(RowAdapter<RowT> rowAdapter) {
        ServerStreamingCallable<ReadRowsRequest, RowT> readRowsCallable = this.createReadRowsBaseCallable(this.settings.readRowsSettings(), rowAdapter);
        ReadRowsUserCallable<RowT> readRowsUserCallable = new ReadRowsUserCallable<RowT>(readRowsCallable, this.requestContext);
        SpanName span = this.getSpanName("ReadRows");
        TracedServerStreamingCallable traced = new TracedServerStreamingCallable(readRowsUserCallable, this.clientContext.getTracerFactory(), span);
        return traced.withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    public <RowT> UnaryCallable<Query, RowT> createReadRowCallable(RowAdapter<RowT> rowAdapter) {
        ServerStreamingCallable<ReadRowsRequest, RowT> readRowsCallable = this.createReadRowsBaseCallable((ServerStreamingCallSettings)ServerStreamingCallSettings.newBuilder().setRetryableCodes(this.settings.readRowSettings().getRetryableCodes()).setRetrySettings(this.settings.readRowSettings().getRetrySettings()).setIdleTimeout(this.settings.readRowSettings().getRetrySettings().getTotalTimeout()).build(), rowAdapter);
        ReadRowsUserCallable<RowT> readRowCallable = new ReadRowsUserCallable<RowT>(readRowsCallable, this.requestContext);
        ReadRowsFirstCallable firstRow = new ReadRowsFirstCallable(readRowCallable);
        TracedUnaryCallable traced = new TracedUnaryCallable(firstRow, this.clientContext.getTracerFactory(), this.getSpanName("ReadRow"));
        return traced.withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    private <ReqT, RowT> ServerStreamingCallable<ReadRowsRequest, RowT> createReadRowsBaseCallable(ServerStreamingCallSettings<ReqT, Row> readRowsSettings, RowAdapter<RowT> rowAdapter) {
        ServerStreamingCallable<ReadRowsRequest, ReadRowsResponse> base = GrpcRawCallableFactory.createServerStreamingCallable(GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getReadRowsMethod()).setParamsExtractor(new RequestParamsExtractor<ReadRowsRequest>(){

            @Override
            public Map<String, String> extract(ReadRowsRequest readRowsRequest) {
                String tableName = readRowsRequest.getTableName();
                String authorizedViewName = readRowsRequest.getAuthorizedViewName();
                if (tableName.isEmpty()) {
                    tableName = NameUtil.extractTableNameFromAuthorizedViewName(authorizedViewName);
                }
                return ImmutableMap.of("table_name", tableName, "app_profile_id", readRowsRequest.getAppProfileId());
            }
        }).build(), readRowsSettings.getRetryableCodes());
        StatsHeadersServerStreamingCallable withStatsHeaders = new StatsHeadersServerStreamingCallable(base);
        ConvertExceptionCallable<ReadRowsRequest, ReadRowsResponse> convertException = new ConvertExceptionCallable<ReadRowsRequest, ReadRowsResponse>(withStatsHeaders);
        RowMergingCallable<RowT> merging = new RowMergingCallable<RowT>(convertException, rowAdapter);
        StreamingCallSettings innerSettings = ServerStreamingCallSettings.newBuilder().setResumptionStrategy(new ReadRowsResumptionStrategy<RowT>(rowAdapter)).setRetryableCodes(readRowsSettings.getRetryableCodes()).setRetrySettings(readRowsSettings.getRetrySettings()).setIdleTimeout(readRowsSettings.getIdleTimeout()).setWaitTimeout(readRowsSettings.getWaitTimeout()).build();
        ServerStreamingCallable watched = com.google.bigtable.repackaged.com.google.api.gax.rpc.Callables.watched(merging, innerSettings, this.clientContext);
        BigtableTracerStreamingCallable withBigtableTracer = new BigtableTracerStreamingCallable(watched);
        ReadRowsRetryCompletedCallable retrying1 = new ReadRowsRetryCompletedCallable(withBigtableTracer);
        ServerStreamingCallable retrying2 = this.withRetries(retrying1, (ServerStreamingCallSettings)innerSettings);
        return new FilterMarkerRowsCallable(retrying2, rowAdapter);
    }

    private <RowT> UnaryCallable<Query, List<RowT>> createBulkReadRowsCallable(RowAdapter<RowT> rowAdapter) {
        ServerStreamingCallable<ReadRowsRequest, RowT> readRowsCallable = this.createReadRowsBaseCallable(this.settings.readRowsSettings(), rowAdapter);
        ReadRowsUserCallable<RowT> readRowsUserCallable = new ReadRowsUserCallable<RowT>(readRowsCallable, this.requestContext);
        SpanName span = this.getSpanName("ReadRows");
        TracedBatcherUnaryCallable tracedBatcher = new TracedBatcherUnaryCallable(readRowsUserCallable.all());
        TracedUnaryCallable traced = new TracedUnaryCallable(tracedBatcher, this.clientContext.getTracerFactory(), span);
        return traced.withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    private UnaryCallable<SampleRowKeysRequest, List<SampleRowKeysResponse>> createSampleRowKeysBaseCallable() {
        ServerStreamingCallable<SampleRowKeysRequest, SampleRowKeysResponse> base = GrpcRawCallableFactory.createServerStreamingCallable(GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getSampleRowKeysMethod()).setParamsExtractor(new RequestParamsExtractor<SampleRowKeysRequest>(){

            @Override
            public Map<String, String> extract(SampleRowKeysRequest sampleRowKeysRequest) {
                String tableName = sampleRowKeysRequest.getTableName();
                String authorizedViewName = sampleRowKeysRequest.getAuthorizedViewName();
                if (tableName.isEmpty()) {
                    tableName = NameUtil.extractTableNameFromAuthorizedViewName(authorizedViewName);
                }
                return ImmutableMap.of("table_name", tableName, "app_profile_id", sampleRowKeysRequest.getAppProfileId());
            }
        }).build(), this.settings.sampleRowKeysSettings().getRetryableCodes());
        UnaryCallable<SampleRowKeysRequest, List<SampleRowKeysResponse>> spoolable = base.all();
        StatsHeadersUnaryCallable withStatsHeaders = new StatsHeadersUnaryCallable(spoolable);
        BigtableTracerUnaryCallable withBigtableTracer = new BigtableTracerUnaryCallable(withStatsHeaders);
        UnaryCallable<SampleRowKeysRequest, List<SampleRowKeysResponse>> retryable = this.withRetries(withBigtableTracer, this.settings.sampleRowKeysSettings());
        return retryable;
    }

    private UnaryCallable<String, List<KeyOffset>> createSampleRowKeysCallable() {
        String methodName = "SampleRowKeys";
        UnaryCallable<SampleRowKeysRequest, List<SampleRowKeysResponse>> baseCallable = this.createSampleRowKeysBaseCallable();
        return this.createUserFacingUnaryCallable(methodName, new SampleRowKeysCallable(baseCallable, this.requestContext));
    }

    private UnaryCallable<com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.SampleRowKeysRequest, List<KeyOffset>> createSampleRowKeysCallableWithRequest() {
        String methodName = "SampleRowKeys";
        UnaryCallable<SampleRowKeysRequest, List<SampleRowKeysResponse>> baseCallable = this.createSampleRowKeysBaseCallable();
        return this.createUserFacingUnaryCallable(methodName, new SampleRowKeysCallableWithRequest(baseCallable, this.requestContext));
    }

    private UnaryCallable<RowMutation, Void> createMutateRowCallable() {
        String methodName = "MutateRow";
        UnaryCallable<MutateRowRequest, MutateRowResponse> base = GrpcRawCallableFactory.createUnaryCallable(GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getMutateRowMethod()).setParamsExtractor(new RequestParamsExtractor<MutateRowRequest>(){

            @Override
            public Map<String, String> extract(MutateRowRequest mutateRowRequest) {
                String tableName = mutateRowRequest.getTableName();
                String authorizedViewName = mutateRowRequest.getAuthorizedViewName();
                if (tableName.isEmpty()) {
                    tableName = NameUtil.extractTableNameFromAuthorizedViewName(authorizedViewName);
                }
                return ImmutableMap.of("table_name", tableName, "app_profile_id", mutateRowRequest.getAppProfileId());
            }
        }).build(), this.settings.mutateRowSettings().getRetryableCodes());
        StatsHeadersUnaryCallable withStatsHeaders = new StatsHeadersUnaryCallable(base);
        BigtableTracerUnaryCallable withBigtableTracer = new BigtableTracerUnaryCallable(withStatsHeaders);
        UnaryCallable<MutateRowRequest, MutateRowResponse> retrying = this.withRetries(withBigtableTracer, this.settings.mutateRowSettings());
        return this.createUserFacingUnaryCallable(methodName, new MutateRowCallable(retrying, this.requestContext));
    }

    private UnaryCallable<BulkMutation, MutateRowsAttemptResult> createMutateRowsBaseCallable() {
        MutateRowsRetryingCallable baseCallable;
        ServerStreamingCallable<MutateRowsRequest, MutateRowsResponse> base = GrpcRawCallableFactory.createServerStreamingCallable(GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getMutateRowsMethod()).setParamsExtractor(new RequestParamsExtractor<MutateRowsRequest>(){

            @Override
            public Map<String, String> extract(MutateRowsRequest mutateRowsRequest) {
                String tableName = mutateRowsRequest.getTableName();
                String authorizedViewName = mutateRowsRequest.getAuthorizedViewName();
                if (tableName.isEmpty()) {
                    tableName = NameUtil.extractTableNameFromAuthorizedViewName(authorizedViewName);
                }
                return ImmutableMap.of("table_name", tableName, "app_profile_id", mutateRowsRequest.getAppProfileId());
            }
        }).build(), this.settings.bulkMutateRowsSettings().getRetryableCodes());
        ServerStreamingCallable callable = new StatsHeadersServerStreamingCallable<MutateRowsRequest, MutateRowsResponse>(base);
        if (this.settings.bulkMutateRowsSettings().isServerInitiatedFlowControlEnabled()) {
            callable = new RateLimitingServerStreamingCallable(callable);
        }
        ConvertExceptionCallable<MutateRowsRequest, MutateRowsResponse> convertException = new ConvertExceptionCallable<MutateRowsRequest, MutateRowsResponse>(callable);
        BigtableTracerStreamingCallable<MutateRowsRequest, MutateRowsResponse> withBigtableTracer = new BigtableTracerStreamingCallable<MutateRowsRequest, MutateRowsResponse>(convertException);
        BasicResultRetryAlgorithm resultRetryAlgorithm = this.settings.getEnableRetryInfo() ? new RetryInfoRetryAlgorithm() : new ApiResultRetryAlgorithm();
        MutateRowsPartialErrorRetryAlgorithm mutateRowsPartialErrorRetryAlgorithm = new MutateRowsPartialErrorRetryAlgorithm(resultRetryAlgorithm);
        RetryAlgorithm<MutateRowsAttemptResult> retryAlgorithm = new RetryAlgorithm<MutateRowsAttemptResult>(mutateRowsPartialErrorRetryAlgorithm, new ExponentialRetryAlgorithm(this.settings.bulkMutateRowsSettings().getRetrySettings(), this.clientContext.getClock()));
        ScheduledRetryingExecutor<MutateRowsAttemptResult> retryingExecutor = new ScheduledRetryingExecutor<MutateRowsAttemptResult>(retryAlgorithm, this.clientContext.getExecutor());
        UnaryCallable withCookie = baseCallable = new MutateRowsRetryingCallable(this.clientContext.getDefaultCallContext(), withBigtableTracer, retryingExecutor, this.settings.bulkMutateRowsSettings().getRetryableCodes(), retryAlgorithm);
        if (this.settings.getEnableRoutingCookie()) {
            withCookie = new CookiesUnaryCallable<MutateRowsRequest, MutateRowsAttemptResult>(baseCallable);
        }
        UnaryCallable flowControlCallable = null;
        if (this.settings.bulkMutateRowsSettings().isLatencyBasedThrottlingEnabled()) {
            flowControlCallable = new DynamicFlowControlCallable(withCookie, this.bulkMutationFlowController, this.bulkMutationDynamicFlowControlStats, this.settings.bulkMutateRowsSettings().getTargetRpcLatencyMs(), FLOW_CONTROL_ADJUSTING_INTERVAL_MS);
        }
        BulkMutateRowsUserFacingCallable userFacing = new BulkMutateRowsUserFacingCallable(flowControlCallable != null ? flowControlCallable : withCookie, this.requestContext);
        SpanName spanName = this.getSpanName("MutateRows");
        TracedBatcherUnaryCallable tracedBatcherUnaryCallable = new TracedBatcherUnaryCallable(userFacing);
        TracedUnaryCallable traced = new TracedUnaryCallable(tracedBatcherUnaryCallable, this.clientContext.getTracerFactory(), spanName);
        return traced.withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    public Batcher<RowMutationEntry, Void> newMutateRowsBatcher(@Nonnull String tableId, @Nullable GrpcCallContext ctx) {
        return new BatcherImpl<RowMutationEntry, Void, BulkMutation, MutateRowsAttemptResult>(this.settings.bulkMutateRowsSettings().getBatchingDescriptor(), this.bulkMutateRowsCallable, BulkMutation.create(tableId), this.settings.bulkMutateRowsSettings().getBatchingSettings(), this.clientContext.getExecutor(), this.bulkMutationFlowController, MoreObjects.firstNonNull(ctx, this.clientContext.getDefaultCallContext()));
    }

    public Batcher<RowMutationEntry, Void> newMutateRowsBatcher(TargetId targetId, @Nullable GrpcCallContext ctx) {
        return new BatcherImpl<RowMutationEntry, Void, BulkMutation, MutateRowsAttemptResult>(this.settings.bulkMutateRowsSettings().getBatchingDescriptor(), this.bulkMutateRowsCallable, BulkMutation.create(targetId), this.settings.bulkMutateRowsSettings().getBatchingSettings(), this.clientContext.getExecutor(), this.bulkMutationFlowController, MoreObjects.firstNonNull(ctx, this.clientContext.getDefaultCallContext()));
    }

    public Batcher<ByteString, Row> newBulkReadRowsBatcher(@Nonnull Query query, @Nullable GrpcCallContext ctx) {
        Preconditions.checkNotNull(query, "query cannot be null");
        return new BatcherImpl<ByteString, Row, Query, List<Row>>(this.settings.bulkReadRowsSettings().getBatchingDescriptor(), this.bulkReadRowsCallable, query, this.settings.bulkReadRowsSettings().getBatchingSettings(), this.clientContext.getExecutor(), null, MoreObjects.firstNonNull(ctx, this.clientContext.getDefaultCallContext()));
    }

    private UnaryCallable<ConditionalRowMutation, Boolean> createCheckAndMutateRowCallable() {
        String methodName = "CheckAndMutateRow";
        UnaryCallable<CheckAndMutateRowRequest, CheckAndMutateRowResponse> base = GrpcRawCallableFactory.createUnaryCallable(GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getCheckAndMutateRowMethod()).setParamsExtractor(new RequestParamsExtractor<CheckAndMutateRowRequest>(){

            @Override
            public Map<String, String> extract(CheckAndMutateRowRequest checkAndMutateRowRequest) {
                String tableName = checkAndMutateRowRequest.getTableName();
                String authorizedViewName = checkAndMutateRowRequest.getAuthorizedViewName();
                if (tableName.isEmpty()) {
                    tableName = NameUtil.extractTableNameFromAuthorizedViewName(authorizedViewName);
                }
                return ImmutableMap.of("table_name", tableName, "app_profile_id", checkAndMutateRowRequest.getAppProfileId());
            }
        }).build(), this.settings.checkAndMutateRowSettings().getRetryableCodes());
        StatsHeadersUnaryCallable withStatsHeaders = new StatsHeadersUnaryCallable(base);
        BigtableTracerUnaryCallable withBigtableTracer = new BigtableTracerUnaryCallable(withStatsHeaders);
        UnaryCallable<CheckAndMutateRowRequest, CheckAndMutateRowResponse> retrying = this.withRetries(withBigtableTracer, this.settings.checkAndMutateRowSettings());
        return this.createUserFacingUnaryCallable(methodName, new CheckAndMutateRowCallable(retrying, this.requestContext));
    }

    private UnaryCallable<ReadModifyWriteRow, Row> createReadModifyWriteRowCallable() {
        UnaryCallable<ReadModifyWriteRowRequest, ReadModifyWriteRowResponse> base = GrpcRawCallableFactory.createUnaryCallable(GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getReadModifyWriteRowMethod()).setParamsExtractor(new RequestParamsExtractor<ReadModifyWriteRowRequest>(){

            @Override
            public Map<String, String> extract(ReadModifyWriteRowRequest request) {
                String tableName = request.getTableName();
                String authorizedViewName = request.getAuthorizedViewName();
                if (tableName.isEmpty()) {
                    tableName = NameUtil.extractTableNameFromAuthorizedViewName(authorizedViewName);
                }
                return ImmutableMap.of("table_name", tableName, "app_profile_id", request.getAppProfileId());
            }
        }).build(), this.settings.readModifyWriteRowSettings().getRetryableCodes());
        StatsHeadersUnaryCallable withStatsHeaders = new StatsHeadersUnaryCallable(base);
        String methodName = "ReadModifyWriteRow";
        BigtableTracerUnaryCallable withBigtableTracer = new BigtableTracerUnaryCallable(withStatsHeaders);
        UnaryCallable<ReadModifyWriteRowRequest, ReadModifyWriteRowResponse> retrying = this.withRetries(withBigtableTracer, this.settings.readModifyWriteRowSettings());
        return this.createUserFacingUnaryCallable(methodName, new ReadModifyWriteRowCallable(retrying, this.requestContext));
    }

    private ServerStreamingCallable<String, Range.ByteStringRange> createGenerateInitialChangeStreamPartitionsCallable() {
        ServerStreamingCallable<GenerateInitialChangeStreamPartitionsRequest, GenerateInitialChangeStreamPartitionsResponse> base = GrpcRawCallableFactory.createServerStreamingCallable(GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getGenerateInitialChangeStreamPartitionsMethod()).setParamsExtractor(new RequestParamsExtractor<GenerateInitialChangeStreamPartitionsRequest>(){

            @Override
            public Map<String, String> extract(GenerateInitialChangeStreamPartitionsRequest generateInitialChangeStreamPartitionsRequest) {
                return ImmutableMap.of("table_name", generateInitialChangeStreamPartitionsRequest.getTableName(), "app_profile_id", generateInitialChangeStreamPartitionsRequest.getAppProfileId());
            }
        }).build(), this.settings.generateInitialChangeStreamPartitionsSettings().getRetryableCodes());
        GenerateInitialChangeStreamPartitionsUserCallable userCallable = new GenerateInitialChangeStreamPartitionsUserCallable(base, this.requestContext);
        StatsHeadersServerStreamingCallable withStatsHeaders = new StatsHeadersServerStreamingCallable(userCallable);
        ConvertExceptionCallable convertException = new ConvertExceptionCallable(withStatsHeaders);
        StreamingCallSettings innerSettings = ServerStreamingCallSettings.newBuilder().setRetryableCodes(this.settings.generateInitialChangeStreamPartitionsSettings().getRetryableCodes()).setRetrySettings(this.settings.generateInitialChangeStreamPartitionsSettings().getRetrySettings()).setIdleTimeout(this.settings.generateInitialChangeStreamPartitionsSettings().getIdleTimeout()).setWaitTimeout(this.settings.generateInitialChangeStreamPartitionsSettings().getWaitTimeout()).build();
        ServerStreamingCallable watched = com.google.bigtable.repackaged.com.google.api.gax.rpc.Callables.watched(convertException, innerSettings, this.clientContext);
        BigtableTracerStreamingCallable withBigtableTracer = new BigtableTracerStreamingCallable(watched);
        ServerStreamingCallable retrying = this.withRetries(withBigtableTracer, (ServerStreamingCallSettings)innerSettings);
        SpanName span = this.getSpanName("GenerateInitialChangeStreamPartitions");
        TracedServerStreamingCallable traced = new TracedServerStreamingCallable(retrying, this.clientContext.getTracerFactory(), span);
        return traced.withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    public <ChangeStreamRecordT> ServerStreamingCallable<ReadChangeStreamQuery, ChangeStreamRecordT> createReadChangeStreamCallable(ChangeStreamRecordAdapter<ChangeStreamRecordT> changeStreamRecordAdapter) {
        ServerStreamingCallable<ReadChangeStreamRequest, ReadChangeStreamResponse> base = GrpcRawCallableFactory.createServerStreamingCallable(GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getReadChangeStreamMethod()).setParamsExtractor(new RequestParamsExtractor<ReadChangeStreamRequest>(){

            @Override
            public Map<String, String> extract(ReadChangeStreamRequest readChangeStreamRequest) {
                return ImmutableMap.of("table_name", readChangeStreamRequest.getTableName(), "app_profile_id", readChangeStreamRequest.getAppProfileId());
            }
        }).build(), this.settings.readChangeStreamSettings().getRetryableCodes());
        StatsHeadersServerStreamingCallable withStatsHeaders = new StatsHeadersServerStreamingCallable(base);
        ConvertExceptionCallable<ReadChangeStreamRequest, ReadChangeStreamResponse> convertException = new ConvertExceptionCallable<ReadChangeStreamRequest, ReadChangeStreamResponse>(withStatsHeaders);
        ChangeStreamRecordMergingCallable<ChangeStreamRecordT> merging = new ChangeStreamRecordMergingCallable<ChangeStreamRecordT>(convertException, changeStreamRecordAdapter);
        StreamingCallSettings innerSettings = ServerStreamingCallSettings.newBuilder().setResumptionStrategy(new ReadChangeStreamResumptionStrategy<ChangeStreamRecordT>(changeStreamRecordAdapter)).setRetryableCodes(this.settings.readChangeStreamSettings().getRetryableCodes()).setRetrySettings(this.settings.readChangeStreamSettings().getRetrySettings()).setIdleTimeout(this.settings.readChangeStreamSettings().getIdleTimeout()).setWaitTimeout(this.settings.readChangeStreamSettings().getWaitTimeout()).build();
        ServerStreamingCallable watched = com.google.bigtable.repackaged.com.google.api.gax.rpc.Callables.watched(merging, innerSettings, this.clientContext);
        BigtableTracerStreamingCallable withBigtableTracer = new BigtableTracerStreamingCallable(watched);
        ServerStreamingCallable readChangeStreamCallable = this.withRetries(withBigtableTracer, (ServerStreamingCallSettings)innerSettings);
        ReadChangeStreamUserCallable readChangeStreamUserCallable = new ReadChangeStreamUserCallable(readChangeStreamCallable, this.requestContext);
        SpanName span = this.getSpanName("ReadChangeStream");
        TracedServerStreamingCallable traced = new TracedServerStreamingCallable(readChangeStreamUserCallable, this.clientContext.getTracerFactory(), span);
        return traced.withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    private <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> createUserFacingUnaryCallable(String methodName, UnaryCallable<RequestT, ResponseT> inner) {
        TracedUnaryCallable<RequestT, ResponseT> traced = new TracedUnaryCallable<RequestT, ResponseT>(inner, this.clientContext.getTracerFactory(), this.getSpanName(methodName));
        return traced.withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    private UnaryCallable<PingAndWarmRequest, PingAndWarmResponse> createPingAndWarmCallable() {
        UnaryCallable<PingAndWarmRequest, PingAndWarmResponse> pingAndWarm = GrpcRawCallableFactory.createUnaryCallable(GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getPingAndWarmMethod()).setParamsExtractor(new RequestParamsExtractor<PingAndWarmRequest>(){

            @Override
            public Map<String, String> extract(PingAndWarmRequest request) {
                return ImmutableMap.of("name", request.getName(), "app_profile_id", request.getAppProfileId());
            }
        }).build(), Collections.emptySet());
        return pingAndWarm.withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    private <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> withRetries(UnaryCallable<RequestT, ResponseT> innerCallable, UnaryCallSettings<?, ?> unaryCallSettings) {
        UnaryCallable<RequestT, ResponseT> retrying = this.settings.getEnableRetryInfo() ? Callables.retrying(innerCallable, unaryCallSettings, this.clientContext) : com.google.bigtable.repackaged.com.google.api.gax.rpc.Callables.retrying(innerCallable, unaryCallSettings, this.clientContext);
        if (this.settings.getEnableRoutingCookie()) {
            return new CookiesUnaryCallable<RequestT, ResponseT>(retrying);
        }
        return retrying;
    }

    private <RequestT, ResponseT> ServerStreamingCallable<RequestT, ResponseT> withRetries(ServerStreamingCallable<RequestT, ResponseT> innerCallable, ServerStreamingCallSettings<RequestT, ResponseT> serverStreamingCallSettings) {
        ServerStreamingCallable<RequestT, ResponseT> retrying = this.settings.getEnableRetryInfo() ? Callables.retrying(innerCallable, serverStreamingCallSettings, this.clientContext) : com.google.bigtable.repackaged.com.google.api.gax.rpc.Callables.retrying(innerCallable, serverStreamingCallSettings, this.clientContext);
        if (this.settings.getEnableRoutingCookie()) {
            return new CookiesServerStreamingCallable<RequestT, ResponseT>(retrying);
        }
        return retrying;
    }

    public ServerStreamingCallable<Query, Row> readRowsCallable() {
        return this.readRowsCallable;
    }

    public UnaryCallable<Query, Row> readRowCallable() {
        return this.readRowCallable;
    }

    public UnaryCallable<String, List<KeyOffset>> sampleRowKeysCallable() {
        return this.sampleRowKeysCallable;
    }

    public UnaryCallable<com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.SampleRowKeysRequest, List<KeyOffset>> sampleRowKeysCallableWithRequest() {
        return this.sampleRowKeysCallableWithRequest;
    }

    public UnaryCallable<RowMutation, Void> mutateRowCallable() {
        return this.mutateRowCallable;
    }

    public UnaryCallable<BulkMutation, Void> bulkMutateRowsCallable() {
        return this.externalBulkMutateRowsCallable;
    }

    @InternalApi
    public UnaryCallable<BulkMutation, MutateRowsAttemptResult> internalBulkMutateRowsCallable() {
        return this.bulkMutateRowsCallable;
    }

    public UnaryCallable<ConditionalRowMutation, Boolean> checkAndMutateRowCallable() {
        return this.checkAndMutateRowCallable;
    }

    public UnaryCallable<ReadModifyWriteRow, Row> readModifyWriteRowCallable() {
        return this.readModifyWriteRowCallable;
    }

    public ServerStreamingCallable<String, Range.ByteStringRange> generateInitialChangeStreamPartitionsCallable() {
        return this.generateInitialChangeStreamPartitionsCallable;
    }

    public ServerStreamingCallable<ReadChangeStreamQuery, ChangeStreamRecord> readChangeStreamCallable() {
        return this.readChangeStreamCallable;
    }

    UnaryCallable<PingAndWarmRequest, PingAndWarmResponse> pingAndWarmCallable() {
        return this.pingAndWarmCallable;
    }

    private SpanName getSpanName(String methodName) {
        return SpanName.of(CLIENT_NAME, methodName);
    }

    @Override
    public void close() {
        if (this.closeClientContext) {
            for (BackgroundResource backgroundResource : this.clientContext.getBackgroundResources()) {
                try {
                    backgroundResource.close();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to close resource", e);
                }
            }
        }
    }
}

