/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.auth.Credentials;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.BuiltinMetricsView;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.MetricsProvider;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.io.opentelemetry.api.OpenTelemetry;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.OpenTelemetrySdk;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.SdkMeterProvider;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import java.io.IOException;
import javax.annotation.Nullable;

public final class DefaultMetricsProvider
implements MetricsProvider {
    public static DefaultMetricsProvider INSTANCE = new DefaultMetricsProvider();
    private OpenTelemetry openTelemetry;
    private String projectId;

    private DefaultMetricsProvider() {
    }

    @InternalApi
    public OpenTelemetry getOpenTelemetry(String projectId, @Nullable Credentials credentials) throws IOException {
        this.projectId = projectId;
        if (this.openTelemetry == null) {
            SdkMeterProviderBuilder meterProvider = SdkMeterProvider.builder();
            BuiltinMetricsView.registerBuiltinMetrics(projectId, credentials, meterProvider);
            this.openTelemetry = OpenTelemetrySdk.builder().setMeterProvider(meterProvider.build()).build();
        }
        return this.openTelemetry;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("projectId", this.projectId).add("openTelemetry", this.openTelemetry).toString();
    }
}

