/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opencensus.implcore.tags.propagation;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Charsets;
import com.google.bigtable.repackaged.com.google.common.io.ByteArrayDataOutput;
import com.google.bigtable.repackaged.com.google.common.io.ByteStreams;
import com.google.bigtable.repackaged.io.opencensus.implcore.internal.VarInt;
import com.google.bigtable.repackaged.io.opencensus.implcore.tags.TagMapImpl;
import com.google.bigtable.repackaged.io.opencensus.implcore.tags.TagValueWithMetadata;
import com.google.bigtable.repackaged.io.opencensus.tags.InternalUtils;
import com.google.bigtable.repackaged.io.opencensus.tags.Tag;
import com.google.bigtable.repackaged.io.opencensus.tags.TagContext;
import com.google.bigtable.repackaged.io.opencensus.tags.TagKey;
import com.google.bigtable.repackaged.io.opencensus.tags.TagMetadata;
import com.google.bigtable.repackaged.io.opencensus.tags.TagValue;
import com.google.bigtable.repackaged.io.opencensus.tags.propagation.TagContextDeserializationException;
import com.google.bigtable.repackaged.io.opencensus.tags.propagation.TagContextSerializationException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

final class BinarySerializationUtils {
    private static final TagMetadata METADATA_UNLIMITED_PROPAGATION = TagMetadata.create(TagMetadata.TagTtl.UNLIMITED_PROPAGATION);
    @VisibleForTesting
    static final int VERSION_ID = 0;
    @VisibleForTesting
    static final int TAG_FIELD_ID = 0;
    @VisibleForTesting
    static final int TAGCONTEXT_SERIALIZED_SIZE_LIMIT = 8192;

    private BinarySerializationUtils() {
    }

    static byte[] serializeBinary(TagContext tags) throws TagContextSerializationException {
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.write(0);
        int totalChars = 0;
        Iterator<Tag> i = InternalUtils.getTags(tags);
        while (i.hasNext()) {
            Tag tag = i.next();
            if (TagMetadata.TagTtl.NO_PROPAGATION.equals((Object)tag.getTagMetadata().getTagTtl())) continue;
            totalChars += tag.getKey().getName().length();
            totalChars += tag.getValue().asString().length();
            BinarySerializationUtils.encodeTag(tag, byteArrayDataOutput);
        }
        if (totalChars > 8192) {
            throw new TagContextSerializationException("Size of TagContext exceeds the maximum serialized size 8192");
        }
        return byteArrayDataOutput.toByteArray();
    }

    static TagMapImpl deserializeBinary(byte[] bytes) throws TagContextDeserializationException {
        try {
            if (bytes.length == 0) {
                throw new TagContextDeserializationException("Input byte[] can not be empty.");
            }
            ByteBuffer buffer = ByteBuffer.wrap(bytes).asReadOnlyBuffer();
            byte versionId = buffer.get();
            if (versionId > 0 || versionId < 0) {
                throw new TagContextDeserializationException("Wrong Version ID: " + versionId + ". Currently supports version up to: " + 0);
            }
            return new TagMapImpl(BinarySerializationUtils.parseTags(buffer));
        }
        catch (BufferUnderflowException exn) {
            throw new TagContextDeserializationException(exn.toString());
        }
    }

    private static Map<TagKey, TagValueWithMetadata> parseTags(ByteBuffer buffer) throws TagContextDeserializationException {
        byte type;
        HashMap<TagKey, TagValueWithMetadata> tags = new HashMap<TagKey, TagValueWithMetadata>();
        int limit = buffer.limit();
        int totalChars = 0;
        while (buffer.position() < limit && (type = buffer.get()) == 0) {
            TagKey key = BinarySerializationUtils.createTagKey(BinarySerializationUtils.decodeString(buffer));
            TagValue val = BinarySerializationUtils.createTagValue(key, BinarySerializationUtils.decodeString(buffer));
            totalChars += key.getName().length();
            totalChars += val.asString().length();
            tags.put(key, TagValueWithMetadata.create(val, METADATA_UNLIMITED_PROPAGATION));
        }
        if (totalChars > 8192) {
            throw new TagContextDeserializationException("Size of TagContext exceeds the maximum serialized size 8192");
        }
        return tags;
    }

    private static final TagKey createTagKey(String name) throws TagContextDeserializationException {
        try {
            return TagKey.create(name);
        }
        catch (IllegalArgumentException e) {
            throw new TagContextDeserializationException("Invalid tag key: " + name, e);
        }
    }

    private static final TagValue createTagValue(TagKey key, String value) throws TagContextDeserializationException {
        try {
            return TagValue.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new TagContextDeserializationException("Invalid tag value for key " + key + ": " + value, e);
        }
    }

    private static final void encodeTag(Tag tag, ByteArrayDataOutput byteArrayDataOutput) {
        byteArrayDataOutput.write(0);
        BinarySerializationUtils.encodeString(tag.getKey().getName(), byteArrayDataOutput);
        BinarySerializationUtils.encodeString(tag.getValue().asString(), byteArrayDataOutput);
    }

    private static final void encodeString(String input, ByteArrayDataOutput byteArrayDataOutput) {
        BinarySerializationUtils.putVarInt(input.length(), byteArrayDataOutput);
        byteArrayDataOutput.write(input.getBytes(Charsets.UTF_8));
    }

    private static final void putVarInt(int input, ByteArrayDataOutput byteArrayDataOutput) {
        byte[] output = new byte[VarInt.varIntSize(input)];
        VarInt.putVarInt(input, output, 0);
        byteArrayDataOutput.write(output);
    }

    private static final String decodeString(ByteBuffer buffer) {
        int length = VarInt.getVarInt(buffer);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append((char)buffer.get());
        }
        return builder.toString();
    }
}

