/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opentelemetry.sdk.logs.internal;

import com.google.bigtable.repackaged.io.opentelemetry.api.common.AttributeKey;
import com.google.bigtable.repackaged.io.opentelemetry.api.common.Attributes;
import com.google.bigtable.repackaged.io.opentelemetry.api.incubator.events.EventBuilder;
import com.google.bigtable.repackaged.io.opentelemetry.api.incubator.logs.AnyValue;
import com.google.bigtable.repackaged.io.opentelemetry.api.incubator.logs.ExtendedLogRecordBuilder;
import com.google.bigtable.repackaged.io.opentelemetry.api.logs.LogRecordBuilder;
import com.google.bigtable.repackaged.io.opentelemetry.api.logs.Severity;
import com.google.bigtable.repackaged.io.opentelemetry.context.Context;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.common.Clock;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

class SdkEventBuilder
implements EventBuilder {
    private static final AttributeKey<String> EVENT_NAME = AttributeKey.stringKey("event.name");
    private final Map<String, AnyValue<?>> payload = new HashMap();
    private final Clock clock;
    private final LogRecordBuilder logRecordBuilder;
    private final String eventName;
    private boolean hasTimestamp = false;

    SdkEventBuilder(Clock clock, LogRecordBuilder logRecordBuilder, String eventName) {
        this.clock = clock;
        this.logRecordBuilder = logRecordBuilder;
        this.eventName = eventName;
    }

    @Override
    public EventBuilder put(String key, AnyValue<?> value) {
        this.payload.put(key, value);
        return this;
    }

    @Override
    public EventBuilder setTimestamp(long timestamp, TimeUnit unit) {
        this.logRecordBuilder.setTimestamp(timestamp, unit);
        this.hasTimestamp = true;
        return this;
    }

    @Override
    public EventBuilder setTimestamp(Instant instant) {
        this.logRecordBuilder.setTimestamp(instant);
        this.hasTimestamp = true;
        return this;
    }

    @Override
    public EventBuilder setContext(Context context) {
        this.logRecordBuilder.setContext(context);
        return this;
    }

    @Override
    public EventBuilder setSeverity(Severity severity) {
        this.logRecordBuilder.setSeverity(severity);
        return this;
    }

    @Override
    public EventBuilder setAttributes(Attributes attributes) {
        this.logRecordBuilder.setAllAttributes(attributes);
        return this;
    }

    @Override
    public void emit() {
        if (!this.payload.isEmpty()) {
            ((ExtendedLogRecordBuilder)this.logRecordBuilder).setBody(AnyValue.of(this.payload));
        }
        if (!this.hasTimestamp) {
            this.logRecordBuilder.setTimestamp(this.clock.now(), TimeUnit.NANOSECONDS);
        }
        this.logRecordBuilder.setAttribute(EVENT_NAME, this.eventName);
        this.logRecordBuilder.emit();
    }
}

