/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.state;

import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.View;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.data.ExemplarData;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.data.PointData;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.export.RegisteredReader;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.state.DefaultSynchronousMetricStorage;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.state.EmptyMetricStorage;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.state.MetricStorage;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.view.RegisteredView;

public interface SynchronousMetricStorage
extends MetricStorage,
WriteableMetricStorage {
    public static SynchronousMetricStorage empty() {
        return EmptyMetricStorage.INSTANCE;
    }

    public static <T extends PointData, U extends ExemplarData> SynchronousMetricStorage create(RegisteredReader registeredReader, RegisteredView registeredView, InstrumentDescriptor instrumentDescriptor, ExemplarFilter exemplarFilter) {
        View view = registeredView.getView();
        MetricDescriptor metricDescriptor = MetricDescriptor.create(view, registeredView.getViewSourceInfo(), instrumentDescriptor);
        Aggregator aggregator = ((AggregatorFactory)((Object)view.getAggregation())).createAggregator(instrumentDescriptor, exemplarFilter, registeredReader.getReader().getMemoryMode());
        if (Aggregator.drop() == aggregator) {
            return SynchronousMetricStorage.empty();
        }
        return new DefaultSynchronousMetricStorage(registeredReader, metricDescriptor, aggregator, registeredView.getViewAttributesProcessor(), registeredView.getCardinalityLimit());
    }
}

