/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.view;

import com.google.bigtable.repackaged.io.opentelemetry.sdk.common.export.MemoryMode;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.Aggregation;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.InstrumentType;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.data.ExemplarData;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.data.PointData;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.aggregator.DoubleLastValueAggregator;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.aggregator.LongLastValueAggregator;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;

public final class LastValueAggregation
implements Aggregation,
AggregatorFactory {
    private static final Aggregation INSTANCE = new LastValueAggregation();

    public static Aggregation getInstance() {
        return INSTANCE;
    }

    private LastValueAggregation() {
    }

    @Override
    public <T extends PointData, U extends ExemplarData> Aggregator<T, U> createAggregator(InstrumentDescriptor instrumentDescriptor, ExemplarFilter exemplarFilter, MemoryMode memoryMode) {
        switch (instrumentDescriptor.getValueType()) {
            case LONG: {
                return new LongLastValueAggregator(ExemplarReservoir::longNoSamples, memoryMode);
            }
            case DOUBLE: {
                return new DoubleLastValueAggregator(ExemplarReservoir::doubleNoSamples, memoryMode);
            }
        }
        throw new IllegalArgumentException("Invalid instrument value type");
    }

    @Override
    public boolean isCompatibleWithInstrument(InstrumentDescriptor instrumentDescriptor) {
        return instrumentDescriptor.getType() == InstrumentType.OBSERVABLE_GAUGE;
    }

    public String toString() {
        return "LastValueAggregation";
    }
}

