/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opentelemetry.sdk.trace;

import com.google.bigtable.repackaged.io.opentelemetry.api.trace.SpanBuilder;
import com.google.bigtable.repackaged.io.opentelemetry.api.trace.Tracer;
import com.google.bigtable.repackaged.io.opentelemetry.api.trace.TracerProvider;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.trace.SdkSpanBuilder;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.trace.TracerSharedState;

final class SdkTracer
implements Tracer {
    static final String FALLBACK_SPAN_NAME = "<unspecified span name>";
    private final TracerSharedState sharedState;
    private final InstrumentationScopeInfo instrumentationScopeInfo;

    SdkTracer(TracerSharedState sharedState, InstrumentationScopeInfo instrumentationScopeInfo) {
        this.sharedState = sharedState;
        this.instrumentationScopeInfo = instrumentationScopeInfo;
    }

    @Override
    public SpanBuilder spanBuilder(String spanName) {
        if (spanName == null || spanName.trim().isEmpty()) {
            spanName = FALLBACK_SPAN_NAME;
        }
        if (this.sharedState.hasBeenShutdown()) {
            Tracer tracer = TracerProvider.noop().get(this.instrumentationScopeInfo.getName());
            return tracer.spanBuilder(spanName);
        }
        return new SdkSpanBuilder(spanName, this.instrumentationScopeInfo, this.sharedState, this.sharedState.getSpanLimits());
    }

    InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }
}

