/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.api.gax.nativeimage;

import com.google.bigtable.repackaged.com.google.api.gax.nativeimage.NativeImageUtils;
import org.graalvm.nativeimage.hosted.Feature;

final class GoogleJsonClientFeature
implements Feature {
    private static final String GOOGLE_API_CLIENT_CLASS = "com.google.bigtable.repackaged.com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient";
    private static final String GOOGLE_API_CLIENT_REQUEST_CLASS = "com.google.bigtable.repackaged.com.google.api.client.googleapis.services.json.AbstractGoogleJsonClientRequest";
    private static final String GENERIC_JSON_CLASS = "com.google.bigtable.repackaged.com.google.api.client.json.GenericJson";

    GoogleJsonClientFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        this.loadApiClient(access);
        this.loadHttpClient(access);
        this.loadMiscClasses(access);
    }

    private void loadApiClient(Feature.BeforeAnalysisAccess access) {
        Class googleApiClientClass = access.findClassByName(GOOGLE_API_CLIENT_CLASS);
        if (googleApiClientClass != null) {
            access.registerSubtypeReachabilityHandler((duringAccess, subtype) -> NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, subtype.getName()), googleApiClientClass);
            access.registerSubtypeReachabilityHandler((duringAccess, subtype) -> NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, subtype.getName()), access.findClassByName(GOOGLE_API_CLIENT_REQUEST_CLASS));
        }
    }

    private void loadHttpClient(Feature.BeforeAnalysisAccess access) {
        Class genericJsonClass = access.findClassByName(GENERIC_JSON_CLASS);
        if (genericJsonClass != null) {
            access.registerSubtypeReachabilityHandler((duringAccess, subtype) -> NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, subtype.getName()), genericJsonClass);
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "com.google.bigtable.repackaged.com.google.api.client.util.GenericData");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "com.google.bigtable.repackaged.com.google.api.client.json.webtoken.JsonWebToken");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "com.google.bigtable.repackaged.com.google.api.client.json.webtoken.JsonWebToken$Header");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "com.google.bigtable.repackaged.com.google.api.client.json.webtoken.JsonWebToken$Payload");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "com.google.bigtable.repackaged.com.google.api.client.json.webtoken.JsonWebSignature$Header");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "com.google.bigtable.repackaged.com.google.api.client.json.webtoken.JsonWebSignature");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "com.google.bigtable.repackaged.com.google.api.client.http.UrlEncodedContent");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "com.google.bigtable.repackaged.com.google.api.client.http.GenericUrl");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "com.google.bigtable.repackaged.com.google.api.client.http.HttpRequest");
            NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "com.google.bigtable.repackaged.com.google.api.client.http.HttpHeaders");
        }
    }

    private void loadMiscClasses(Feature.BeforeAnalysisAccess access) {
        NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "com.google.bigtable.repackaged.com.google.common.util.concurrent.AbstractFuture");
        NativeImageUtils.registerClassForReflection((Feature.FeatureAccess)access, "com.google.bigtable.repackaged.com.google.common.util.concurrent.AbstractFuture$Waiter");
    }
}

