/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.api.gax.rpc;

import com.google.bigtable.repackaged.com.google.api.core.ApiFuture;
import com.google.bigtable.repackaged.com.google.api.core.ApiFutures;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.NonCancellableFuture;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.RetryingFuture;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiCallContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.concurrent.Callable;

class CheckingAttemptCallable<RequestT, ResponseT>
implements Callable<ResponseT> {
    private final UnaryCallable<RequestT, ResponseT> callable;
    private final ApiCallContext originalCallContext;
    private volatile RetryingFuture<ResponseT> externalFuture;

    CheckingAttemptCallable(UnaryCallable<RequestT, ResponseT> callable, ApiCallContext callContext) {
        this.callable = Preconditions.checkNotNull(callable);
        this.originalCallContext = Preconditions.checkNotNull(callContext);
    }

    public void setExternalFuture(RetryingFuture<ResponseT> externalFuture) {
        this.externalFuture = Preconditions.checkNotNull(externalFuture);
    }

    @Override
    public ResponseT call() {
        ApiCallContext callContext = this.originalCallContext;
        try {
            Duration rpcTimeout = this.externalFuture.getAttemptSettings().getRpcTimeoutDuration();
            if (!rpcTimeout.isZero()) {
                callContext = callContext.withTimeoutDuration(rpcTimeout);
            }
            this.externalFuture.setAttemptFuture(new NonCancellableFuture());
            if (this.externalFuture.isDone()) {
                return null;
            }
            callContext.getTracer().attemptStarted(this.externalFuture.getAttemptSettings().getOverallAttemptCount());
            ApiFuture<ResponseT> internalFuture = this.callable.futureCall(null, callContext);
            this.externalFuture.setAttemptFuture(internalFuture);
        }
        catch (Throwable e) {
            this.externalFuture.setAttemptFuture(ApiFutures.immediateFailedFuture(e));
        }
        return null;
    }
}

