/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.auth.oauth2;

import com.google.bigtable.repackaged.com.google.api.client.json.GenericJson;
import com.google.bigtable.repackaged.com.google.auth.oauth2.PluggableAuthException;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.Instant;
import javax.annotation.Nullable;

class ExecutableResponse {
    private static final String SAML_SUBJECT_TOKEN_TYPE = "urn:ietf:params:oauth:token-type:saml2";
    private final int version;
    private final boolean success;
    @Nullable
    private Long expirationTime;
    @Nullable
    private String tokenType;
    @Nullable
    private String subjectToken;
    @Nullable
    private String errorCode;
    @Nullable
    private String errorMessage;

    ExecutableResponse(GenericJson json) throws IOException {
        if (!json.containsKey("version")) {
            throw new PluggableAuthException("INVALID_EXECUTABLE_RESPONSE", "The executable response is missing the `version` field.");
        }
        if (!json.containsKey("success")) {
            throw new PluggableAuthException("INVALID_EXECUTABLE_RESPONSE", "The executable response is missing the `success` field.");
        }
        this.version = ExecutableResponse.parseIntField(json.get("version"));
        this.success = (Boolean)json.get("success");
        if (this.success) {
            if (!json.containsKey("token_type")) {
                throw new PluggableAuthException("INVALID_EXECUTABLE_RESPONSE", "The executable response is missing the `token_type` field.");
            }
            this.tokenType = (String)json.get("token_type");
            if (json.containsKey("expiration_time")) {
                this.expirationTime = ExecutableResponse.parseLongField(json.get("expiration_time"));
            }
            this.subjectToken = SAML_SUBJECT_TOKEN_TYPE.equals(this.tokenType) ? (String)json.get("saml_response") : (String)json.get("id_token");
            if (this.subjectToken == null || this.subjectToken.isEmpty()) {
                throw new PluggableAuthException("INVALID_EXECUTABLE_RESPONSE", "The executable response does not contain a valid token.");
            }
        } else {
            this.errorCode = (String)json.get("code");
            this.errorMessage = (String)json.get("message");
            if (this.errorCode == null || this.errorCode.isEmpty() || this.errorMessage == null || this.errorMessage.isEmpty()) {
                throw new PluggableAuthException("INVALID_EXECUTABLE_RESPONSE", "The executable response must contain `error` and `message` fields when unsuccessful.");
            }
        }
    }

    int getVersion() {
        return this.version;
    }

    boolean isSuccessful() {
        return this.success;
    }

    boolean isExpired() {
        return this.expirationTime != null && this.expirationTime <= Instant.now().getEpochSecond();
    }

    boolean isValid() {
        return this.isSuccessful() && !this.isExpired();
    }

    @Nullable
    Long getExpirationTime() {
        return this.expirationTime;
    }

    @Nullable
    String getTokenType() {
        return this.tokenType;
    }

    @Nullable
    String getSubjectToken() {
        return this.subjectToken;
    }

    @Nullable
    String getErrorCode() {
        return this.errorCode;
    }

    @Nullable
    String getErrorMessage() {
        return this.errorMessage;
    }

    private static int parseIntField(Object field) {
        if (field instanceof String) {
            return Integer.parseInt((String)field);
        }
        if (field instanceof BigDecimal) {
            return ((BigDecimal)field).intValue();
        }
        return (Integer)field;
    }

    private static long parseLongField(Object field) {
        if (field instanceof String) {
            return Long.parseLong((String)field);
        }
        if (field instanceof BigDecimal) {
            return ((BigDecimal)field).longValue();
        }
        return (Long)field;
    }
}

