/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.bigtable.admin.v2;

import com.google.bigtable.repackaged.com.google.api.pathtemplate.PathTemplate;
import com.google.bigtable.repackaged.com.google.api.resourcenames.ResourceName;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ClusterName
implements ResourceName {
    private static final PathTemplate PROJECT_INSTANCE_CLUSTER = PathTemplate.createWithoutUrlEncoding("projects/{project}/instances/{instance}/clusters/{cluster}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String instance;
    private final String cluster;

    @Deprecated
    protected ClusterName() {
        this.project = null;
        this.instance = null;
        this.cluster = null;
    }

    private ClusterName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.instance = Preconditions.checkNotNull(builder.getInstance());
        this.cluster = Preconditions.checkNotNull(builder.getCluster());
    }

    public String getProject() {
        return this.project;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getCluster() {
        return this.cluster;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ClusterName of(String project, String instance, String cluster) {
        return ClusterName.newBuilder().setProject(project).setInstance(instance).setCluster(cluster).build();
    }

    public static String format(String project, String instance, String cluster) {
        return ClusterName.newBuilder().setProject(project).setInstance(instance).setCluster(cluster).build().toString();
    }

    public static ClusterName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map<String, String> matchMap = PROJECT_INSTANCE_CLUSTER.validatedMatch(formattedString, "ClusterName.parse: formattedString not in valid format");
        return ClusterName.of(matchMap.get("project"), matchMap.get("instance"), matchMap.get("cluster"));
    }

    public static List<ClusterName> parseList(List<String> formattedStrings) {
        ArrayList<ClusterName> list = new ArrayList<ClusterName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ClusterName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ClusterName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ClusterName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_INSTANCE_CLUSTER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ClusterName clusterName = this;
            synchronized (clusterName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put("project", this.project);
                    }
                    if (this.instance != null) {
                        fieldMapBuilder.put("instance", this.instance);
                    }
                    if (this.cluster != null) {
                        fieldMapBuilder.put("cluster", this.cluster);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_INSTANCE_CLUSTER.instantiate("project", this.project, "instance", this.instance, "cluster", this.cluster);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ClusterName that = (ClusterName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.instance, that.instance) && Objects.equals(this.cluster, that.cluster);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.instance);
        h *= 1000003;
        return h ^= Objects.hashCode(this.cluster);
    }

    public static class Builder {
        private String project;
        private String instance;
        private String cluster;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getInstance() {
            return this.instance;
        }

        public String getCluster() {
            return this.cluster;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder setCluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        private Builder(ClusterName clusterName) {
            this.project = clusterName.project;
            this.instance = clusterName.instance;
            this.cluster = clusterName.cluster;
        }

        public ClusterName build() {
            return new ClusterName(this);
        }
    }
}

