/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2;

import com.google.bigtable.repackaged.com.google.api.gax.core.CredentialsProvider;
import com.google.bigtable.repackaged.com.google.api.gax.core.NoCredentialsProvider;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.ChannelPoolSettings;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.stub.BigtableTableAdminStubSettings;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Strings;
import com.google.bigtable.repackaged.com.google.common.base.Verify;
import com.google.bigtable.repackaged.io.grpc.ManagedChannelBuilder;
import java.io.IOException;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class BigtableTableAdminSettings {
    private static final Logger LOGGER = Logger.getLogger(BigtableTableAdminSettings.class.getName());
    static final String BIGTABLE_EMULATOR_HOST_ENV_VAR = "BIGTABLE_EMULATOR_HOST";
    private final String projectId;
    private final String instanceId;
    private final BigtableTableAdminStubSettings stubSettings;

    private BigtableTableAdminSettings(Builder builder) throws IOException {
        this.projectId = Preconditions.checkNotNull(builder.projectId, "Project ID must be set");
        this.instanceId = Preconditions.checkNotNull(builder.instanceId, "Instance ID must be set");
        this.stubSettings = Verify.verifyNotNull(builder.stubSettings, "stubSettings should never be null", new Object[0]).build();
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.stubSettings.getCredentialsProvider();
    }

    public BigtableTableAdminStubSettings getStubSettings() {
        return this.stubSettings;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("projectId", this.projectId).add("instanceId", this.instanceId).add("createTableSettings", this.stubSettings.createTableSettings()).add("createTableFromSnapshotSettings", this.stubSettings.createTableFromSnapshotSettings()).add("createTableFromSnapshotOperationSettings", this.stubSettings.createTableFromSnapshotOperationSettings()).add("listTablesSettings", this.stubSettings.listTablesSettings()).add("getTableSettings", this.stubSettings.getTableSettings()).add("deleteTableSettings", this.stubSettings.deleteTableSettings()).add("modifyColumnFamiliesSettings", this.stubSettings.modifyColumnFamiliesSettings()).add("dropRowRangeSettings", this.stubSettings.dropRowRangeSettings()).add("generateConsistencyTokenSettings", this.stubSettings.generateConsistencyTokenSettings()).add("checkConsistencySettings", this.stubSettings.checkConsistencySettings()).add("getIamPolicySettings", this.stubSettings.getIamPolicySettings()).add("setIamPolicySettings", this.stubSettings.setIamPolicySettings()).add("testIamPermissionsSettings", this.stubSettings.testIamPermissionsSettings()).add("snapshotTableSettings", this.stubSettings.snapshotTableSettings()).add("snapshotTableOperationSettings", this.stubSettings.snapshotTableOperationSettings()).add("getSnapshotSettings", this.stubSettings.getSnapshotSettings()).add("listSnapshotsSettings", this.stubSettings.listSnapshotsSettings()).add("deleteSnapshotSettings", this.stubSettings.deleteSnapshotSettings()).add("copyBackupSettings", this.stubSettings.copyBackupSettings()).add("copyBackupOperationSettings", this.stubSettings.copyBackupOperationSettings()).add("createBackupSettings", this.stubSettings.createBackupSettings()).add("createBackupOperationSettings", this.stubSettings.createBackupOperationSettings()).add("getBackupSettings", this.stubSettings.getBackupSettings()).add("listBackupsSettings", this.stubSettings.listBackupsSettings()).add("updateBackupSettings", this.stubSettings.updateBackupSettings()).add("deleteBackupSettings", this.stubSettings.deleteBackupSettings()).add("restoreTableSettings", this.stubSettings.restoreTableSettings()).add("restoreTableOperationSettings", this.stubSettings.restoreTableOperationSettings()).add("stubSettings", this.stubSettings).add("undeleteTableSettings", this.stubSettings.undeleteTableSettings()).add("undeleteTableOperationSettings", this.stubSettings.undeleteTableOperationSettings()).add("updateTableSettings", this.stubSettings.updateTableSettings()).add("updateTableOperationSettings", this.stubSettings.updateTableOperationSettings()).add("copyBackupSettings", this.stubSettings.copyBackupSettings()).add("copyBackupOperationSettings", this.stubSettings.copyBackupOperationSettings()).add("createAuthorizedViewSettings", this.stubSettings.createAuthorizedViewSettings()).add("createAuthorizedViewOperationSettings", this.stubSettings.createAuthorizedViewOperationSettings()).add("updateAuthorizedViewSettings", this.stubSettings.updateAuthorizedViewSettings()).add("updateAuthorizedViewOperationSettings", this.stubSettings.updateAuthorizedViewOperationSettings()).add("deleteAuthorizedViewSettings", this.stubSettings.deleteAuthorizedViewSettings()).add("listAuthorizedViewsSettings", this.stubSettings.listAuthorizedViewsSettings()).add("getAuthorizedViewSettings", this.stubSettings.getAuthorizedViewSettings()).toString();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        String hostAndPort = System.getenv(BIGTABLE_EMULATOR_HOST_ENV_VAR);
        if (!Strings.isNullOrEmpty(hostAndPort)) {
            try {
                int port = Integer.parseInt(hostAndPort.substring(hostAndPort.lastIndexOf(":") + 1));
                return BigtableTableAdminSettings.newBuilderForEmulator(hostAndPort.substring(0, hostAndPort.lastIndexOf(":")), port);
            }
            catch (IndexOutOfBoundsException | NumberFormatException ex) {
                throw new RuntimeException("Invalid host/port in BIGTABLE_EMULATOR_HOST environment variable: " + hostAndPort);
            }
        }
        return new Builder();
    }

    public static Builder newBuilderForEmulator(int port) {
        return BigtableTableAdminSettings.newBuilderForEmulator("localhost", port);
    }

    public static Builder newBuilderForEmulator(String hostname, int port) {
        Builder builder = new Builder();
        ((BigtableTableAdminStubSettings.Builder)((BigtableTableAdminStubSettings.Builder)builder.stubSettings().setCredentialsProvider(NoCredentialsProvider.create())).setEndpoint(hostname + ":" + port)).setTransportChannelProvider(InstantiatingGrpcChannelProvider.newBuilder().setChannelPoolSettings(ChannelPoolSettings.staticallySized(1)).setChannelConfigurator(ManagedChannelBuilder::usePlaintext).build());
        LOGGER.info("Connecting to the Bigtable emulator at " + hostname + ":" + port);
        return builder;
    }

    public static final class Builder {
        @Nullable
        private String projectId;
        @Nullable
        private String instanceId;
        private final BigtableTableAdminStubSettings.Builder stubSettings;

        private Builder() {
            this.stubSettings = BigtableTableAdminStubSettings.newBuilder();
        }

        private Builder(BigtableTableAdminSettings settings) {
            this.projectId = settings.projectId;
            this.instanceId = settings.instanceId;
            this.stubSettings = settings.stubSettings.toBuilder();
        }

        public Builder setProjectId(@Nullable String projectId) {
            Preconditions.checkNotNull(projectId);
            this.projectId = projectId;
            return this;
        }

        @Nullable
        public String getProjectId() {
            return this.projectId;
        }

        public Builder setInstanceId(@Nullable String instanceId) {
            Preconditions.checkNotNull(instanceId);
            this.instanceId = instanceId;
            return this;
        }

        @Nullable
        public String getInstanceId() {
            return this.instanceId;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.stubSettings.setCredentialsProvider(credentialsProvider);
            return this;
        }

        public CredentialsProvider getCredentialsProvider() {
            return this.stubSettings.getCredentialsProvider();
        }

        public BigtableTableAdminStubSettings.Builder stubSettings() {
            return this.stubSettings;
        }

        public BigtableTableAdminSettings build() throws IOException {
            return new BigtableTableAdminSettings(this);
        }
    }
}

