/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.CreateBackupRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.Backup;
import com.google.bigtable.repackaged.com.google.common.base.Objects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.protobuf.util.Timestamps;
import com.google.bigtable.repackaged.org.threeten.bp.Instant;
import javax.annotation.Nonnull;

public final class CreateBackupRequest {
    private final CreateBackupRequest.Builder requestBuilder = com.google.bigtable.repackaged.com.google.bigtable.admin.v2.CreateBackupRequest.newBuilder();
    private final String clusterId;
    private String sourceTableId;

    public static CreateBackupRequest of(String clusterId, String backupId) {
        CreateBackupRequest request = new CreateBackupRequest(clusterId, backupId);
        return request;
    }

    private CreateBackupRequest(String clusterId, String backupId) {
        Preconditions.checkNotNull(clusterId);
        Preconditions.checkNotNull(backupId);
        this.requestBuilder.setBackupId(backupId);
        this.clusterId = clusterId;
        this.sourceTableId = null;
    }

    public CreateBackupRequest setSourceTableId(String sourceTableId) {
        Preconditions.checkNotNull(sourceTableId);
        this.sourceTableId = sourceTableId;
        return this;
    }

    public CreateBackupRequest setExpireTime(Instant expireTime) {
        Preconditions.checkNotNull(expireTime);
        this.requestBuilder.getBackupBuilder().setExpireTime(Timestamps.fromMillis(expireTime.toEpochMilli()));
        return this;
    }

    public CreateBackupRequest setBackupType(Backup.BackupType backupType) {
        Preconditions.checkNotNull(backupType);
        this.requestBuilder.getBackupBuilder().setBackupType(backupType.toProto());
        return this;
    }

    public CreateBackupRequest setHotToStandardTime(Instant hotToStandardTime) {
        Preconditions.checkNotNull(hotToStandardTime);
        this.requestBuilder.getBackupBuilder().setHotToStandardTime(Timestamps.fromMillis(hotToStandardTime.toEpochMilli()));
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateBackupRequest that = (CreateBackupRequest)o;
        return Objects.equal(this.requestBuilder.getBackupId(), that.requestBuilder.getBackupId()) && Objects.equal(this.clusterId, that.clusterId) && Objects.equal(this.sourceTableId, that.sourceTableId) && Objects.equal(this.requestBuilder.getBackup().getBackupType(), that.requestBuilder.getBackup().getBackupType()) && Objects.equal(this.requestBuilder.getBackup().getHotToStandardTime(), that.requestBuilder.getBackup().getHotToStandardTime());
    }

    public int hashCode() {
        return Objects.hashCode(this.requestBuilder.getBackupId(), this.clusterId, this.sourceTableId, this.requestBuilder.getBackup().getBackupType(), this.requestBuilder.getBackup().getHotToStandardTime());
    }

    @InternalApi
    public com.google.bigtable.repackaged.com.google.bigtable.admin.v2.CreateBackupRequest toProto(@Nonnull String projectId, @Nonnull String instanceId) {
        Preconditions.checkNotNull(projectId);
        Preconditions.checkNotNull(instanceId);
        this.requestBuilder.getBackupBuilder().setSourceTable(NameUtil.formatTableName(projectId, instanceId, this.sourceTableId));
        return this.requestBuilder.setParent(NameUtil.formatClusterName(projectId, instanceId, this.clusterId)).build();
    }
}

