/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ChangeStreamConfig;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.UpdateTableRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.protobuf.Duration;
import java.util.Objects;

public class UpdateTableRequest {
    private final String tableId;
    private final UpdateTableRequest.Builder requestBuilder = com.google.bigtable.repackaged.com.google.bigtable.admin.v2.UpdateTableRequest.newBuilder();

    public static UpdateTableRequest of(String tableId) {
        return new UpdateTableRequest(tableId);
    }

    private UpdateTableRequest(String tableId) {
        this.tableId = tableId;
    }

    public UpdateTableRequest addChangeStreamRetention(com.google.bigtable.repackaged.org.threeten.bp.Duration retention) {
        Preconditions.checkNotNull(retention);
        if (!retention.isZero()) {
            this.requestBuilder.getTableBuilder().setChangeStreamConfig(ChangeStreamConfig.newBuilder().setRetentionPeriod(Duration.newBuilder().setSeconds(retention.getSeconds()).setNanos(retention.getNano()).build()).build());
            this.requestBuilder.getUpdateMaskBuilder().addPaths("change_stream_config.retention_period");
        } else {
            this.requestBuilder.getTableBuilder().clearChangeStreamConfig();
            this.requestBuilder.getUpdateMaskBuilder().addPaths("change_stream_config");
        }
        return this;
    }

    public UpdateTableRequest disableChangeStreamRetention() {
        return this.addChangeStreamRetention(com.google.bigtable.repackaged.org.threeten.bp.Duration.ZERO);
    }

    public UpdateTableRequest setDeletionProtection(boolean deletionProtection) {
        this.requestBuilder.getTableBuilder().setDeletionProtection(deletionProtection);
        this.requestBuilder.getUpdateMaskBuilder().addPaths("deletion_protection");
        return this;
    }

    @InternalApi
    public com.google.bigtable.repackaged.com.google.bigtable.admin.v2.UpdateTableRequest toProto(String projectId, String instanceId) {
        this.requestBuilder.getTableBuilder().setName(NameUtil.formatTableName(projectId, instanceId, this.tableId));
        return this.requestBuilder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateTableRequest)) {
            return false;
        }
        UpdateTableRequest that = (UpdateTableRequest)o;
        return Objects.equals(this.requestBuilder, that.requestBuilder);
    }

    public int hashCode() {
        return Objects.hash(this.requestBuilder);
    }
}

