/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.auto.value.AutoValue;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadChangeStreamResponse;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.AutoValue_CloseStream;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.ChangeStreamContinuationToken;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.ChangeStreamRecord;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Range;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.rpc.Status;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nonnull;

@InternalApi(value="Intended for use by the BigtableIO in apache/beam only.")
@AutoValue
public abstract class CloseStream
implements ChangeStreamRecord,
Serializable {
    private static final long serialVersionUID = 7316215828353608505L;

    private static CloseStream create(Status status, List<ChangeStreamContinuationToken> changeStreamContinuationTokens, List<Range.ByteStringRange> newPartitions) {
        if (status.getCode() == 0) {
            Preconditions.checkState(changeStreamContinuationTokens.isEmpty(), "An OK CloseStream should not have continuation tokens.");
        } else {
            Preconditions.checkState(!changeStreamContinuationTokens.isEmpty(), "A non-OK CloseStream should have continuation token(s).");
            Preconditions.checkState(newPartitions.size() == 0 || changeStreamContinuationTokens.size() == newPartitions.size(), "Number of continuation tokens does not match number of new partitions.");
        }
        return new AutoValue_CloseStream(com.google.bigtable.repackaged.com.google.cloud.bigtable.common.Status.fromProto(status), changeStreamContinuationTokens, newPartitions);
    }

    @InternalApi(value="Intended for use by the BigtableIO in apache/beam only.")
    public static CloseStream fromProto(@Nonnull ReadChangeStreamResponse.CloseStream closeStream) {
        return CloseStream.create(closeStream.getStatus(), closeStream.getContinuationTokensList().stream().map(ChangeStreamContinuationToken::fromProto).collect(ImmutableList.toImmutableList()), closeStream.getNewPartitionsList().stream().map(newPartition -> Range.ByteStringRange.create(newPartition.getRowRange().getStartKeyClosed(), newPartition.getRowRange().getEndKeyOpen())).collect(ImmutableList.toImmutableList()));
    }

    @InternalApi(value="Intended for use by the BigtableIO in apache/beam only.")
    @Nonnull
    public abstract com.google.bigtable.repackaged.com.google.cloud.bigtable.common.Status getStatus();

    @InternalApi(value="Intended for use by the BigtableIO in apache/beam only.")
    @Nonnull
    public abstract List<ChangeStreamContinuationToken> getChangeStreamContinuationTokens();

    @InternalApi(value="Intended for use by the BigtableIO in apache/beam only.")
    @Nonnull
    public abstract List<Range.ByteStringRange> getNewPartitions();
}

