/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.BetaApi;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadModifyWriteRowRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadModifyWriteRule;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.TableId;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.TargetId;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Validations;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;

public final class ReadModifyWriteRow
implements Serializable {
    private static final long serialVersionUID = -8150045424541029193L;
    private final TargetId targetId;
    private transient ReadModifyWriteRowRequest.Builder builder = ReadModifyWriteRowRequest.newBuilder();

    private ReadModifyWriteRow(TargetId targetId, ByteString key) {
        Preconditions.checkNotNull(targetId, "target id can't be null.");
        Preconditions.checkNotNull(key, "key can't be null.");
        this.targetId = targetId;
        this.builder.setRowKey(key);
    }

    @Deprecated
    public static ReadModifyWriteRow create(String tableId, String key) {
        Preconditions.checkNotNull(key, "key can't be null.");
        return new ReadModifyWriteRow(TableId.of(tableId), ByteString.copyFromUtf8(key));
    }

    public static ReadModifyWriteRow create(TargetId targetId, String key) {
        return new ReadModifyWriteRow(targetId, ByteString.copyFromUtf8(key));
    }

    @Deprecated
    public static ReadModifyWriteRow create(String tableId, ByteString key) {
        return new ReadModifyWriteRow(TableId.of(tableId), key);
    }

    public static ReadModifyWriteRow create(TargetId targetId, ByteString key) {
        return new ReadModifyWriteRow(targetId, key);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.builder = (ReadModifyWriteRowRequest.Builder)ReadModifyWriteRowRequest.newBuilder().mergeFrom(input);
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
        this.builder.build().writeTo(output);
    }

    public ReadModifyWriteRow append(@Nonnull String familyName, @Nonnull String qualifier, @Nonnull String value) {
        return this.append(familyName, ByteString.copyFromUtf8(qualifier), ByteString.copyFromUtf8(value));
    }

    public ReadModifyWriteRow append(@Nonnull String familyName, @Nonnull ByteString qualifier, @Nonnull ByteString value) {
        Validations.validateFamily(familyName);
        Preconditions.checkNotNull(qualifier, "Qualifier can't be null");
        Preconditions.checkNotNull(value, "Value can't be null");
        Preconditions.checkArgument(!value.isEmpty(), "Value can't be empty");
        ReadModifyWriteRule rule = ReadModifyWriteRule.newBuilder().setFamilyName(familyName).setColumnQualifier(qualifier).setAppendValue(value).build();
        this.builder.addRules(rule);
        return this;
    }

    public ReadModifyWriteRow increment(@Nonnull String familyName, @Nonnull String qualifier, long amount) {
        return this.increment(familyName, ByteString.copyFromUtf8(qualifier), amount);
    }

    public ReadModifyWriteRow increment(@Nonnull String familyName, @Nonnull ByteString qualifier, long amount) {
        Validations.validateFamily(familyName);
        Preconditions.checkNotNull(qualifier, "Qualifier can't be null");
        ReadModifyWriteRule rule = ReadModifyWriteRule.newBuilder().setFamilyName(familyName).setColumnQualifier(qualifier).setIncrementAmount(amount).build();
        this.builder.addRules(rule);
        return this;
    }

    @InternalApi
    public ReadModifyWriteRowRequest toProto(RequestContext requestContext) {
        String resourceName = this.targetId.toResourceName(requestContext.getProjectId(), requestContext.getInstanceId());
        if (this.targetId.scopedForAuthorizedView()) {
            this.builder.setAuthorizedViewName(resourceName);
        } else {
            this.builder.setTableName(resourceName);
        }
        return this.builder.setAppProfileId(requestContext.getAppProfileId()).build();
    }

    @BetaApi
    public static ReadModifyWriteRow fromProto(@Nonnull ReadModifyWriteRowRequest request) {
        String tableName = request.getTableName();
        String authorizedViewName = request.getAuthorizedViewName();
        ReadModifyWriteRow row = ReadModifyWriteRow.create(NameUtil.extractTargetId(tableName, authorizedViewName), request.getRowKey());
        row.builder = request.toBuilder();
        return row;
    }
}

