/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.BetaApi;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Mutation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.MutationApi;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Range;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Value;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import java.io.Serializable;
import javax.annotation.Nonnull;

public class RowMutationEntry
implements MutationApi<RowMutationEntry>,
Serializable {
    private static final long serialVersionUID = 1974738836742298192L;
    static final int MAX_MUTATION = 100000;
    private final ByteString key;
    private final Mutation mutation;

    private RowMutationEntry(@Nonnull ByteString key, @Nonnull Mutation mutation) {
        Preconditions.checkNotNull(key, "Row key can't be null");
        Preconditions.checkNotNull(mutation, "Row mutation can't be null");
        this.key = key;
        this.mutation = mutation;
    }

    public static RowMutationEntry create(@Nonnull String key) {
        Preconditions.checkNotNull(key, "Row key can't be null");
        return RowMutationEntry.create(ByteString.copyFromUtf8(key));
    }

    public static RowMutationEntry create(@Nonnull ByteString key) {
        return new RowMutationEntry(key, Mutation.create());
    }

    @BetaApi
    public static RowMutationEntry createFromMutationUnsafe(@Nonnull ByteString key, @Nonnull Mutation mutation) {
        return new RowMutationEntry(key, mutation);
    }

    @InternalApi(value="For internal usage only")
    public static RowMutationEntry createUnsafe(@Nonnull ByteString key) {
        return new RowMutationEntry(key, Mutation.createUnsafe());
    }

    @Override
    public RowMutationEntry setCell(@Nonnull String familyName, @Nonnull String qualifier, @Nonnull String value) {
        this.mutation.setCell(familyName, qualifier, value);
        return this;
    }

    @Override
    public RowMutationEntry setCell(@Nonnull String familyName, @Nonnull String qualifier, long timestamp, @Nonnull String value) {
        this.mutation.setCell(familyName, qualifier, timestamp, value);
        return this;
    }

    @Override
    public RowMutationEntry setCell(@Nonnull String familyName, @Nonnull ByteString qualifier, @Nonnull ByteString value) {
        this.mutation.setCell(familyName, qualifier, value);
        return this;
    }

    @Override
    public RowMutationEntry setCell(@Nonnull String familyName, @Nonnull ByteString qualifier, long timestamp, @Nonnull ByteString value) {
        this.mutation.setCell(familyName, qualifier, timestamp, value);
        return this;
    }

    @Override
    public RowMutationEntry setCell(@Nonnull String familyName, @Nonnull String qualifier, long value) {
        this.mutation.setCell(familyName, qualifier, value);
        return this;
    }

    @Override
    public RowMutationEntry setCell(@Nonnull String familyName, @Nonnull String qualifier, long timestamp, long value) {
        this.mutation.setCell(familyName, qualifier, timestamp, value);
        return this;
    }

    @Override
    public RowMutationEntry setCell(@Nonnull String familyName, @Nonnull ByteString qualifier, long value) {
        this.mutation.setCell(familyName, qualifier, value);
        return this;
    }

    @Override
    public RowMutationEntry setCell(@Nonnull String familyName, @Nonnull ByteString qualifier, long timestamp, long value) {
        this.mutation.setCell(familyName, qualifier, timestamp, value);
        return this;
    }

    @Override
    public RowMutationEntry deleteCells(@Nonnull String familyName, @Nonnull String qualifier) {
        this.mutation.deleteCells(familyName, qualifier);
        return this;
    }

    @Override
    public RowMutationEntry deleteCells(@Nonnull String familyName, @Nonnull ByteString qualifier) {
        this.mutation.deleteCells(familyName, qualifier);
        return this;
    }

    @Override
    public RowMutationEntry deleteCells(@Nonnull String familyName, @Nonnull ByteString qualifier, @Nonnull Range.TimestampRange timestampRange) {
        this.mutation.deleteCells(familyName, qualifier, timestampRange);
        return this;
    }

    @Override
    public RowMutationEntry deleteFamily(@Nonnull String familyName) {
        this.mutation.deleteFamily(familyName);
        return this;
    }

    @Override
    public RowMutationEntry deleteRow() {
        this.mutation.deleteRow();
        return this;
    }

    @Override
    public RowMutationEntry addToCell(@Nonnull String familyName, @Nonnull Value qualifier, @Nonnull Value timestamp, @Nonnull Value input) {
        this.mutation.addToCell(familyName, qualifier, timestamp, input);
        return this;
    }

    @Override
    public RowMutationEntry mergeToCell(@Nonnull String familyName, @Nonnull Value qualifier, @Nonnull Value timestamp, @Nonnull Value input) {
        this.mutation.mergeToCell(familyName, qualifier, timestamp, input);
        return this;
    }

    @InternalApi
    public MutateRowsRequest.Entry toProto() {
        Preconditions.checkArgument(this.mutation.getMutations().size() <= 100000, String.format("Too many mutations, got %s, limit is %s", this.mutation.getMutations().size(), 100000));
        return MutateRowsRequest.Entry.newBuilder().setRowKey(this.key).addAllMutations(this.mutation.getMutations()).build();
    }
}

