/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub;

import com.google.bigtable.repackaged.com.google.api.core.BetaApi;
import com.google.bigtable.repackaged.com.google.api.core.SettableApiFuture;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.ChannelPrimer;
import com.google.bigtable.repackaged.com.google.auth.Credentials;
import com.google.bigtable.repackaged.com.google.bigtable.v2.BigtableGrpc;
import com.google.bigtable.repackaged.com.google.bigtable.v2.InstanceName;
import com.google.bigtable.repackaged.com.google.bigtable.v2.PingAndWarmRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.PingAndWarmResponse;
import com.google.bigtable.repackaged.io.grpc.CallCredentials;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.ClientCall;
import com.google.bigtable.repackaged.io.grpc.Deadline;
import com.google.bigtable.repackaged.io.grpc.ManagedChannel;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.auth.MoreCallCredentials;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

@BetaApi(value="Channel priming is not currently stable and might change in the future")
class BigtableChannelPrimer
implements ChannelPrimer {
    private static Logger LOG = Logger.getLogger(BigtableChannelPrimer.class.toString());
    static final Metadata.Key<String> REQUEST_PARAMS = Metadata.Key.of("x-goog-request-params", Metadata.ASCII_STRING_MARSHALLER);
    private final PingAndWarmRequest request;
    private final CallCredentials callCredentials;
    private final Map<String, String> headers;

    static BigtableChannelPrimer create(String projectId, String instanceId, String appProfileId, Credentials credentials, Map<String, String> headers) {
        return new BigtableChannelPrimer(projectId, instanceId, appProfileId, credentials, headers);
    }

    BigtableChannelPrimer(String projectId, String instanceId, String appProfileId, Credentials credentials, Map<String, String> headers) {
        this.callCredentials = credentials != null ? MoreCallCredentials.from(credentials) : null;
        this.request = PingAndWarmRequest.newBuilder().setName(InstanceName.format(projectId, instanceId)).setAppProfileId(appProfileId).build();
        this.headers = headers;
    }

    @Override
    public void primeChannel(ManagedChannel managedChannel) {
        try {
            this.primeChannelUnsafe(managedChannel);
        }
        catch (IOException | RuntimeException e) {
            LOG.log(Level.WARNING, "Unexpected error while trying to prime a channel", e);
        }
    }

    private void primeChannelUnsafe(ManagedChannel managedChannel) throws IOException {
        this.sendPrimeRequests(managedChannel);
    }

    private void sendPrimeRequests(ManagedChannel managedChannel) {
        try {
            ClientCall<PingAndWarmRequest, PingAndWarmResponse> clientCall = managedChannel.newCall(BigtableGrpc.getPingAndWarmMethod(), CallOptions.DEFAULT.withCallCredentials(this.callCredentials).withDeadline(Deadline.after(1L, TimeUnit.MINUTES)));
            final SettableApiFuture future = SettableApiFuture.create();
            clientCall.start(new ClientCall.Listener<PingAndWarmResponse>(){
                PingAndWarmResponse response;

                @Override
                public void onMessage(PingAndWarmResponse message) {
                    this.response = message;
                }

                @Override
                public void onClose(Status status, Metadata trailers) {
                    if (status.isOk()) {
                        future.set(this.response);
                    } else {
                        future.setException(status.asException());
                    }
                }
            }, BigtableChannelPrimer.createMetadata(this.headers, this.request));
            clientCall.sendMessage(this.request);
            clientCall.halfClose();
            clientCall.request(Integer.MAX_VALUE);
            future.get(1L, TimeUnit.MINUTES);
        }
        catch (Throwable e) {
            LOG.log(Level.WARNING, "Failed to prime channel", e);
        }
    }

    private static Metadata createMetadata(Map<String, String> headers, PingAndWarmRequest request) {
        Metadata metadata = new Metadata();
        headers.forEach((k, v) -> metadata.put(Metadata.Key.of(k, Metadata.ASCII_STRING_MARSHALLER), v));
        try {
            metadata.put(REQUEST_PARAMS, String.format("name=%s&app_profile_id=%s", URLEncoder.encode(request.getName(), "UTF-8"), URLEncoder.encode(request.getAppProfileId(), "UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            LOG.log(Level.WARNING, "Failed to encode request params", e);
        }
        return metadata;
    }
}

