/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub;

import com.google.bigtable.repackaged.com.google.api.core.AbstractApiFuture;
import com.google.bigtable.repackaged.com.google.api.core.ApiFuture;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcStatusCode;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiCallContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.InternalException;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ResponseObserver;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StreamController;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.ApiTracerFactory;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.SpanName;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.BigtableTracer;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.Futures;
import com.google.bigtable.repackaged.io.grpc.Status;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

class BigtableUnaryOperationCallable<ReqT, RespT>
extends UnaryCallable<ReqT, RespT> {
    private static final Logger LOGGER = Logger.getLogger(BigtableUnaryOperationCallable.class.getName());
    Logger logger = LOGGER;
    private final ServerStreamingCallable<ReqT, RespT> inner;
    private final ApiCallContext defaultCallContext;
    private final ApiTracerFactory tracerFactory;
    private final SpanName spanName;
    private final boolean allowNoResponse;

    public BigtableUnaryOperationCallable(ServerStreamingCallable<ReqT, RespT> inner, ApiCallContext defaultCallContext, ApiTracerFactory tracerFactory, SpanName spanName, boolean allowNoResponse) {
        this.inner = inner;
        this.defaultCallContext = defaultCallContext;
        this.tracerFactory = tracerFactory;
        this.spanName = spanName;
        this.allowNoResponse = allowNoResponse;
    }

    @Override
    public ApiFuture<RespT> futureCall(ReqT req, ApiCallContext apiCallContext) {
        apiCallContext = this.defaultCallContext.merge(apiCallContext);
        BigtableTracer apiTracer = (BigtableTracer)this.tracerFactory.newTracer(apiCallContext.getTracer(), this.spanName, ApiTracerFactory.OperationType.Unary);
        apiCallContext = apiCallContext.withTracer(apiTracer);
        UnaryFuture f = new UnaryFuture(apiTracer, this.allowNoResponse);
        this.inner.call(req, f, apiCallContext);
        return f;
    }

    class UnaryFuture
    extends AbstractApiFuture<RespT>
    implements ResponseObserver<RespT> {
        private final BigtableTracer tracer;
        private final boolean allowNoResponse;
        private StreamController controller;
        private final AtomicBoolean upstreamCancelled = new AtomicBoolean();

        private UnaryFuture(BigtableTracer tracer, boolean allowNoResponse) {
            this.tracer = Preconditions.checkNotNull(tracer, "tracer can't be null");
            this.allowNoResponse = allowNoResponse;
        }

        @Override
        public void onStart(StreamController controller) {
            this.controller = controller;
            controller.disableAutoInboundFlowControl();
            controller.request(2);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (super.cancel(mayInterruptIfRunning)) {
                this.cancelUpstream();
                return true;
            }
            return false;
        }

        private void cancelUpstream() {
            if (this.upstreamCancelled.compareAndSet(false, true)) {
                this.controller.cancel();
            }
        }

        @Override
        public void onResponse(RespT resp) {
            this.tracer.responseReceived();
            if (this.set(resp)) {
                this.tracer.operationFinishEarly();
                return;
            }
            if (this.isCancelled()) {
                return;
            }
            try {
                Object prev = Futures.getDone(this);
                String msg = String.format("Received response after future is resolved for a %s unary operation. previous: %s, New response: %s", BigtableUnaryOperationCallable.this.spanName, prev, resp);
                BigtableUnaryOperationCallable.this.logger.log(Level.WARNING, msg);
            }
            catch (ExecutionException e) {
                String msg = String.format("Received response after future resolved as a failure for a %s unary operation. New response: %s", BigtableUnaryOperationCallable.this.spanName, resp);
                BigtableUnaryOperationCallable.this.logger.log(Level.WARNING, msg, e.getCause());
            }
            this.cancelUpstream();
        }

        @Override
        public void onError(Throwable throwable) {
            if (this.setException(throwable)) {
                this.tracer.operationFailed(throwable);
            } else if (this.isCancelled()) {
                this.tracer.operationCancelled();
            } else {
                this.tracer.operationSucceeded();
            }
        }

        @Override
        public void onComplete() {
            String msg;
            InternalException e;
            if (this.allowNoResponse && this.set(null)) {
                this.tracer.operationSucceeded();
                return;
            }
            if (!this.isDone() && this.setException(e = new InternalException(msg = BigtableUnaryOperationCallable.this.spanName + " unary operation completed without a response message", null, GrpcStatusCode.of(Status.Code.INTERNAL), false))) {
                this.tracer.operationFailed(e);
                return;
            }
            if (this.isCancelled()) {
                this.tracer.operationCancelled();
                return;
            }
            this.tracer.operationSucceeded();
        }
    }
}

