/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.ApiTracer;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.ApiTracerFactory;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.BaseApiTracerFactory;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.SpanName;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.BuiltinMetricsTracer;
import com.google.bigtable.repackaged.io.opentelemetry.api.OpenTelemetry;
import com.google.bigtable.repackaged.io.opentelemetry.api.common.Attributes;
import com.google.bigtable.repackaged.io.opentelemetry.api.metrics.DoubleHistogram;
import com.google.bigtable.repackaged.io.opentelemetry.api.metrics.LongCounter;
import com.google.bigtable.repackaged.io.opentelemetry.api.metrics.Meter;
import java.io.IOException;

@InternalApi(value="For internal use only")
public class BuiltinMetricsTracerFactory
extends BaseApiTracerFactory {
    private final Attributes attributes;
    private static final String MILLISECOND = "ms";
    private static final String COUNT = "1";
    private final DoubleHistogram operationLatenciesHistogram;
    private final DoubleHistogram attemptLatenciesHistogram;
    private final DoubleHistogram serverLatenciesHistogram;
    private final DoubleHistogram firstResponseLatenciesHistogram;
    private final DoubleHistogram clientBlockingLatenciesHistogram;
    private final DoubleHistogram applicationBlockingLatenciesHistogram;
    private final DoubleHistogram remainingDeadlineHistogram;
    private final LongCounter connectivityErrorCounter;
    private final LongCounter retryCounter;

    public static BuiltinMetricsTracerFactory create(OpenTelemetry openTelemetry, Attributes attributes) throws IOException {
        return new BuiltinMetricsTracerFactory(openTelemetry, attributes);
    }

    BuiltinMetricsTracerFactory(OpenTelemetry openTelemetry, Attributes attributes) {
        this.attributes = attributes;
        Meter meter = openTelemetry.getMeter("bigtable.googleapis.com/internal/client/");
        this.operationLatenciesHistogram = meter.histogramBuilder("operation_latencies").setDescription("Total time until final operation success or failure, including retries and backoff.").setUnit(MILLISECOND).build();
        this.attemptLatenciesHistogram = meter.histogramBuilder("attempt_latencies").setDescription("Client observed latency per RPC attempt.").setUnit(MILLISECOND).build();
        this.serverLatenciesHistogram = meter.histogramBuilder("server_latencies").setDescription("The latency measured from the moment that the RPC entered the Google data center until the RPC was completed.").setUnit(MILLISECOND).build();
        this.firstResponseLatenciesHistogram = meter.histogramBuilder("first_response_latencies").setDescription("Latency from operation start until the response headers were received. The publishing of the measurement will be delayed until the attempt response has been received.").setUnit(MILLISECOND).build();
        this.clientBlockingLatenciesHistogram = meter.histogramBuilder("throttling_latencies").setDescription("The artificial latency introduced by the client to limit the number of outstanding requests. The publishing of the measurement will be delayed until the attempt trailers have been received.").setUnit(MILLISECOND).build();
        this.applicationBlockingLatenciesHistogram = meter.histogramBuilder("application_latencies").setDescription("The latency of the client application consuming available response data.").setUnit(MILLISECOND).build();
        this.remainingDeadlineHistogram = meter.histogramBuilder("remaining_deadline").setDescription("The remaining deadline when the request is sent to grpc. This will either be the operation timeout, or the remaining deadline from operation timeout after retries and back offs.").setUnit(MILLISECOND).build();
        this.connectivityErrorCounter = meter.counterBuilder("connectivity_error_count").setDescription("Number of requests that failed to reach the Google datacenter. (Requests without google response headers").setUnit(COUNT).build();
        this.retryCounter = meter.counterBuilder("retry_count").setDescription("The number of additional RPCs sent after the initial attempt.").setUnit(COUNT).build();
    }

    @Override
    public ApiTracer newTracer(ApiTracer parent, SpanName spanName, ApiTracerFactory.OperationType operationType) {
        return new BuiltinMetricsTracer(operationType, spanName, this.attributes, this.operationLatenciesHistogram, this.attemptLatenciesHistogram, this.serverLatenciesHistogram, this.firstResponseLatenciesHistogram, this.clientBlockingLatenciesHistogram, this.applicationBlockingLatenciesHistogram, this.remainingDeadlineHistogram, this.connectivityErrorCounter, this.retryCounter);
    }
}

