/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.bigtable.repackaged.com.google.api.gax.tracing.ApiTracer;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.BigtableTracer;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.org.threeten.bp.Duration;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

class CompositeTracer
extends BigtableTracer {
    private final List<ApiTracer> children;
    private final List<BigtableTracer> bigtableTracers;
    private volatile int attempt;

    CompositeTracer(List<ApiTracer> children) {
        ImmutableList.Builder childrenBuilder = ImmutableList.builder();
        ImmutableList.Builder bigtableTracerBuilder = ImmutableList.builder();
        for (ApiTracer child : children) {
            if (child instanceof BigtableTracer) {
                bigtableTracerBuilder.add((BigtableTracer)child);
            }
            childrenBuilder.add(child);
        }
        this.children = childrenBuilder.build();
        this.bigtableTracers = bigtableTracerBuilder.build();
    }

    @Override
    public ApiTracer.Scope inScope() {
        final ArrayList<ApiTracer.Scope> childScopes = new ArrayList<ApiTracer.Scope>(this.children.size());
        for (ApiTracer child : this.children) {
            childScopes.add(child.inScope());
        }
        return new ApiTracer.Scope(){

            @Override
            public void close() {
                for (ApiTracer.Scope childScope : childScopes) {
                    childScope.close();
                }
            }
        };
    }

    @Override
    public void operationFinishEarly() {
        for (BigtableTracer tracer : this.bigtableTracers) {
            tracer.operationFinishEarly();
        }
    }

    @Override
    public void operationSucceeded() {
        for (ApiTracer child : this.children) {
            child.operationSucceeded();
        }
    }

    @Override
    public void operationCancelled() {
        for (ApiTracer child : this.children) {
            child.operationCancelled();
        }
    }

    @Override
    public void operationFailed(Throwable error) {
        for (ApiTracer child : this.children) {
            child.operationFailed(error);
        }
    }

    @Override
    public void connectionSelected(String id) {
        for (ApiTracer child : this.children) {
            child.connectionSelected(id);
        }
    }

    @Override
    public void attemptStarted(int attemptNumber) {
        this.attemptStarted(null, attemptNumber);
    }

    @Override
    public void attemptStarted(Object request, int attemptNumber) {
        this.attempt = attemptNumber;
        for (ApiTracer child : this.children) {
            child.attemptStarted(request, attemptNumber);
        }
    }

    @Override
    public void attemptSucceeded() {
        for (ApiTracer child : this.children) {
            child.attemptSucceeded();
        }
    }

    @Override
    public void attemptCancelled() {
        for (ApiTracer child : this.children) {
            child.attemptCancelled();
        }
    }

    @Override
    public void attemptFailed(Throwable error, Duration delay) {
        for (ApiTracer child : this.children) {
            child.attemptFailed(error, delay);
        }
    }

    @Override
    public void attemptFailedRetriesExhausted(Throwable error) {
        for (ApiTracer child : this.children) {
            child.attemptFailedRetriesExhausted(error);
        }
    }

    @Override
    public void attemptPermanentFailure(Throwable error) {
        for (ApiTracer child : this.children) {
            child.attemptPermanentFailure(error);
        }
    }

    @Override
    public void lroStartFailed(Throwable error) {
        for (ApiTracer child : this.children) {
            child.lroStartFailed(error);
        }
    }

    @Override
    public void lroStartSucceeded() {
        for (ApiTracer child : this.children) {
            child.lroStartSucceeded();
        }
    }

    @Override
    public void responseReceived() {
        for (ApiTracer child : this.children) {
            child.responseReceived();
        }
    }

    @Override
    public void requestSent() {
        for (ApiTracer child : this.children) {
            child.requestSent();
        }
    }

    @Override
    public void batchRequestSent(long elementCount, long requestSize) {
        for (ApiTracer child : this.children) {
            child.batchRequestSent(elementCount, requestSize);
        }
    }

    @Override
    public int getAttempt() {
        return this.attempt;
    }

    @Override
    public void recordGfeMetadata(@Nullable Long latency, @Nullable Throwable throwable) {
        for (BigtableTracer tracer : this.bigtableTracers) {
            tracer.recordGfeMetadata(latency, throwable);
        }
    }

    @Override
    public void batchRequestThrottled(long throttledTimeMs) {
        for (BigtableTracer tracer : this.bigtableTracers) {
            tracer.batchRequestThrottled(throttledTimeMs);
        }
    }

    @Override
    public void setLocations(String zone, String cluster) {
        for (BigtableTracer tracer : this.bigtableTracers) {
            tracer.setLocations(zone, cluster);
        }
    }

    @Override
    public void onRequest(int requestCount) {
        for (BigtableTracer tracer : this.bigtableTracers) {
            tracer.onRequest(requestCount);
        }
    }

    @Override
    public void disableFlowControl() {
        for (BigtableTracer tracer : this.bigtableTracers) {
            tracer.disableFlowControl();
        }
    }

    @Override
    public void afterResponse(long applicationLatency) {
        for (BigtableTracer tracer : this.bigtableTracers) {
            tracer.afterResponse(applicationLatency);
        }
    }

    @Override
    public void grpcChannelQueuedLatencies(long queuedTimeMs) {
        for (BigtableTracer tracer : this.bigtableTracers) {
            tracer.grpcChannelQueuedLatencies(queuedTimeMs);
        }
    }

    @Override
    public void grpcMessageSent() {
        for (BigtableTracer tracer : this.bigtableTracers) {
            tracer.grpcMessageSent();
        }
    }

    @Override
    public void setTotalTimeoutDuration(java.time.Duration totalTimeoutDuration) {
        for (BigtableTracer tracer : this.bigtableTracers) {
            tracer.setTotalTimeoutDuration(totalTimeoutDuration);
        }
    }
}

