/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.bigtable.repackaged.com.google.api.gax.retrying.ServerStreamingAttemptException;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.ApiTracer;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.ApiTracerFactory;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.SpanName;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.BigtableTracer;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.RpcMeasureConstants;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.Util;
import com.google.bigtable.repackaged.com.google.common.base.Stopwatch;
import com.google.bigtable.repackaged.io.opencensus.stats.MeasureMap;
import com.google.bigtable.repackaged.io.opencensus.stats.StatsRecorder;
import com.google.bigtable.repackaged.io.opencensus.tags.TagContext;
import com.google.bigtable.repackaged.io.opencensus.tags.TagContextBuilder;
import com.google.bigtable.repackaged.io.opencensus.tags.TagKey;
import com.google.bigtable.repackaged.io.opencensus.tags.TagValue;
import com.google.bigtable.repackaged.io.opencensus.tags.Tagger;
import com.google.bigtable.repackaged.org.threeten.bp.Duration;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

class MetricsTracer
extends BigtableTracer {
    private final ApiTracerFactory.OperationType operationType;
    private final Tagger tagger;
    private final StatsRecorder stats;
    private final TagContext parentContext;
    private final SpanName spanName;
    private final Map<TagKey, TagValue> statsAttributes;
    private final AtomicBoolean opFinished = new AtomicBoolean();
    private final Stopwatch operationTimer = Stopwatch.createStarted();
    private final Stopwatch firstResponsePerOpTimer = Stopwatch.createStarted();
    private long operationResponseCount = 0L;
    private int attemptCount = 0;
    private Stopwatch attemptTimer;
    private long attemptResponseCount = 0L;
    private volatile int attempt = 0;
    private volatile boolean reportBatchingLatency = false;
    private volatile long batchThrottledLatency = 0L;

    MetricsTracer(ApiTracerFactory.OperationType operationType, Tagger tagger, StatsRecorder stats, SpanName spanName, Map<TagKey, TagValue> statsAttributes) {
        this.operationType = operationType;
        this.tagger = tagger;
        this.stats = stats;
        this.parentContext = tagger.getCurrentTagContext();
        this.spanName = spanName;
        this.statsAttributes = statsAttributes;
    }

    @Override
    public ApiTracer.Scope inScope() {
        return new ApiTracer.Scope(){

            @Override
            public void close() {
            }
        };
    }

    @Override
    public void operationFinishEarly() {
        this.attemptTimer.stop();
        this.operationTimer.stop();
    }

    @Override
    public void operationSucceeded() {
        this.recordOperationCompletion(null);
    }

    @Override
    public void operationCancelled() {
        this.recordOperationCompletion(new CancellationException());
    }

    @Override
    public void operationFailed(Throwable throwable) {
        this.recordOperationCompletion(throwable);
    }

    private void recordOperationCompletion(@Nullable Throwable throwable) {
        if (!this.opFinished.compareAndSet(false, true)) {
            return;
        }
        long elapsed = this.operationTimer.elapsed(TimeUnit.MILLISECONDS);
        MeasureMap measures = this.stats.newMeasureMap().put(RpcMeasureConstants.BIGTABLE_OP_LATENCY, elapsed).put(RpcMeasureConstants.BIGTABLE_OP_ATTEMPT_COUNT, this.attemptCount);
        if (this.operationType == ApiTracerFactory.OperationType.ServerStreaming && this.spanName.getMethodName().equals("ReadRows")) {
            measures.put(RpcMeasureConstants.BIGTABLE_READ_ROWS_FIRST_ROW_LATENCY, this.firstResponsePerOpTimer.elapsed(TimeUnit.MILLISECONDS));
        }
        TagContextBuilder tagCtx = this.newTagCtxBuilder().putLocal(RpcMeasureConstants.BIGTABLE_STATUS, TagValue.create(Util.extractStatus(throwable)));
        measures.record(tagCtx.build());
    }

    @Override
    public void attemptStarted(int attemptNumber) {
        this.attempt = attemptNumber;
        ++this.attemptCount;
        this.attemptTimer = Stopwatch.createStarted();
        this.attemptResponseCount = 0L;
    }

    @Override
    public void attemptSucceeded() {
        this.recordAttemptCompletion(null);
    }

    @Override
    public void attemptCancelled() {
        this.recordAttemptCompletion(new CancellationException());
    }

    @Override
    public void attemptFailed(Throwable throwable, Duration duration) {
        this.recordAttemptCompletion(throwable);
    }

    @Override
    public void attemptFailedRetriesExhausted(Throwable throwable) {
        this.recordAttemptCompletion(throwable);
    }

    @Override
    public void attemptPermanentFailure(Throwable throwable) {
        this.recordAttemptCompletion(throwable);
    }

    private void recordAttemptCompletion(@Nullable Throwable throwable) {
        MeasureMap measures = this.stats.newMeasureMap().put(RpcMeasureConstants.BIGTABLE_ATTEMPT_LATENCY, this.attemptTimer.elapsed(TimeUnit.MILLISECONDS));
        if (this.reportBatchingLatency) {
            measures.put(RpcMeasureConstants.BIGTABLE_BATCH_THROTTLED_TIME, this.batchThrottledLatency);
            this.batchThrottledLatency = 0L;
        }
        if (throwable instanceof ServerStreamingAttemptException) {
            throwable = throwable.getCause();
        }
        TagContextBuilder tagCtx = this.newTagCtxBuilder().putLocal(RpcMeasureConstants.BIGTABLE_STATUS, TagValue.create(Util.extractStatus(throwable)));
        measures.record(tagCtx.build());
    }

    @Override
    public void responseReceived() {
        if (this.firstResponsePerOpTimer.isRunning()) {
            this.firstResponsePerOpTimer.stop();
        }
        ++this.attemptResponseCount;
        ++this.operationResponseCount;
    }

    @Override
    public int getAttempt() {
        return this.attempt;
    }

    @Override
    public void recordGfeMetadata(@Nullable Long latency, @Nullable Throwable throwable) {
        MeasureMap measures = this.stats.newMeasureMap();
        if (latency != null) {
            measures.put(RpcMeasureConstants.BIGTABLE_GFE_LATENCY, latency).put(RpcMeasureConstants.BIGTABLE_GFE_HEADER_MISSING_COUNT, 0L);
        } else {
            measures.put(RpcMeasureConstants.BIGTABLE_GFE_HEADER_MISSING_COUNT, 1L);
        }
        measures.record(this.newTagCtxBuilder().putLocal(RpcMeasureConstants.BIGTABLE_STATUS, TagValue.create(Util.extractStatus(throwable))).build());
    }

    @Override
    public void batchRequestThrottled(long totalThrottledMs) {
        this.reportBatchingLatency = true;
        this.batchThrottledLatency += totalThrottledMs;
    }

    private TagContextBuilder newTagCtxBuilder() {
        TagContextBuilder tagCtx = this.tagger.toBuilder(this.parentContext).putLocal(RpcMeasureConstants.BIGTABLE_OP, TagValue.create(this.spanName.toString()));
        for (Map.Entry<TagKey, TagValue> entry : this.statsAttributes.entrySet()) {
            tagCtx.putLocal(entry.getKey(), entry.getValue());
        }
        return tagCtx;
    }
}

