/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.monitoring.v3.stub;

import com.google.bigtable.repackaged.com.google.api.core.ApiFunction;
import com.google.bigtable.repackaged.com.google.api.core.ApiFuture;
import com.google.bigtable.repackaged.com.google.api.core.ObsoleteApi;
import com.google.bigtable.repackaged.com.google.api.gax.core.GaxProperties;
import com.google.bigtable.repackaged.com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.bigtable.repackaged.com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.RetrySettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiCallContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ClientContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.PageContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.PagedCallSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.PagedListDescriptor;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StatusCode;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StubSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.TransportChannelProvider;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.repackaged.com.google.cloud.monitoring.v3.SnoozeServiceClient;
import com.google.bigtable.repackaged.com.google.cloud.monitoring.v3.stub.GrpcSnoozeServiceStub;
import com.google.bigtable.repackaged.com.google.cloud.monitoring.v3.stub.SnoozeServiceStub;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableSet;
import com.google.bigtable.repackaged.com.google.common.collect.Lists;
import com.google.bigtable.repackaged.com.google.monitoring.v3.CreateSnoozeRequest;
import com.google.bigtable.repackaged.com.google.monitoring.v3.GetSnoozeRequest;
import com.google.bigtable.repackaged.com.google.monitoring.v3.ListSnoozesRequest;
import com.google.bigtable.repackaged.com.google.monitoring.v3.ListSnoozesResponse;
import com.google.bigtable.repackaged.com.google.monitoring.v3.Snooze;
import com.google.bigtable.repackaged.com.google.monitoring.v3.UpdateSnoozeRequest;
import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.Set;

public class SnoozeServiceStubSettings
extends StubSettings<SnoozeServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add("https://www.googleapis.com/auth/cloud-platform")).add("https://www.googleapis.com/auth/monitoring")).add("https://www.googleapis.com/auth/monitoring.read")).build();
    private final UnaryCallSettings<CreateSnoozeRequest, Snooze> createSnoozeSettings;
    private final PagedCallSettings<ListSnoozesRequest, ListSnoozesResponse, SnoozeServiceClient.ListSnoozesPagedResponse> listSnoozesSettings;
    private final UnaryCallSettings<GetSnoozeRequest, Snooze> getSnoozeSettings;
    private final UnaryCallSettings<UpdateSnoozeRequest, Snooze> updateSnoozeSettings;
    private static final PagedListDescriptor<ListSnoozesRequest, ListSnoozesResponse, Snooze> LIST_SNOOZES_PAGE_STR_DESC = new PagedListDescriptor<ListSnoozesRequest, ListSnoozesResponse, Snooze>(){

        @Override
        public String emptyToken() {
            return "";
        }

        @Override
        public ListSnoozesRequest injectToken(ListSnoozesRequest payload, String token) {
            return ListSnoozesRequest.newBuilder(payload).setPageToken(token).build();
        }

        @Override
        public ListSnoozesRequest injectPageSize(ListSnoozesRequest payload, int pageSize) {
            return ListSnoozesRequest.newBuilder(payload).setPageSize(pageSize).build();
        }

        @Override
        public Integer extractPageSize(ListSnoozesRequest payload) {
            return payload.getPageSize();
        }

        @Override
        public String extractNextToken(ListSnoozesResponse payload) {
            return payload.getNextPageToken();
        }

        @Override
        public Iterable<Snooze> extractResources(ListSnoozesResponse payload) {
            return payload.getSnoozesList();
        }
    };
    private static final PagedListResponseFactory<ListSnoozesRequest, ListSnoozesResponse, SnoozeServiceClient.ListSnoozesPagedResponse> LIST_SNOOZES_PAGE_STR_FACT = new PagedListResponseFactory<ListSnoozesRequest, ListSnoozesResponse, SnoozeServiceClient.ListSnoozesPagedResponse>(){

        @Override
        public ApiFuture<SnoozeServiceClient.ListSnoozesPagedResponse> getFuturePagedResponse(UnaryCallable<ListSnoozesRequest, ListSnoozesResponse> callable, ListSnoozesRequest request, ApiCallContext context, ApiFuture<ListSnoozesResponse> futureResponse) {
            PageContext<ListSnoozesRequest, ListSnoozesResponse, Snooze> pageContext = PageContext.create(callable, LIST_SNOOZES_PAGE_STR_DESC, request, context);
            return SnoozeServiceClient.ListSnoozesPagedResponse.createAsync(pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateSnoozeRequest, Snooze> createSnoozeSettings() {
        return this.createSnoozeSettings;
    }

    public PagedCallSettings<ListSnoozesRequest, ListSnoozesResponse, SnoozeServiceClient.ListSnoozesPagedResponse> listSnoozesSettings() {
        return this.listSnoozesSettings;
    }

    public UnaryCallSettings<GetSnoozeRequest, Snooze> getSnoozeSettings() {
        return this.getSnoozeSettings;
    }

    public UnaryCallSettings<UpdateSnoozeRequest, Snooze> updateSnoozeSettings() {
        return this.updateSnoozeSettings;
    }

    public SnoozeServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcSnoozeServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    @Override
    public String getServiceName() {
        return "monitoring";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "monitoring.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "monitoring.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.MAX_VALUE);
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SnoozeServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SnoozeServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SnoozeServiceStubSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder);
        this.createSnoozeSettings = settingsBuilder.createSnoozeSettings().build();
        this.listSnoozesSettings = settingsBuilder.listSnoozesSettings().build();
        this.getSnoozeSettings = settingsBuilder.getSnoozeSettings().build();
        this.updateSnoozeSettings = settingsBuilder.updateSnoozeSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SnoozeServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateSnoozeRequest, Snooze> createSnoozeSettings;
        private final PagedCallSettings.Builder<ListSnoozesRequest, ListSnoozesResponse, SnoozeServiceClient.ListSnoozesPagedResponse> listSnoozesSettings;
        private final UnaryCallSettings.Builder<GetSnoozeRequest, Snooze> getSnoozeSettings;
        private final UnaryCallSettings.Builder<UpdateSnoozeRequest, Snooze> updateSnoozeSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createSnoozeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSnoozesSettings = PagedCallSettings.newBuilder(LIST_SNOOZES_PAGE_STR_FACT);
            this.getSnoozeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSnoozeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSnoozeSettings, this.listSnoozesSettings, this.getSnoozeSettings, this.updateSnoozeSettings);
            Builder.initDefaults(this);
        }

        protected Builder(SnoozeServiceStubSettings settings) {
            super(settings);
            this.createSnoozeSettings = settings.createSnoozeSettings.toBuilder();
            this.listSnoozesSettings = settings.listSnoozesSettings.toBuilder();
            this.getSnoozeSettings = settings.getSnoozeSettings.toBuilder();
            this.updateSnoozeSettings = settings.updateSnoozeSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSnoozeSettings, this.listSnoozesSettings, this.getSnoozeSettings, this.updateSnoozeSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SnoozeServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider(SnoozeServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider(SnoozeServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SnoozeServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createSnoozeSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("no_retry_15_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_15_params"));
            ((PagedCallSettings.Builder)builder.listSnoozesSettings().setRetryableCodes(RETRYABLE_CODE_DEFINITIONS.get("retry_policy_14_codes"))).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_14_params"));
            builder.getSnoozeSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_14_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_14_params"));
            builder.updateSnoozeSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("no_retry_15_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_15_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateSnoozeRequest, Snooze> createSnoozeSettings() {
            return this.createSnoozeSettings;
        }

        public PagedCallSettings.Builder<ListSnoozesRequest, ListSnoozesResponse, SnoozeServiceClient.ListSnoozesPagedResponse> listSnoozesSettings() {
            return this.listSnoozesSettings;
        }

        public UnaryCallSettings.Builder<GetSnoozeRequest, Snooze> getSnoozeSettings() {
            return this.getSnoozeSettings;
        }

        public UnaryCallSettings.Builder<UpdateSnoozeRequest, Snooze> updateSnoozeSettings() {
            return this.updateSnoozeSettings;
        }

        public SnoozeServiceStubSettings build() throws IOException {
            return new SnoozeServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder<String, Serializable> definitions = ImmutableMap.builder();
            definitions.put("no_retry_15_codes", ImmutableSet.copyOf(Lists.newArrayList()));
            definitions.put("retry_policy_14_codes", ImmutableSet.copyOf(Lists.newArrayList(StatusCode.Code.UNAVAILABLE)));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(30000L)).setTotalTimeoutDuration(Duration.ofMillis(30000L)).build();
            definitions.put("no_retry_15_params", settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(30000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(30000L)).setTotalTimeoutDuration(Duration.ofMillis(30000L)).build();
            definitions.put("retry_policy_14_params", settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

