/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.opentelemetry.detection;

import com.google.bigtable.repackaged.com.google.cloud.opentelemetry.detection.DetectedPlatform;
import com.google.bigtable.repackaged.com.google.cloud.opentelemetry.detection.EnvironmentVariables;
import com.google.bigtable.repackaged.com.google.cloud.opentelemetry.detection.GCPMetadataConfig;
import com.google.bigtable.repackaged.com.google.cloud.opentelemetry.detection.GCPPlatformDetector;
import java.util.HashMap;
import java.util.Map;

final class GoogleCloudRunJob
implements DetectedPlatform {
    private final GCPMetadataConfig metadataConfig;
    private final EnvironmentVariables environmentVariables;
    private final Map<String, String> availableAttributes;

    GoogleCloudRunJob(EnvironmentVariables environmentVariables, GCPMetadataConfig metadataConfig) {
        this.metadataConfig = metadataConfig;
        this.environmentVariables = environmentVariables;
        this.availableAttributes = this.prepareAttributes();
    }

    private Map<String, String> prepareAttributes() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("serverless_compute_name", this.environmentVariables.get("CLOUD_RUN_JOB"));
        map.put("gcr_job_execution_key", this.environmentVariables.get("CLOUD_RUN_EXECUTION"));
        map.put("gcr_job_task_index", this.environmentVariables.get("CLOUD_RUN_TASK_INDEX"));
        map.put("instance_id", this.metadataConfig.getInstanceId());
        map.put("cloud_region", this.metadataConfig.getRegionFromZone());
        return map;
    }

    @Override
    public GCPPlatformDetector.SupportedPlatform getSupportedPlatform() {
        return GCPPlatformDetector.SupportedPlatform.GOOGLE_CLOUD_RUN_JOB;
    }

    @Override
    public String getProjectId() {
        return this.metadataConfig.getProjectId();
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.availableAttributes;
    }
}

