/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.lmax.disruptor.dsl;

import com.google.bigtable.repackaged.com.lmax.disruptor.Sequence;
import com.google.bigtable.repackaged.com.lmax.disruptor.SequenceBarrier;
import com.google.bigtable.repackaged.com.lmax.disruptor.WorkerPool;
import com.google.bigtable.repackaged.com.lmax.disruptor.dsl.ConsumerInfo;
import java.util.concurrent.Executor;

class WorkerPoolInfo<T>
implements ConsumerInfo {
    private final WorkerPool<T> workerPool;
    private final SequenceBarrier sequenceBarrier;
    private boolean endOfChain = true;

    WorkerPoolInfo(WorkerPool<T> workerPool, SequenceBarrier sequenceBarrier) {
        this.workerPool = workerPool;
        this.sequenceBarrier = sequenceBarrier;
    }

    @Override
    public Sequence[] getSequences() {
        return this.workerPool.getWorkerSequences();
    }

    @Override
    public SequenceBarrier getBarrier() {
        return this.sequenceBarrier;
    }

    @Override
    public boolean isEndOfChain() {
        return this.endOfChain;
    }

    @Override
    public void start(Executor executor) {
        this.workerPool.start(executor);
    }

    @Override
    public void halt() {
        this.workerPool.halt();
    }

    @Override
    public void markAsUsedInBarrier() {
        this.endOfChain = false;
    }

    @Override
    public boolean isRunning() {
        return this.workerPool.isRunning();
    }
}

