/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.s2a;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Strings;
import com.google.bigtable.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.bigtable.repackaged.io.grpc.Channel;
import com.google.bigtable.repackaged.io.grpc.ChannelCredentials;
import com.google.bigtable.repackaged.io.grpc.ExperimentalApi;
import com.google.bigtable.repackaged.io.grpc.internal.SharedResourcePool;
import com.google.bigtable.repackaged.io.grpc.netty.InternalNettyChannelCredentials;
import com.google.bigtable.repackaged.io.grpc.netty.InternalProtocolNegotiator;
import com.google.bigtable.repackaged.io.grpc.s2a.internal.channel.S2AHandshakerServiceChannel;
import com.google.bigtable.repackaged.io.grpc.s2a.internal.handshaker.S2AIdentity;
import com.google.bigtable.repackaged.io.grpc.s2a.internal.handshaker.S2AProtocolNegotiatorFactory;
import com.google.bigtable.repackaged.io.grpc.s2a.internal.handshaker.S2AStub;
import javax.annotation.concurrent.NotThreadSafe;
import org.checkerframework.checker.nullness.qual.Nullable;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/11533")
public final class S2AChannelCredentials {
    public static Builder newBuilder(String s2aAddress, ChannelCredentials s2aChannelCredentials) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(s2aAddress), "S2A address must not be null or empty.");
        Preconditions.checkNotNull(s2aChannelCredentials, "S2A channel credentials must not be null");
        return new Builder(s2aAddress, s2aChannelCredentials);
    }

    private S2AChannelCredentials() {
    }

    @NotThreadSafe
    public static final class Builder {
        private final String s2aAddress;
        private final ChannelCredentials s2aChannelCredentials;
        private @Nullable S2AIdentity localIdentity = null;
        private @Nullable S2AStub stub = null;

        Builder(String s2aAddress, ChannelCredentials s2aChannelCredentials) {
            this.s2aAddress = s2aAddress;
            this.s2aChannelCredentials = s2aChannelCredentials;
        }

        @CanIgnoreReturnValue
        public Builder setLocalSpiffeId(String localSpiffeId) {
            Preconditions.checkNotNull(localSpiffeId);
            Preconditions.checkArgument(this.localIdentity == null, "localIdentity is already set.");
            this.localIdentity = S2AIdentity.fromSpiffeId(localSpiffeId);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setLocalHostname(String localHostname) {
            Preconditions.checkNotNull(localHostname);
            Preconditions.checkArgument(this.localIdentity == null, "localIdentity is already set.");
            this.localIdentity = S2AIdentity.fromHostname(localHostname);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setLocalUid(String localUid) {
            Preconditions.checkNotNull(localUid);
            Preconditions.checkArgument(this.localIdentity == null, "localIdentity is already set.");
            this.localIdentity = S2AIdentity.fromUid(localUid);
            return this;
        }

        public Builder setStub(S2AStub stub) {
            Preconditions.checkNotNull(stub);
            this.stub = stub;
            return this;
        }

        public ChannelCredentials build() {
            return InternalNettyChannelCredentials.create(this.buildProtocolNegotiatorFactory());
        }

        InternalProtocolNegotiator.ClientFactory buildProtocolNegotiatorFactory() {
            SharedResourcePool<Channel> s2aChannelPool = SharedResourcePool.forResource(S2AHandshakerServiceChannel.getChannelResource(this.s2aAddress, this.s2aChannelCredentials));
            Preconditions.checkNotNull(s2aChannelPool, "s2aChannelPool");
            return S2AProtocolNegotiatorFactory.createClientFactory(this.localIdentity, s2aChannelPool, this.stub);
        }
    }
}

