/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.s2a.internal.handshaker;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.errorprone.annotations.ThreadSafe;
import com.google.bigtable.repackaged.io.grpc.s2a.internal.handshaker.Identity;

@ThreadSafe
public final class S2AIdentity {
    private final Identity identity;

    public static S2AIdentity fromSpiffeId(String spiffeId) {
        Preconditions.checkNotNull(spiffeId);
        return new S2AIdentity(Identity.newBuilder().setSpiffeId(spiffeId).build());
    }

    public static S2AIdentity fromHostname(String hostname) {
        Preconditions.checkNotNull(hostname);
        return new S2AIdentity(Identity.newBuilder().setHostname(hostname).build());
    }

    public static S2AIdentity fromUid(String uid) {
        Preconditions.checkNotNull(uid);
        return new S2AIdentity(Identity.newBuilder().setUid(uid).build());
    }

    public static S2AIdentity fromIdentity(Identity identity) {
        return new S2AIdentity(identity == null ? Identity.getDefaultInstance() : identity);
    }

    private S2AIdentity(Identity identity) {
        this.identity = identity;
    }

    public Identity getIdentity() {
        return this.identity;
    }
}

