/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opencensus.implcore.tags.propagation;

import com.google.bigtable.repackaged.io.opencensus.implcore.internal.CurrentState;
import com.google.bigtable.repackaged.io.opencensus.implcore.tags.TagMapImpl;
import com.google.bigtable.repackaged.io.opencensus.implcore.tags.propagation.BinarySerializationUtils;
import com.google.bigtable.repackaged.io.opencensus.tags.TagContext;
import com.google.bigtable.repackaged.io.opencensus.tags.propagation.TagContextBinarySerializer;
import com.google.bigtable.repackaged.io.opencensus.tags.propagation.TagContextDeserializationException;
import com.google.bigtable.repackaged.io.opencensus.tags.propagation.TagContextSerializationException;

final class TagContextBinarySerializerImpl
extends TagContextBinarySerializer {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final CurrentState state;

    TagContextBinarySerializerImpl(CurrentState state) {
        this.state = state;
    }

    @Override
    public byte[] toByteArray(TagContext tags) throws TagContextSerializationException {
        return this.state.getInternal() == CurrentState.State.DISABLED ? EMPTY_BYTE_ARRAY : BinarySerializationUtils.serializeBinary(tags);
    }

    @Override
    public TagContext fromByteArray(byte[] bytes) throws TagContextDeserializationException {
        return this.state.getInternal() == CurrentState.State.DISABLED ? TagMapImpl.EMPTY : BinarySerializationUtils.deserializeBinary(bytes);
    }
}

