/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opentelemetry.api.common;

import com.google.bigtable.repackaged.io.opentelemetry.api.common.KeyValue;
import com.google.bigtable.repackaged.io.opentelemetry.api.common.KeyValueList;
import com.google.bigtable.repackaged.io.opentelemetry.api.common.ValueArray;
import com.google.bigtable.repackaged.io.opentelemetry.api.common.ValueBoolean;
import com.google.bigtable.repackaged.io.opentelemetry.api.common.ValueBytes;
import com.google.bigtable.repackaged.io.opentelemetry.api.common.ValueDouble;
import com.google.bigtable.repackaged.io.opentelemetry.api.common.ValueLong;
import com.google.bigtable.repackaged.io.opentelemetry.api.common.ValueString;
import com.google.bigtable.repackaged.io.opentelemetry.api.common.ValueType;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

public interface Value<T> {
    public static Value<String> of(String value) {
        return ValueString.create(value);
    }

    public static Value<Boolean> of(boolean value) {
        return ValueBoolean.create(value);
    }

    public static Value<Long> of(long value) {
        return ValueLong.create(value);
    }

    public static Value<Double> of(double value) {
        return ValueDouble.create(value);
    }

    public static Value<ByteBuffer> of(byte[] value) {
        return ValueBytes.create(value);
    }

    public static Value<List<Value<?>>> of(Value<?> ... value) {
        return ValueArray.create(value);
    }

    public static Value<List<Value<?>>> of(List<Value<?>> value) {
        return ValueArray.create(value);
    }

    public static Value<List<KeyValue>> of(KeyValue ... value) {
        return KeyValueList.create(value);
    }

    public static Value<List<KeyValue>> of(Map<String, Value<?>> value) {
        return KeyValueList.createFromMap(value);
    }

    public ValueType getType();

    public T getValue();

    public String asString();
}

