/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics;

import com.google.bigtable.repackaged.io.opentelemetry.api.common.AttributeKey;
import com.google.bigtable.repackaged.io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import com.google.bigtable.repackaged.io.opentelemetry.api.metrics.ObservableLongMeasurement;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.AbstractInstrument;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.InstrumentType;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.InstrumentValueType;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.SdkObservableInstrument;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.descriptor.Advice;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.state.CallbackRegistration;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.state.SdkObservableMeasurement;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

final class InstrumentBuilder {
    private final String name;
    private final MeterProviderSharedState meterProviderSharedState;
    private final MeterSharedState meterSharedState;
    private final InstrumentValueType valueType;
    private InstrumentType type;
    private Advice.AdviceBuilder adviceBuilder = Advice.builder();
    private String description = "";
    private String unit = "";

    InstrumentBuilder(String name, InstrumentType type, InstrumentValueType valueType, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState) {
        this.name = name;
        this.type = type;
        this.valueType = valueType;
        this.meterProviderSharedState = meterProviderSharedState;
        this.meterSharedState = meterSharedState;
    }

    InstrumentBuilder setUnit(String unit) {
        this.unit = unit;
        return this;
    }

    InstrumentBuilder setAdviceBuilder(Advice.AdviceBuilder adviceBuilder) {
        this.adviceBuilder = adviceBuilder;
        return this;
    }

    InstrumentBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    <T> T swapBuilder(SwapBuilder<T> swapper) {
        return swapper.newBuilder(this.meterProviderSharedState, this.meterSharedState, this.name, this.description, this.unit, this.adviceBuilder);
    }

    <I extends AbstractInstrument> I buildSynchronousInstrument(SynchronousInstrumentConstructor<I> instrumentFactory) {
        InstrumentDescriptor descriptor = this.newDescriptor();
        WriteableMetricStorage storage = this.meterSharedState.registerSynchronousMetricStorage(descriptor, this.meterProviderSharedState);
        return instrumentFactory.createInstrument(descriptor, this.meterSharedState, storage);
    }

    SdkObservableInstrument buildDoubleAsynchronousInstrument(InstrumentType type, Consumer<ObservableDoubleMeasurement> updater) {
        SdkObservableMeasurement sdkObservableMeasurement = this.buildObservableMeasurement(type);
        Runnable runnable = () -> updater.accept(sdkObservableMeasurement);
        CallbackRegistration callbackRegistration = CallbackRegistration.create(Collections.singletonList(sdkObservableMeasurement), runnable);
        this.meterSharedState.registerCallback(callbackRegistration);
        return new SdkObservableInstrument(this.meterSharedState, callbackRegistration);
    }

    SdkObservableInstrument buildLongAsynchronousInstrument(InstrumentType type, Consumer<ObservableLongMeasurement> updater) {
        SdkObservableMeasurement sdkObservableMeasurement = this.buildObservableMeasurement(type);
        Runnable runnable = () -> updater.accept(sdkObservableMeasurement);
        CallbackRegistration callbackRegistration = CallbackRegistration.create(Collections.singletonList(sdkObservableMeasurement), runnable);
        this.meterSharedState.registerCallback(callbackRegistration);
        return new SdkObservableInstrument(this.meterSharedState, callbackRegistration);
    }

    SdkObservableMeasurement buildObservableMeasurement(InstrumentType type) {
        this.type = type;
        InstrumentDescriptor descriptor = this.newDescriptor();
        return this.meterSharedState.registerObservableMeasurement(descriptor);
    }

    private InstrumentDescriptor newDescriptor() {
        return InstrumentDescriptor.create(this.name, this.description, this.unit, this.type, this.valueType, this.adviceBuilder.build());
    }

    public String toString() {
        return this.toStringHelper(this.getClass().getSimpleName());
    }

    String toStringHelper(String className) {
        return className + "{descriptor=" + this.newDescriptor() + "}";
    }

    void setAdviceAttributes(List<AttributeKey<?>> attributes) {
        this.adviceBuilder.setAttributes(attributes);
    }

    void setExplicitBucketBoundaries(List<Double> bucketBoundaries) {
        this.adviceBuilder.setExplicitBucketBoundaries(bucketBoundaries);
    }

    @FunctionalInterface
    protected static interface SwapBuilder<T> {
        public T newBuilder(MeterProviderSharedState var1, MeterSharedState var2, String var3, String var4, String var5, Advice.AdviceBuilder var6);
    }

    @FunctionalInterface
    static interface SynchronousInstrumentConstructor<I extends AbstractInstrument> {
        public I createInstrument(InstrumentDescriptor var1, MeterSharedState var2, WriteableMetricStorage var3);
    }
}

