/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase;

import com.google.bigtable.repackaged.com.google.api.core.InternalExtensionOnly;
import com.google.bigtable.repackaged.com.google.bigtable.v2.RowRange;
import com.google.bigtable.repackaged.com.google.bigtable.v2.RowSet;
import com.google.cloud.bigtable.hbase.util.ByteStringer;
import com.google.cloud.bigtable.hbase.util.RowKeyUtil;
import org.apache.hadoop.hbase.client.Scan;

@InternalExtensionOnly
public class BigtableExtendedScan
extends Scan {
    private RowSet.Builder rowSet = RowSet.newBuilder();

    public Scan setStartRow(byte[] startRow) {
        throw new UnsupportedOperationException("Please use addRange(byte[], byte[]) instead.");
    }

    public Scan setStopRow(byte[] stopRow) {
        throw new UnsupportedOperationException("Please use addRange(byte[], byte[]) instead.");
    }

    public Scan setRowPrefixFilter(byte[] rowPrefix) {
        throw new UnsupportedOperationException("Please use addRangeWithPrefix(byte[]) instead.");
    }

    public void addRangeWithPrefix(byte[] prefix) {
        this.addRange(prefix, RowKeyUtil.calculateTheClosestNextRowKeyForPrefix(prefix));
    }

    public void addRange(byte[] startRow, byte[] stopRow) {
        this.addRange(RowRange.newBuilder().setStartKeyClosed(ByteStringer.wrap(startRow)).setEndKeyOpen(ByteStringer.wrap(stopRow)).build());
    }

    public void addRange(RowRange range) {
        this.rowSet.addRowRanges(range);
    }

    public void addRowKey(byte[] rowKey) {
        this.rowSet.addRowKeys(ByteStringer.wrap(rowKey));
    }

    public RowSet getRowSet() {
        return this.rowSet.build();
    }
}

