/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapterBase;
import com.google.cloud.bigtable.hbase.adapters.read.ReaderExpressionHelper;
import java.io.IOException;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.RowFilter;

@InternalApi(value="For internal usage only")
public class RowFilterAdapter
extends TypedFilterAdapterBase<RowFilter> {
    @Override
    public Filters.Filter adapt(FilterAdapterContext context, RowFilter filter) throws IOException {
        ByteString regexValue;
        CompareFilter.CompareOp compareOp = filter.getOperator();
        if (compareOp != CompareFilter.CompareOp.EQUAL) {
            throw new IllegalStateException(String.format("Cannot adapt operator %s", compareOp == null ? null : compareOp.getClass().getCanonicalName()));
        }
        ByteArrayComparable comparator = filter.getComparator();
        if (comparator == null) {
            throw new IllegalStateException("Comparator cannot be null");
        }
        if (comparator instanceof RegexStringComparator) {
            regexValue = comparator.getValue().length > 0 ? ByteString.copyFromUtf8("\\C*").concat(ByteString.copyFrom(comparator.getValue())).concat(ByteString.copyFromUtf8("\\C*")) : ByteString.EMPTY;
        } else if (comparator instanceof BinaryComparator) {
            regexValue = ReaderExpressionHelper.quoteRegularExpression(comparator.getValue());
        } else {
            throw new IllegalStateException(String.format("Cannot adapt comparator %s", comparator.getClass().getCanonicalName()));
        }
        return Filters.FILTERS.key().regex(regexValue);
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, RowFilter filter) {
        ByteArrayComparable comparator = filter.getComparator();
        if (!(comparator instanceof RegexStringComparator) && !(comparator instanceof BinaryComparator)) {
            return FilterSupportStatus.newNotSupported(comparator.getClass().getName() + " comparator is not supported");
        }
        if (filter.getOperator() != CompareFilter.CompareOp.EQUAL) {
            return FilterSupportStatus.newNotSupported(filter.getOperator() + " operator is not supported");
        }
        return FilterSupportStatus.SUPPORTED;
    }
}

