/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.wrappers.veneer;

import com.google.bigtable.repackaged.com.google.api.gax.core.CredentialsProvider;
import com.google.bigtable.repackaged.com.google.api.gax.core.NoCredentialsProvider;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.BigtableDataClientFactory;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import com.google.bigtable.repackaged.com.google.common.base.Objects;
import com.google.cloud.bigtable.hbase.wrappers.DataClientWrapper;
import com.google.cloud.bigtable.hbase.wrappers.veneer.BigtableHBaseVeneerSettings;
import com.google.cloud.bigtable.hbase.wrappers.veneer.BigtableVeneerApi;
import com.google.cloud.bigtable.hbase.wrappers.veneer.DataClientVeneerApi;
import com.google.cloud.bigtable.hbase.wrappers.veneer.SharedDataClientWrapper;
import com.google.cloud.bigtable.metrics.BigtableClientMetrics;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

class SharedDataClientWrapperFactory {
    private final Map<Key, BigtableDataClientFactory> cachedContexts = new HashMap<Key, BigtableDataClientFactory>();
    private final Map<Key, Integer> refCounts = new HashMap<Key, Integer>();
    private final Map<Key, Integer> channelPoolSizes = new HashMap<Key, Integer>();

    SharedDataClientWrapperFactory() {
    }

    synchronized DataClientWrapper createDataClient(BigtableHBaseVeneerSettings settings) throws IOException {
        Key key = Key.createFromSettings(settings.getDataSettings());
        BigtableDataClientFactory sharedCtx = this.cachedContexts.get(key);
        if (sharedCtx == null) {
            sharedCtx = BigtableDataClientFactory.create(settings.getDataSettings());
            this.cachedContexts.put(key, sharedCtx);
            this.refCounts.put(key, 0);
            int channelPoolSize = BigtableVeneerApi.getChannelPoolSize(settings.getDataSettings().getStubSettings());
            for (int i = 0; i < channelPoolSize; ++i) {
                BigtableClientMetrics.counter(BigtableClientMetrics.MetricLevel.Info, "grpc.channel.active").inc();
            }
            this.channelPoolSizes.put(key, channelPoolSize);
        }
        this.refCounts.put(key, this.refCounts.get(key) + 1);
        try {
            BigtableDataClient client = settings.getAppProfileId() == null ? sharedCtx.createForInstance(settings.getProjectId(), settings.getInstanceId()) : sharedCtx.createForInstance(settings.getProjectId(), settings.getInstanceId(), settings.getAppProfileId());
            return new SharedDataClientWrapper(this, key, new DataClientVeneerApi(client, settings.getClientTimeouts()));
        }
        catch (IOException | RuntimeException e) {
            this.release(key);
            throw e;
        }
    }

    synchronized void release(Key key) {
        int refCount = this.refCounts.get(key);
        if (--refCount > 0) {
            this.refCounts.put(key, refCount);
            return;
        }
        this.refCounts.remove(key);
        BigtableDataClientFactory clientContext = this.cachedContexts.remove(key);
        for (int i = 0; i < this.channelPoolSizes.get(key); ++i) {
            BigtableClientMetrics.counter(BigtableClientMetrics.MetricLevel.Info, "grpc.channel.active").dec();
        }
        this.channelPoolSizes.remove(key);
        try {
            clientContext.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static final class Key {
        private static final NoCredentialsProvider NO_CREDENTIALS_PROVIDER_INSTANCE = NoCredentialsProvider.create();
        private final String endpoint;
        private final CredentialsProvider credentialsProvider;

        static Key createFromSettings(BigtableDataSettings settings) {
            EnhancedBigtableStubSettings stubSettings = settings.getStubSettings();
            CredentialsProvider effectiveCredProvider = stubSettings.getCredentialsProvider();
            if (effectiveCredProvider instanceof NoCredentialsProvider) {
                effectiveCredProvider = NO_CREDENTIALS_PROVIDER_INSTANCE;
            }
            return new Key(stubSettings.getEndpoint(), effectiveCredProvider);
        }

        private Key(String endpoint, CredentialsProvider credentialsProvider) {
            this.endpoint = endpoint;
            this.credentialsProvider = credentialsProvider;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equal(this.endpoint, key.endpoint) && Objects.equal(this.credentialsProvider, key.credentialsProvider);
        }

        public int hashCode() {
            return Objects.hashCode(this.endpoint, this.credentialsProvider);
        }
    }
}

