/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.wrappers.veneer.metrics;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.ApiTracer;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.ApiTracerFactory;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.BigtableTracer;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.org.threeten.bp.Duration;
import com.google.cloud.bigtable.metrics.BigtableClientMetrics;
import com.google.cloud.bigtable.metrics.Counter;
import com.google.cloud.bigtable.metrics.Meter;
import com.google.cloud.bigtable.metrics.RpcMetrics;
import com.google.cloud.bigtable.metrics.Timer;
import java.util.concurrent.atomic.AtomicBoolean;

@InternalApi
public class MetricsApiTracerAdapter
extends BigtableTracer {
    private final Timer firstResponseLatencyTimer = BigtableClientMetrics.timer(BigtableClientMetrics.MetricLevel.Info, "grpc.method.ReadRows.firstResponse.latency");
    private final Counter activeRpcCounter = BigtableClientMetrics.counter(BigtableClientMetrics.MetricLevel.Info, "grpc.rpc.active");
    private final Meter rpcMeter = BigtableClientMetrics.meter(BigtableClientMetrics.MetricLevel.Info, "grpc.rpc.performed");
    private final RpcMetrics rpcMetrics;
    private final Timer.Context operationTimer;
    private volatile Timer.Context rpcTimer;
    private volatile RetryStatus lastRetryStatus;
    private final AtomicBoolean firstResponseRecorded;
    private volatile Timer.Context firstResponseTimer;
    private final AtomicBoolean opDone = new AtomicBoolean();
    private final AtomicBoolean attemptDone = new AtomicBoolean();

    public MetricsApiTracerAdapter(RpcMetrics rpcMetrics, String methodName, ApiTracerFactory.OperationType operationType) {
        this.rpcMetrics = rpcMetrics;
        this.operationTimer = rpcMetrics.timeOperation();
        this.lastRetryStatus = RetryStatus.PERMANENT_FAILURE;
        if (methodName.equals("ReadRows") && operationType == ApiTracerFactory.OperationType.ServerStreaming) {
            this.firstResponseTimer = this.firstResponseLatencyTimer.time();
        }
        this.firstResponseRecorded = new AtomicBoolean(false);
    }

    @Override
    public ApiTracer.Scope inScope() {
        return new ApiTracer.Scope(){

            @Override
            public void close() {
            }
        };
    }

    @Override
    public void operationFinishEarly() {
        if (this.attemptDone.compareAndSet(false, true)) {
            this.activeRpcCounter.dec();
            this.rpcTimer.close();
        }
        if (this.opDone.compareAndSet(false, true)) {
            this.operationTimer.close();
        }
    }

    @Override
    public void operationSucceeded() {
        if (!this.opDone.compareAndSet(false, true)) {
            return;
        }
        this.operationTimer.close();
    }

    @Override
    public void operationCancelled() {
        if (!this.opDone.compareAndSet(false, true)) {
            return;
        }
        this.operationTimer.close();
    }

    @Override
    public void operationFailed(Throwable error) {
        if (!this.opDone.compareAndSet(false, true)) {
            return;
        }
        if (this.lastRetryStatus == RetryStatus.RETRIES_EXHAUSTED) {
            this.rpcMetrics.markRetriesExhasted();
        } else {
            this.rpcMetrics.markFailure();
        }
        this.operationTimer.close();
    }

    @Override
    public void connectionSelected(String id) {
    }

    @Override
    public void attemptStarted(int attemptNumber) {
        this.attemptDone.set(false);
        this.lastRetryStatus = RetryStatus.PERMANENT_FAILURE;
        this.rpcTimer = this.rpcMetrics.timeRpc();
        this.activeRpcCounter.inc();
        this.rpcMeter.mark();
    }

    @Override
    public void attemptSucceeded() {
        if (!this.attemptDone.compareAndSet(false, true)) {
            return;
        }
        this.rpcTimer.close();
        this.activeRpcCounter.dec();
    }

    @Override
    public void attemptCancelled() {
        if (!this.attemptDone.compareAndSet(false, true)) {
            return;
        }
        this.rpcTimer.close();
        this.activeRpcCounter.dec();
    }

    @Override
    public void attemptFailed(Throwable error, Duration delay) {
        if (!this.attemptDone.compareAndSet(false, true)) {
            return;
        }
        this.rpcTimer.close();
        this.lastRetryStatus = RetryStatus.ATTEMPT_RETRYABLE_FAILURE;
        this.rpcMetrics.markRetry();
        this.activeRpcCounter.dec();
        BigtableClientMetrics.meter(BigtableClientMetrics.MetricLevel.Info, "grpc.errors." + (Object)((Object)Status.fromThrowable(error).getCode())).mark();
    }

    @Override
    public void attemptFailedRetriesExhausted(Throwable error) {
        if (!this.attemptDone.compareAndSet(false, true)) {
            return;
        }
        this.rpcTimer.close();
        this.activeRpcCounter.dec();
        this.lastRetryStatus = RetryStatus.RETRIES_EXHAUSTED;
    }

    @Override
    public void attemptPermanentFailure(Throwable error) {
        if (!this.attemptDone.compareAndSet(false, true)) {
            return;
        }
        this.rpcTimer.close();
        this.activeRpcCounter.dec();
        this.lastRetryStatus = RetryStatus.PERMANENT_FAILURE;
    }

    @Override
    public void responseReceived() {
        if (this.firstResponseTimer != null && this.firstResponseRecorded.compareAndSet(false, true)) {
            this.firstResponseTimer.close();
        }
    }

    @Override
    public void requestSent() {
    }

    @Override
    public void batchRequestSent(long elementCount, long requestSize) {
    }

    private static enum RetryStatus {
        PERMANENT_FAILURE,
        RETRIES_EXHAUSTED,
        ATTEMPT_RETRYABLE_FAILURE;

    }
}

