/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.api.gax.grpc;

import com.google.bigtable.repackaged.com.google.api.core.ApiFunction;
import com.google.bigtable.repackaged.com.google.api.core.BetaApi;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.core.ObsoleteApi;
import com.google.bigtable.repackaged.com.google.api.gax.core.ExecutorProvider;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.ChannelPool;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.ChannelPoolSettings;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.ChannelPrimer;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcChannelUUIDInterceptor;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcHeaderInterceptor;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcInterceptorProvider;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcLoggingInterceptor;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcMetadataHandlerInterceptor;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.HeaderProvider;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.TransportChannel;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.TransportChannelProvider;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.internal.EnvironmentProvider;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.mtls.MtlsProvider;
import com.google.bigtable.repackaged.com.google.api.gax.util.TimeConversionUtils;
import com.google.bigtable.repackaged.com.google.auth.ApiKeyCredentials;
import com.google.bigtable.repackaged.com.google.auth.Credentials;
import com.google.bigtable.repackaged.com.google.auth.oauth2.ComputeEngineCredentials;
import com.google.bigtable.repackaged.com.google.auth.oauth2.SecureSessionAgent;
import com.google.bigtable.repackaged.com.google.auth.oauth2.SecureSessionAgentConfig;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Strings;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import com.google.bigtable.repackaged.com.google.common.io.Files;
import com.google.bigtable.repackaged.io.grpc.CallCredentials;
import com.google.bigtable.repackaged.io.grpc.ChannelCredentials;
import com.google.bigtable.repackaged.io.grpc.CompositeChannelCredentials;
import com.google.bigtable.repackaged.io.grpc.Grpc;
import com.google.bigtable.repackaged.io.grpc.InsecureChannelCredentials;
import com.google.bigtable.repackaged.io.grpc.ManagedChannel;
import com.google.bigtable.repackaged.io.grpc.ManagedChannelBuilder;
import com.google.bigtable.repackaged.io.grpc.TlsChannelCredentials;
import com.google.bigtable.repackaged.io.grpc.alts.GoogleDefaultChannelCredentials;
import com.google.bigtable.repackaged.io.grpc.auth.MoreCallCredentials;
import com.google.bigtable.repackaged.org.threeten.bp.Duration;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.net.ssl.KeyManagerFactory;

public final class InstantiatingGrpcChannelProvider
implements TransportChannelProvider {
    private static String systemProductName;
    @VisibleForTesting
    static final Logger LOG;
    static final String DIRECT_PATH_ENV_DISABLE_DIRECT_PATH = "GOOGLE_CLOUD_DISABLE_DIRECT_PATH";
    @VisibleForTesting
    static final String DIRECT_PATH_ENV_ENABLE_XDS = "GOOGLE_CLOUD_ENABLE_DIRECT_PATH_XDS";
    private static final String MTLS_MDS_ROOT_PATH = "/run/google-mds-mtls/root.crt";
    private static final String MTLS_MDS_CERT_CHAIN_AND_KEY_PATH = "/run/google-mds-mtls/client.key";
    static final long DIRECT_PATH_KEEP_ALIVE_TIME_SECONDS = 3600L;
    static final long DIRECT_PATH_KEEP_ALIVE_TIMEOUT_SECONDS = 20L;
    static final String GCE_PRODUCTION_NAME_PRIOR_2016 = "Google";
    static final String GCE_PRODUCTION_NAME_AFTER_2016 = "Google Compute Engine";
    private final int processorCount;
    private final Executor executor;
    private final HeaderProvider headerProvider;
    private final boolean useS2A;
    private final String endpoint;
    private final EnvironmentProvider envProvider;
    @Nullable
    private final GrpcInterceptorProvider interceptorProvider;
    @Nullable
    private final Integer maxInboundMessageSize;
    @Nullable
    private final Integer maxInboundMetadataSize;
    @Nullable
    private final java.time.Duration keepAliveTime;
    @Nullable
    private final java.time.Duration keepAliveTimeout;
    @Nullable
    private final Boolean keepAliveWithoutCalls;
    private final ChannelPoolSettings channelPoolSettings;
    @Nullable
    private final Credentials credentials;
    @Nullable
    private final CallCredentials altsCallCredentials;
    @Nullable
    private final CallCredentials mtlsS2ACallCredentials;
    @Nullable
    private final ChannelPrimer channelPrimer;
    @Nullable
    private final Boolean attemptDirectPath;
    @Nullable
    private final Boolean attemptDirectPathXds;
    @Nullable
    private final Boolean allowNonDefaultServiceAccount;
    @VisibleForTesting
    final ImmutableMap<String, ?> directPathServiceConfig;
    @Nullable
    private final MtlsProvider mtlsProvider;
    @Nullable
    private final SecureSessionAgent s2aConfigProvider;
    private final List<HardBoundTokenTypes> allowedHardBoundTokenTypes;
    @VisibleForTesting
    final Map<String, String> headersWithDuplicatesRemoved = new HashMap<String, String>();
    @Nullable
    private final ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> channelConfigurator;

    private InstantiatingGrpcChannelProvider(Builder builder) {
        this.processorCount = builder.processorCount;
        this.executor = builder.executor;
        this.headerProvider = builder.headerProvider;
        this.useS2A = builder.useS2A;
        this.endpoint = builder.endpoint;
        this.allowedHardBoundTokenTypes = builder.allowedHardBoundTokenTypes;
        this.mtlsProvider = builder.mtlsProvider;
        this.s2aConfigProvider = builder.s2aConfigProvider;
        this.envProvider = builder.envProvider;
        this.interceptorProvider = builder.interceptorProvider;
        this.maxInboundMessageSize = builder.maxInboundMessageSize;
        this.maxInboundMetadataSize = builder.maxInboundMetadataSize;
        this.keepAliveTime = builder.keepAliveTime;
        this.keepAliveTimeout = builder.keepAliveTimeout;
        this.keepAliveWithoutCalls = builder.keepAliveWithoutCalls;
        this.channelPoolSettings = builder.channelPoolSettings;
        this.channelConfigurator = builder.channelConfigurator;
        this.credentials = builder.credentials;
        this.altsCallCredentials = builder.altsCallCredentials;
        this.mtlsS2ACallCredentials = builder.mtlsS2ACallCredentials;
        this.channelPrimer = builder.channelPrimer;
        this.attemptDirectPath = builder.attemptDirectPath;
        this.attemptDirectPathXds = builder.attemptDirectPathXds;
        this.allowNonDefaultServiceAccount = builder.allowNonDefaultServiceAccount;
        this.directPathServiceConfig = builder.directPathServiceConfig == null ? InstantiatingGrpcChannelProvider.getDefaultDirectPathServiceConfig() : builder.directPathServiceConfig;
    }

    @VisibleForTesting
    InstantiatingGrpcChannelProvider(Builder builder, String productName) {
        this(builder);
        systemProductName = productName;
    }

    @Override
    @Deprecated
    public boolean needsExecutor() {
        return this.executor == null;
    }

    @Override
    @Deprecated
    public TransportChannelProvider withExecutor(ScheduledExecutorService executor) {
        return this.withExecutor((Executor)executor);
    }

    @Override
    public TransportChannelProvider withExecutor(Executor executor) {
        return this.toBuilder().setExecutor(executor).build();
    }

    @Override
    public boolean needsHeaders() {
        return this.headerProvider == null;
    }

    @Override
    public TransportChannelProvider withHeaders(Map<String, String> headers) {
        return this.toBuilder().setHeaderProvider(FixedHeaderProvider.create(headers)).build();
    }

    @Override
    public String getTransportName() {
        return GrpcTransportChannel.getGrpcTransportName();
    }

    @Override
    public boolean needsEndpoint() {
        return this.endpoint == null;
    }

    @Override
    public TransportChannelProvider withEndpoint(String endpoint) {
        InstantiatingGrpcChannelProvider.validateEndpoint(endpoint);
        return this.toBuilder().setEndpoint(endpoint).build();
    }

    @Override
    public TransportChannelProvider withUseS2A(boolean useS2A) {
        return this.toBuilder().setUseS2A(useS2A).build();
    }

    @Override
    @Deprecated
    public boolean acceptsPoolSize() {
        return true;
    }

    @Override
    @Deprecated
    public TransportChannelProvider withPoolSize(int size) {
        return this.toBuilder().setPoolSize(size).build();
    }

    @Override
    public boolean needsCredentials() {
        return this.credentials == null;
    }

    @Override
    public TransportChannelProvider withCredentials(Credentials credentials) {
        return this.toBuilder().setCredentials(credentials).build();
    }

    @Override
    public TransportChannel getTransportChannel() throws IOException {
        if (this.needsHeaders()) {
            throw new IllegalStateException("getTransportChannel() called when needsHeaders() is true");
        }
        if (this.needsEndpoint()) {
            throw new IllegalStateException("getTransportChannel() called when needsEndpoint() is true");
        }
        this.logDirectPathMisconfig();
        return this.createChannel();
    }

    private TransportChannel createChannel() throws IOException {
        return GrpcTransportChannel.newBuilder().setManagedChannel(ChannelPool.create(this.channelPoolSettings, this::createSingleChannel)).setDirectPath(this.canUseDirectPath()).build();
    }

    private boolean isDirectPathEnabled() {
        String disableDirectPathEnv = this.envProvider.getenv(DIRECT_PATH_ENV_DISABLE_DIRECT_PATH);
        boolean isDirectPathDisabled = Boolean.parseBoolean(disableDirectPathEnv);
        if (isDirectPathDisabled) {
            return false;
        }
        if (this.attemptDirectPath != null) {
            return this.attemptDirectPath;
        }
        return false;
    }

    private boolean isDirectPathXdsEnabledViaBuilderOption() {
        return Boolean.TRUE.equals(this.attemptDirectPathXds);
    }

    private boolean isDirectPathXdsEnabledViaEnv() {
        String directPathXdsEnv = this.envProvider.getenv(DIRECT_PATH_ENV_ENABLE_XDS);
        return Boolean.parseBoolean(directPathXdsEnv);
    }

    @InternalApi
    public boolean isDirectPathXdsEnabled() {
        return this.isDirectPathXdsEnabledViaEnv() || this.isDirectPathXdsEnabledViaBuilderOption();
    }

    private void logDirectPathMisconfig() {
        if (this.isDirectPathXdsEnabled()) {
            if (!this.isDirectPathEnabled()) {
                if (this.isDirectPathXdsEnabledViaEnv()) {
                    LOG.log(Level.WARNING, "Env var GOOGLE_CLOUD_ENABLE_DIRECT_PATH_XDS was found and set to TRUE, but DirectPath was not enabled for this client. If this is intended for this client, please note that this is a misconfiguration and set the attemptDirectPath option as well.");
                } else if (this.isDirectPathXdsEnabledViaBuilderOption()) {
                    LOG.log(Level.WARNING, "DirectPath is misconfigured. The DirectPath XDS option was set, but the attemptDirectPath option was not. Please set both the attemptDirectPath and attemptDirectPathXds options.");
                }
            } else {
                if (!this.isCredentialDirectPathCompatible()) {
                    LOG.log(Level.WARNING, "DirectPath is misconfigured. Please make sure the credential is an instance of " + ComputeEngineCredentials.class.getName() + " .");
                }
                if (!InstantiatingGrpcChannelProvider.isOnComputeEngine()) {
                    LOG.log(Level.WARNING, "DirectPath is misconfigured. DirectPath is only available in a GCE environment.");
                }
            }
        }
    }

    @VisibleForTesting
    boolean isCredentialDirectPathCompatible() {
        if (this.needsCredentials()) {
            return false;
        }
        if (this.allowNonDefaultServiceAccount != null && this.allowNonDefaultServiceAccount.booleanValue()) {
            return true;
        }
        return this.credentials instanceof ComputeEngineCredentials;
    }

    @VisibleForTesting
    static boolean isOnComputeEngine() {
        String osName = System.getProperty("os.name");
        if ("Linux".equals(osName)) {
            String systemProductName = InstantiatingGrpcChannelProvider.getSystemProductName();
            return systemProductName.contains(GCE_PRODUCTION_NAME_PRIOR_2016) || systemProductName.contains(GCE_PRODUCTION_NAME_AFTER_2016);
        }
        return false;
    }

    private static String getSystemProductName() {
        if (systemProductName != null) {
            return systemProductName;
        }
        try {
            return Files.asCharSource(new File("/sys/class/dmi/id/product_name"), StandardCharsets.UTF_8).readFirstLine();
        }
        catch (IOException e) {
            return "";
        }
    }

    @VisibleForTesting
    boolean canUseDirectPathWithUniverseDomain() {
        return this.endpoint.contains("googleapis.com");
    }

    @VisibleForTesting
    ChannelCredentials createMtlsChannelCredentials() throws IOException, GeneralSecurityException {
        KeyStore mtlsKeyStore;
        if (this.mtlsProvider.useMtlsClientCertificate() && (mtlsKeyStore = this.mtlsProvider.getKeyStore()) != null) {
            KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            factory.init(mtlsKeyStore, new char[0]);
            return TlsChannelCredentials.newBuilder().keyManager(factory.getKeyManagers()).build();
        }
        return null;
    }

    ChannelCredentials buildS2AChannelCredentials(String s2aAddress, ChannelCredentials s2aChannelCredentials) {
        try {
            Class<?> s2aChannelCreds = Class.forName("com.google.bigtable.repackaged.io.grpc.s2a.S2AChannelCredentials");
            Class<?> s2aChannelCredsBuilder = Class.forName("com.google.bigtable.repackaged.io.grpc.s2a.S2AChannelCredentials$Builder");
            Class[] partypes = new Class[]{String.class, ChannelCredentials.class};
            Method newBuilder = s2aChannelCreds.getMethod("newBuilder", partypes);
            Object[] arglist = new Object[]{s2aAddress, s2aChannelCredentials};
            Object retObjBuilder = newBuilder.invoke(null, arglist);
            Method build = s2aChannelCredsBuilder.getMethod("build", null);
            Object retObjCreds = build.invoke(retObjBuilder, null);
            return (ChannelCredentials)retObjCreds;
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Falling back to default (TLS without S2A) because S2A APIs cannot be used: " + t.getMessage());
            return null;
        }
    }

    @VisibleForTesting
    ChannelCredentials createMtlsToS2AChannelCredentials(File trustBundle, File privateKey, File certChain) throws IOException {
        if (trustBundle == null || privateKey == null || certChain == null) {
            return null;
        }
        return TlsChannelCredentials.newBuilder().keyManager(privateKey, certChain).trustManager(trustBundle).build();
    }

    ChannelCredentials createPlaintextToS2AChannelCredentials(String plaintextAddress) {
        if (Strings.isNullOrEmpty(plaintextAddress)) {
            return null;
        }
        return this.buildS2AChannelCredentials(plaintextAddress, InsecureChannelCredentials.create());
    }

    ChannelCredentials createS2ASecuredChannelCredentials() {
        SecureSessionAgentConfig config = this.s2aConfigProvider.getConfig();
        String plaintextAddress = config.getPlaintextAddress();
        String mtlsAddress = config.getMtlsAddress();
        if (Strings.isNullOrEmpty(mtlsAddress)) {
            LOG.log(Level.INFO, "Cannot establish an mTLS connection to S2A because autoconfig endpoint did not return a mtls address to reach S2A.");
            return this.createPlaintextToS2AChannelCredentials(plaintextAddress);
        }
        File rootFile = new File(MTLS_MDS_ROOT_PATH);
        File certKeyFile = new File(MTLS_MDS_CERT_CHAIN_AND_KEY_PATH);
        if (rootFile.isFile() && certKeyFile.isFile()) {
            ChannelCredentials mtlsToS2AChannelCredentials = null;
            try {
                mtlsToS2AChannelCredentials = this.createMtlsToS2AChannelCredentials(rootFile, certKeyFile, certKeyFile);
            }
            catch (IOException ignore) {
                LOG.log(Level.WARNING, "Cannot establish an mTLS connection to S2A due to error creating MTLS to MDS TlsChannelCredentials credentials, falling back to plaintext connection to S2A: " + ignore.getMessage());
                return this.createPlaintextToS2AChannelCredentials(plaintextAddress);
            }
            return this.buildS2AChannelCredentials(mtlsAddress, mtlsToS2AChannelCredentials);
        }
        LOG.log(Level.INFO, "Cannot establish an mTLS connection to S2A because MTLS to MDS credentials do not exist on filesystem, falling back to plaintext connection to S2A");
        return this.createPlaintextToS2AChannelCredentials(plaintextAddress);
    }

    private ManagedChannel createSingleChannel() throws IOException {
        ManagedChannelBuilder<Object> builder;
        GrpcHeaderInterceptor headerInterceptor = new GrpcHeaderInterceptor(this.headersWithDuplicatesRemoved);
        GrpcMetadataHandlerInterceptor metadataHandlerInterceptor = new GrpcMetadataHandlerInterceptor();
        int colon = this.endpoint.lastIndexOf(58);
        if (colon < 0) {
            throw new IllegalStateException("invalid endpoint - should have been validated: " + this.endpoint);
        }
        int port = Integer.parseInt(this.endpoint.substring(colon + 1));
        String serviceAddress = this.endpoint.substring(0, colon);
        boolean useDirectPathXds = false;
        if (this.canUseDirectPath()) {
            CallCredentials callCreds = MoreCallCredentials.from(this.credentials);
            ChannelCredentials channelCreds = GoogleDefaultChannelCredentials.newBuilder().callCredentials(callCreds).altsCallCredentials(this.altsCallCredentials).build();
            useDirectPathXds = this.isDirectPathXdsEnabled();
            if (useDirectPathXds) {
                builder = Grpc.newChannelBuilder("google-c2p:///" + serviceAddress, channelCreds);
            } else {
                builder = Grpc.newChannelBuilderForAddress(serviceAddress, port, channelCreds);
                builder.defaultServiceConfig(this.directPathServiceConfig);
            }
            builder.keepAliveTime(3600L, TimeUnit.SECONDS);
            builder.keepAliveTimeout(20L, TimeUnit.SECONDS);
        } else {
            ChannelCredentials channelCredentials;
            try {
                channelCredentials = this.createMtlsChannelCredentials();
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e);
            }
            if (channelCredentials != null) {
                builder = Grpc.newChannelBuilder(this.endpoint, channelCredentials);
            } else {
                if (this.useS2A) {
                    channelCredentials = this.createS2ASecuredChannelCredentials();
                }
                if (channelCredentials != null) {
                    if (this.mtlsS2ACallCredentials != null) {
                        channelCredentials = CompositeChannelCredentials.create(channelCredentials, this.mtlsS2ACallCredentials);
                    }
                    builder = Grpc.newChannelBuilder(this.endpoint, channelCredentials);
                } else {
                    builder = ManagedChannelBuilder.forAddress(serviceAddress, port);
                }
            }
        }
        if (!useDirectPathXds) {
            builder.disableServiceConfigLookUp();
        }
        builder = ((ManagedChannelBuilder)((ManagedChannelBuilder)((ManagedChannelBuilder)((ManagedChannelBuilder)((ManagedChannelBuilder)builder.intercept(new GrpcChannelUUIDInterceptor())).intercept(new GrpcLoggingInterceptor())).intercept(headerInterceptor)).intercept(metadataHandlerInterceptor)).userAgent(headerInterceptor.getUserAgentHeader())).executor(this.executor);
        if (this.maxInboundMetadataSize != null) {
            builder.maxInboundMetadataSize(this.maxInboundMetadataSize);
        }
        if (this.maxInboundMessageSize != null) {
            builder.maxInboundMessageSize(this.maxInboundMessageSize);
        }
        if (this.keepAliveTime != null) {
            builder.keepAliveTime(this.keepAliveTime.toMillis(), TimeUnit.MILLISECONDS);
        }
        if (this.keepAliveTimeout != null) {
            builder.keepAliveTimeout(this.keepAliveTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        if (this.keepAliveWithoutCalls != null) {
            builder.keepAliveWithoutCalls(this.keepAliveWithoutCalls);
        }
        if (this.interceptorProvider != null) {
            builder.intercept(this.interceptorProvider.getInterceptors());
        }
        if (this.channelConfigurator != null) {
            builder = this.channelConfigurator.apply(builder);
        }
        ManagedChannel managedChannel = builder.build();
        if (this.channelPrimer != null) {
            this.channelPrimer.primeChannel(managedChannel);
        }
        return managedChannel;
    }

    private void removeApiKeyCredentialDuplicateHeaders() {
        if (this.headerProvider != null) {
            this.headersWithDuplicatesRemoved.putAll(this.headerProvider.getHeaders());
        }
        if (this.credentials != null && this.credentials instanceof ApiKeyCredentials) {
            try {
                Map<String, List<String>> credentialRequestMetatData = this.credentials.getRequestMetadata();
                if (credentialRequestMetatData != null) {
                    this.headersWithDuplicatesRemoved.keySet().removeAll(credentialRequestMetatData.keySet());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @InternalApi
    public boolean canUseDirectPath() {
        return this.isDirectPathEnabled() && this.isCredentialDirectPathCompatible() && InstantiatingGrpcChannelProvider.isOnComputeEngine() && this.canUseDirectPathWithUniverseDomain();
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @ObsoleteApi(value="Use getKeepAliveTimeDuration() instead")
    public Duration getKeepAliveTime() {
        return TimeConversionUtils.toThreetenDuration(this.getKeepAliveTimeDuration());
    }

    public java.time.Duration getKeepAliveTimeDuration() {
        return this.keepAliveTime;
    }

    @ObsoleteApi(value="Use getKeepAliveTimeoutDuration() instead")
    public Duration getKeepAliveTimeout() {
        return TimeConversionUtils.toThreetenDuration(this.getKeepAliveTimeoutDuration());
    }

    public java.time.Duration getKeepAliveTimeoutDuration() {
        return this.keepAliveTimeout;
    }

    public Boolean getKeepAliveWithoutCalls() {
        return this.keepAliveWithoutCalls;
    }

    @BetaApi(value="The surface for maximum metadata size is not stable yet and may change in the future.")
    public Integer getMaxInboundMetadataSize() {
        return this.maxInboundMetadataSize;
    }

    @BetaApi(value="Channel pool sizing api is not yet stable")
    public ChannelPoolSettings getChannelPoolSettings() {
        return this.channelPoolSettings;
    }

    @Override
    public boolean shouldAutoClose() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static ImmutableMap<String, ?> getDefaultDirectPathServiceConfig() {
        ImmutableMap pickFirstStrategy = ImmutableMap.of("pick_first", ImmutableMap.of());
        ImmutableMap childPolicy = ImmutableMap.of("childPolicy", ImmutableList.of(pickFirstStrategy));
        ImmutableMap grpcLbPolicy = ImmutableMap.of("grpclb", childPolicy);
        return ImmutableMap.of("loadBalancingConfig", ImmutableList.of(grpcLbPolicy));
    }

    private static void validateEndpoint(String endpoint) {
        int colon = endpoint.lastIndexOf(58);
        if (colon < 0) {
            throw new IllegalArgumentException(String.format("invalid endpoint, expecting \"<host>:<port>\"", new Object[0]));
        }
        Integer.parseInt(endpoint.substring(colon + 1));
    }

    static {
        LOG = Logger.getLogger(InstantiatingGrpcChannelProvider.class.getName());
    }

    public static final class Builder {
        @Deprecated
        private int processorCount;
        private Executor executor;
        private HeaderProvider headerProvider;
        private String endpoint;
        private boolean useS2A;
        private EnvironmentProvider envProvider;
        private SecureSessionAgent s2aConfigProvider = SecureSessionAgent.create();
        private MtlsProvider mtlsProvider = new MtlsProvider();
        @Nullable
        private GrpcInterceptorProvider interceptorProvider;
        @Nullable
        private Integer maxInboundMessageSize;
        @Nullable
        private Integer maxInboundMetadataSize;
        @Nullable
        private java.time.Duration keepAliveTime;
        @Nullable
        private java.time.Duration keepAliveTimeout;
        @Nullable
        private Boolean keepAliveWithoutCalls;
        @Nullable
        private ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> channelConfigurator;
        @Nullable
        private Credentials credentials;
        @Nullable
        private CallCredentials altsCallCredentials;
        @Nullable
        private CallCredentials mtlsS2ACallCredentials;
        @Nullable
        private ChannelPrimer channelPrimer;
        private ChannelPoolSettings channelPoolSettings;
        @Nullable
        private Boolean attemptDirectPath;
        @Nullable
        private Boolean attemptDirectPathXds;
        @Nullable
        private Boolean allowNonDefaultServiceAccount;
        @Nullable
        private ImmutableMap<String, ?> directPathServiceConfig;
        private List<HardBoundTokenTypes> allowedHardBoundTokenTypes;

        private Builder() {
            this.processorCount = Runtime.getRuntime().availableProcessors();
            this.envProvider = System::getenv;
            this.channelPoolSettings = ChannelPoolSettings.staticallySized(1);
            this.allowedHardBoundTokenTypes = new ArrayList<HardBoundTokenTypes>();
        }

        private Builder(InstantiatingGrpcChannelProvider provider) {
            this.processorCount = provider.processorCount;
            this.executor = provider.executor;
            this.headerProvider = provider.headerProvider;
            this.endpoint = provider.endpoint;
            this.useS2A = provider.useS2A;
            this.envProvider = provider.envProvider;
            this.interceptorProvider = provider.interceptorProvider;
            this.maxInboundMessageSize = provider.maxInboundMessageSize;
            this.maxInboundMetadataSize = provider.maxInboundMetadataSize;
            this.keepAliveTime = provider.keepAliveTime;
            this.keepAliveTimeout = provider.keepAliveTimeout;
            this.keepAliveWithoutCalls = provider.keepAliveWithoutCalls;
            this.channelConfigurator = provider.channelConfigurator;
            this.credentials = provider.credentials;
            this.altsCallCredentials = provider.altsCallCredentials;
            this.mtlsS2ACallCredentials = provider.mtlsS2ACallCredentials;
            this.channelPrimer = provider.channelPrimer;
            this.channelPoolSettings = provider.channelPoolSettings;
            this.attemptDirectPath = provider.attemptDirectPath;
            this.attemptDirectPathXds = provider.attemptDirectPathXds;
            this.allowNonDefaultServiceAccount = provider.allowNonDefaultServiceAccount;
            this.allowedHardBoundTokenTypes = provider.allowedHardBoundTokenTypes;
            this.directPathServiceConfig = provider.directPathServiceConfig;
            this.mtlsProvider = provider.mtlsProvider;
            this.s2aConfigProvider = provider.s2aConfigProvider;
        }

        @Deprecated
        Builder setProcessorCount(int processorCount) {
            this.processorCount = processorCount;
            return this;
        }

        public Builder setExecutor(Executor executor) {
            this.executor = executor;
            return this;
        }

        @Deprecated
        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            return this.setExecutor(executorProvider.getExecutor());
        }

        public Builder setHeaderProvider(HeaderProvider headerProvider) {
            this.headerProvider = headerProvider;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            InstantiatingGrpcChannelProvider.validateEndpoint(endpoint);
            this.endpoint = endpoint;
            return this;
        }

        Builder setUseS2A(boolean useS2A) {
            this.useS2A = useS2A;
            return this;
        }

        @InternalApi
        public Builder setAllowHardBoundTokenTypes(List<HardBoundTokenTypes> allowedValues) {
            this.allowedHardBoundTokenTypes = Preconditions.checkNotNull(allowedValues, "List of allowed HardBoundTokenTypes cannot be null");
            return this;
        }

        @VisibleForTesting
        Builder setMtlsProvider(MtlsProvider mtlsProvider) {
            this.mtlsProvider = mtlsProvider;
            return this;
        }

        @VisibleForTesting
        Builder setS2AConfigProvider(SecureSessionAgent s2aConfigProvider) {
            this.s2aConfigProvider = s2aConfigProvider;
            return this;
        }

        public Builder setInterceptorProvider(GrpcInterceptorProvider interceptorProvider) {
            this.interceptorProvider = interceptorProvider;
            return this;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public Builder setMaxInboundMessageSize(Integer max) {
            this.maxInboundMessageSize = max;
            return this;
        }

        public Integer getMaxInboundMessageSize() {
            return this.maxInboundMessageSize;
        }

        @BetaApi(value="The surface for maximum metadata size is not stable yet and may change in the future.")
        public Builder setMaxInboundMetadataSize(Integer max) {
            this.maxInboundMetadataSize = max;
            return this;
        }

        @BetaApi(value="The surface for maximum metadata size is not stable yet and may change in the future.")
        public Integer getMaxInboundMetadataSize() {
            return this.maxInboundMetadataSize;
        }

        @ObsoleteApi(value="Use setKeepAliveTimeDuration(java.time.Duration) instead")
        public Builder setKeepAliveTime(Duration duration) {
            return this.setKeepAliveTimeDuration(TimeConversionUtils.toJavaTimeDuration(duration));
        }

        public Builder setKeepAliveTimeDuration(java.time.Duration duration) {
            this.keepAliveTime = duration;
            return this;
        }

        @ObsoleteApi(value="Use getKeepAliveTimeDuration() instead")
        public Duration getKeepAliveTime() {
            return TimeConversionUtils.toThreetenDuration(this.getKeepAliveTimeDuration());
        }

        public java.time.Duration getKeepAliveTimeDuration() {
            return this.keepAliveTime;
        }

        @ObsoleteApi(value="Use setKeepAliveTimeoutDuration(java.time.Duration) instead")
        public Builder setKeepAliveTimeout(Duration duration) {
            return this.setKeepAliveTimeoutDuration(TimeConversionUtils.toJavaTimeDuration(duration));
        }

        public Builder setKeepAliveTimeoutDuration(java.time.Duration duration) {
            this.keepAliveTimeout = duration;
            return this;
        }

        @ObsoleteApi(value="Use getKeepAliveTimeoutDuration() instead")
        public Duration getKeepAliveTimeout() {
            return TimeConversionUtils.toThreetenDuration(this.getKeepAliveTimeoutDuration());
        }

        public java.time.Duration getKeepAliveTimeoutDuration() {
            return this.keepAliveTimeout;
        }

        public Builder setKeepAliveWithoutCalls(Boolean keepalive) {
            this.keepAliveWithoutCalls = keepalive;
            return this;
        }

        public Boolean getKeepAliveWithoutCalls() {
            return this.keepAliveWithoutCalls;
        }

        @Deprecated
        public int getPoolSize() {
            return this.channelPoolSettings.getInitialChannelCount();
        }

        @Deprecated
        public Builder setPoolSize(int poolSize) {
            this.channelPoolSettings = ChannelPoolSettings.staticallySized(poolSize);
            return this;
        }

        @Deprecated
        public Builder setChannelsPerCpu(double multiplier) {
            return this.setChannelsPerCpu(multiplier, 100);
        }

        @Deprecated
        public Builder setChannelsPerCpu(double multiplier, int maxChannels) {
            Preconditions.checkArgument(multiplier > 0.0, "multiplier must be positive");
            Preconditions.checkArgument(maxChannels > 0, "maxChannels must be positive");
            int channelCount = (int)Math.ceil((double)this.processorCount * multiplier);
            if (channelCount > maxChannels) {
                channelCount = maxChannels;
            }
            return this.setChannelPoolSettings(ChannelPoolSettings.staticallySized(channelCount));
        }

        @BetaApi(value="Channel pool sizing api is not yet stable")
        public Builder setChannelPoolSettings(ChannelPoolSettings settings) {
            this.channelPoolSettings = settings;
            return this;
        }

        public Builder setCredentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        @InternalApi(value="For internal use by google-cloud-java clients only")
        public Builder setChannelPrimer(ChannelPrimer channelPrimer) {
            this.channelPrimer = channelPrimer;
            return this;
        }

        @InternalApi(value="For internal use by google-cloud-java clients only")
        public Builder setAttemptDirectPath(boolean attemptDirectPath) {
            this.attemptDirectPath = attemptDirectPath;
            return this;
        }

        @InternalApi(value="For internal use by google-cloud-java clients only")
        public Builder setAllowNonDefaultServiceAccount(boolean allowNonDefaultServiceAccount) {
            this.allowNonDefaultServiceAccount = allowNonDefaultServiceAccount;
            return this;
        }

        @InternalApi(value="For internal use by google-cloud-java clients only")
        public Builder setAttemptDirectPathXds() {
            this.attemptDirectPathXds = true;
            return this;
        }

        @VisibleForTesting
        Builder setEnvProvider(EnvironmentProvider envProvider) {
            this.envProvider = envProvider;
            return this;
        }

        @InternalApi(value="For internal use by google-cloud-java clients only")
        public Builder setDirectPathServiceConfig(Map<String, ?> serviceConfig) {
            Preconditions.checkNotNull(serviceConfig, "serviceConfig");
            this.directPathServiceConfig = ImmutableMap.copyOf(serviceConfig);
            return this;
        }

        boolean isMtlsS2AHardBoundTokensEnabled() {
            if (!this.useS2A || this.allowedHardBoundTokenTypes.isEmpty() || this.credentials == null || !(this.credentials instanceof ComputeEngineCredentials)) {
                return false;
            }
            return this.allowedHardBoundTokenTypes.stream().anyMatch(val -> val.equals((Object)HardBoundTokenTypes.MTLS_S2A));
        }

        boolean isDirectPathBoundTokenEnabled() {
            if (this.allowedHardBoundTokenTypes.isEmpty() || this.credentials == null || !(this.credentials instanceof ComputeEngineCredentials)) {
                return false;
            }
            return this.allowedHardBoundTokenTypes.stream().anyMatch(val -> val.equals((Object)HardBoundTokenTypes.ALTS));
        }

        CallCredentials createHardBoundTokensCallCredentials(ComputeEngineCredentials.GoogleAuthTransport googleAuthTransport, ComputeEngineCredentials.BindingEnforcement bindingEnforcement) {
            ComputeEngineCredentials.Builder credsBuilder = ((ComputeEngineCredentials)this.credentials).toBuilder();
            return MoreCallCredentials.from(ComputeEngineCredentials.newBuilder().setScopes(credsBuilder.getScopes()).setHttpTransportFactory(credsBuilder.getHttpTransportFactory()).setGoogleAuthTransport(googleAuthTransport).setBindingEnforcement(bindingEnforcement).build());
        }

        public InstantiatingGrpcChannelProvider build() {
            if (this.isMtlsS2AHardBoundTokensEnabled()) {
                this.mtlsS2ACallCredentials = this.createHardBoundTokensCallCredentials(ComputeEngineCredentials.GoogleAuthTransport.MTLS, ComputeEngineCredentials.BindingEnforcement.ON);
            }
            if (this.isDirectPathBoundTokenEnabled()) {
                this.altsCallCredentials = this.createHardBoundTokensCallCredentials(ComputeEngineCredentials.GoogleAuthTransport.ALTS, null);
            }
            InstantiatingGrpcChannelProvider instantiatingGrpcChannelProvider = new InstantiatingGrpcChannelProvider(this);
            instantiatingGrpcChannelProvider.removeApiKeyCredentialDuplicateHeaders();
            return instantiatingGrpcChannelProvider;
        }

        @BetaApi(value="Surface for advanced channel configuration is not yet stable")
        public Builder setChannelConfigurator(@Nullable ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> channelConfigurator) {
            this.channelConfigurator = channelConfigurator;
            return this;
        }

        @Nullable
        public ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> getChannelConfigurator() {
            return this.channelConfigurator;
        }
    }

    @InternalApi
    public static enum HardBoundTokenTypes {
        ALTS,
        MTLS_S2A;

    }
}

