/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.api.gax.rpc;

import com.google.bigtable.repackaged.com.google.api.core.ApiClock;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.core.ObsoleteApi;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.Watchdog;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.WatchdogProvider;
import com.google.bigtable.repackaged.com.google.api.gax.util.TimeConversionUtils;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.org.threeten.bp.Duration;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public final class InstantiatingWatchdogProvider
implements WatchdogProvider {
    @Nullable
    private final ApiClock clock;
    @Nullable
    private final ScheduledExecutorService executor;
    @Nullable
    private final java.time.Duration checkInterval;

    public static WatchdogProvider create() {
        return new InstantiatingWatchdogProvider(null, null, null);
    }

    private InstantiatingWatchdogProvider(@Nullable ApiClock clock, @Nullable ScheduledExecutorService executor, @Nullable java.time.Duration checkInterval) {
        this.clock = clock;
        this.executor = executor;
        this.checkInterval = checkInterval;
    }

    @Override
    public boolean needsClock() {
        return this.clock == null;
    }

    @Override
    public WatchdogProvider withClock(@Nonnull ApiClock clock) {
        return new InstantiatingWatchdogProvider(Preconditions.checkNotNull(clock), this.executor, this.checkInterval);
    }

    @Override
    public boolean needsCheckInterval() {
        return this.checkInterval == null;
    }

    @Override
    @ObsoleteApi(value="Use withCheckIntervalDuration(java.time.Duration) instead")
    public WatchdogProvider withCheckInterval(@Nonnull Duration checkInterval) {
        return this.withCheckIntervalDuration(TimeConversionUtils.toJavaTimeDuration(checkInterval));
    }

    @Override
    public WatchdogProvider withCheckIntervalDuration(@Nonnull java.time.Duration checkInterval) {
        return new InstantiatingWatchdogProvider(this.clock, this.executor, Preconditions.checkNotNull(checkInterval));
    }

    @Override
    public boolean needsExecutor() {
        return this.executor == null;
    }

    @Override
    public WatchdogProvider withExecutor(ScheduledExecutorService executor) {
        return new InstantiatingWatchdogProvider(this.clock, Preconditions.checkNotNull(executor), this.checkInterval);
    }

    @Override
    @Nullable
    public Watchdog getWatchdog() {
        Preconditions.checkState(!this.needsClock(), "A clock is needed");
        Preconditions.checkState(!this.needsCheckInterval(), "A check interval is needed");
        Preconditions.checkState(!this.needsExecutor(), "An executor is needed");
        if (this.checkInterval.isZero()) {
            return null;
        }
        return Watchdog.createDuration(this.clock, this.checkInterval, this.executor);
    }

    @Override
    public boolean shouldAutoClose() {
        return true;
    }
}

