/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.api.gax.rpc;

import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiCallContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ResponseObserver;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.Watchdog;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import java.time.Duration;

class WatchdogServerStreamingCallable<RequestT, ResponseT>
extends ServerStreamingCallable<RequestT, ResponseT> {
    private final ServerStreamingCallable<RequestT, ResponseT> inner;
    private final Watchdog watchdog;

    WatchdogServerStreamingCallable(ServerStreamingCallable<RequestT, ResponseT> inner, Watchdog watchdog) {
        Preconditions.checkNotNull(inner);
        Preconditions.checkNotNull(watchdog);
        this.inner = inner;
        this.watchdog = watchdog;
    }

    @Override
    public void call(RequestT request, ResponseObserver<ResponseT> responseObserver, ApiCallContext context) {
        Duration waitTimeout = MoreObjects.firstNonNull(context.getStreamWaitTimeoutDuration(), Duration.ZERO);
        Duration idleTimeout = MoreObjects.firstNonNull(context.getStreamIdleTimeoutDuration(), Duration.ZERO);
        responseObserver = this.watchdog.watchDuration(responseObserver, waitTimeout, idleTimeout);
        this.inner.call(request, responseObserver, context);
    }
}

