/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.auth.oauth2;

import com.google.bigtable.repackaged.com.google.api.client.http.GenericUrl;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpBackOffIOExceptionHandler;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpRequest;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpResponse;
import com.google.bigtable.repackaged.com.google.api.client.json.JsonObjectParser;
import com.google.bigtable.repackaged.com.google.api.client.util.ExponentialBackOff;
import com.google.bigtable.repackaged.com.google.api.client.util.GenericData;
import com.google.bigtable.repackaged.com.google.auth.http.HttpTransportFactory;
import com.google.bigtable.repackaged.com.google.auth.oauth2.ComputeEngineCredentials;
import com.google.bigtable.repackaged.com.google.auth.oauth2.OAuth2Utils;
import com.google.bigtable.repackaged.com.google.auth.oauth2.SecureSessionAgentConfig;
import com.google.bigtable.repackaged.com.google.common.collect.Iterables;
import com.google.bigtable.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class SecureSessionAgent {
    static final String S2A_JSON_KEY = "s2a";
    static final String S2A_PLAINTEXT_ADDRESS_JSON_KEY = "plaintext_address";
    static final String S2A_MTLS_ADDRESS_JSON_KEY = "mtls_address";
    static final String S2A_CONFIG_ENDPOINT_POSTFIX = "/computeMetadata/v1/instance/platform-security/auto-mtls-configuration";
    static final String METADATA_FLAVOR = "Metadata-Flavor";
    static final String GOOGLE = "Google";
    private static final Set<Integer> RETRYABLE_STATUS_CODES = new HashSet<Integer>(Arrays.asList(500, 502, 503));
    private static final String PARSE_ERROR_S2A = "Error parsing S2A Config from MDS JSON response.";
    private static final String MDS_MTLS_ENDPOINT = ComputeEngineCredentials.getMetadataServerUrl() + "/computeMetadata/v1/instance/platform-security/auto-mtls-configuration";
    private transient HttpTransportFactory transportFactory;

    SecureSessionAgent(Builder builder) {
        this.transportFactory = builder.getHttpTransportFactory();
    }

    public SecureSessionAgentConfig getConfig() {
        return this.getSecureSessionAgentConfigFromMDS();
    }

    public static SecureSessionAgent create() {
        return SecureSessionAgent.newBuilder().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private SecureSessionAgentConfig getSecureSessionAgentConfigFromMDS() {
        if (this.transportFactory == null) {
            this.transportFactory = Iterables.getFirst(ServiceLoader.load(HttpTransportFactory.class), OAuth2Utils.HTTP_TRANSPORT_FACTORY);
        }
        HttpRequest request = null;
        GenericUrl genericUrl = new GenericUrl(MDS_MTLS_ENDPOINT);
        try {
            request = this.transportFactory.create().createRequestFactory().buildGetRequest(genericUrl);
        }
        catch (IOException ignore) {
            return SecureSessionAgentConfig.createBuilder().build();
        }
        request.setParser(new JsonObjectParser(OAuth2Utils.JSON_FACTORY));
        request.getHeaders().set(METADATA_FLAVOR, GOOGLE);
        request.setThrowExceptionOnExecuteError(false);
        request.setNumberOfRetries(3);
        ExponentialBackOff backoff = new ExponentialBackOff.Builder().setInitialIntervalMillis(1000).setRandomizationFactor(0.1).setMultiplier(2.0).build();
        request.setUnsuccessfulResponseHandler(new HttpBackOffUnsuccessfulResponseHandler(backoff).setBackOffRequired(response -> RETRYABLE_STATUS_CODES.contains(response.getStatusCode())));
        request.setIOExceptionHandler(new HttpBackOffIOExceptionHandler(backoff));
        GenericData responseData = null;
        try {
            HttpResponse response2 = request.execute();
            InputStream content = response2.getContent();
            if (content == null) {
                return SecureSessionAgentConfig.createBuilder().build();
            }
            responseData = response2.parseAs(GenericData.class);
        }
        catch (IOException ignore) {
            return SecureSessionAgentConfig.createBuilder().build();
        }
        String plaintextS2AAddress = "";
        String mtlsS2AAddress = "";
        Map s2aAddressConfig = (Map)responseData.get(S2A_JSON_KEY);
        if (s2aAddressConfig == null) {
            return SecureSessionAgentConfig.createBuilder().build();
        }
        try {
            plaintextS2AAddress = OAuth2Utils.validateString(s2aAddressConfig, S2A_PLAINTEXT_ADDRESS_JSON_KEY, PARSE_ERROR_S2A);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            mtlsS2AAddress = OAuth2Utils.validateString(s2aAddressConfig, S2A_MTLS_ADDRESS_JSON_KEY, PARSE_ERROR_S2A);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return SecureSessionAgentConfig.createBuilder().setPlaintextAddress(plaintextS2AAddress).setMtlsAddress(mtlsS2AAddress).build();
    }

    public static class Builder {
        private HttpTransportFactory transportFactory;

        protected Builder() {
        }

        @CanIgnoreReturnValue
        public Builder setHttpTransportFactory(HttpTransportFactory transportFactory) {
            this.transportFactory = transportFactory;
            return this;
        }

        public HttpTransportFactory getHttpTransportFactory() {
            return this.transportFactory;
        }

        public SecureSessionAgent build() {
            return new SecureSessionAgent(this);
        }
    }
}

