/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.auth.oauth2;

import com.google.bigtable.repackaged.com.google.api.client.http.GenericUrl;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpBackOffIOExceptionHandler;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpContent;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpHeaders;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpRequest;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpRequestFactory;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpResponse;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpResponseException;
import com.google.bigtable.repackaged.com.google.api.client.http.UrlEncodedContent;
import com.google.bigtable.repackaged.com.google.api.client.json.JsonFactory;
import com.google.bigtable.repackaged.com.google.api.client.json.JsonObjectParser;
import com.google.bigtable.repackaged.com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.bigtable.repackaged.com.google.api.client.json.webtoken.JsonWebToken;
import com.google.bigtable.repackaged.com.google.api.client.util.ExponentialBackOff;
import com.google.bigtable.repackaged.com.google.api.client.util.GenericData;
import com.google.bigtable.repackaged.com.google.api.client.util.Joiner;
import com.google.bigtable.repackaged.com.google.api.client.util.Preconditions;
import com.google.bigtable.repackaged.com.google.auth.CredentialTypeForMetrics;
import com.google.bigtable.repackaged.com.google.auth.RequestMetadataCallback;
import com.google.bigtable.repackaged.com.google.auth.ServiceAccountSigner;
import com.google.bigtable.repackaged.com.google.auth.http.HttpTransportFactory;
import com.google.bigtable.repackaged.com.google.auth.oauth2.AccessToken;
import com.google.bigtable.repackaged.com.google.auth.oauth2.GoogleAuthException;
import com.google.bigtable.repackaged.com.google.auth.oauth2.GoogleCredentials;
import com.google.bigtable.repackaged.com.google.auth.oauth2.IdToken;
import com.google.bigtable.repackaged.com.google.auth.oauth2.IdTokenProvider;
import com.google.bigtable.repackaged.com.google.auth.oauth2.JwtClaims;
import com.google.bigtable.repackaged.com.google.auth.oauth2.JwtCredentials;
import com.google.bigtable.repackaged.com.google.auth.oauth2.JwtProvider;
import com.google.bigtable.repackaged.com.google.auth.oauth2.LoggerProvider;
import com.google.bigtable.repackaged.com.google.auth.oauth2.LoggingUtils;
import com.google.bigtable.repackaged.com.google.auth.oauth2.MetricsUtils;
import com.google.bigtable.repackaged.com.google.auth.oauth2.OAuth2Utils;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableSet;
import com.google.bigtable.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;

public class ServiceAccountCredentials
extends GoogleCredentials
implements ServiceAccountSigner,
IdTokenProvider,
JwtProvider {
    private static final long serialVersionUID = 7807543542681217978L;
    private static final String GRANT_TYPE = "urn:ietf:params:oauth:grant-type:jwt-bearer";
    private static final String PARSE_ERROR_PREFIX = "Error parsing token refresh response. ";
    private static final int TWELVE_HOURS_IN_SECONDS = 43200;
    private static final int DEFAULT_LIFETIME_IN_SECONDS = 3600;
    private static final LoggerProvider LOGGER_PROVIDER = LoggerProvider.forClazz(ServiceAccountCredentials.class);
    private final String clientId;
    private final String clientEmail;
    private final PrivateKey privateKey;
    private final String privateKeyId;
    private final String serviceAccountUser;
    private final String projectId;
    private final String transportFactoryClassName;
    private final URI tokenServerUri;
    private final Collection<String> scopes;
    private final Collection<String> defaultScopes;
    private final int lifetime;
    private final boolean useJwtAccessWithScope;
    private final boolean defaultRetriesEnabled;
    private transient HttpTransportFactory transportFactory;
    private transient JwtCredentials selfSignedJwtCredentialsWithScope = null;

    ServiceAccountCredentials(Builder builder) {
        super(builder);
        this.clientId = builder.clientId;
        this.clientEmail = Preconditions.checkNotNull(builder.clientEmail);
        this.privateKey = Preconditions.checkNotNull(builder.privateKey);
        this.privateKeyId = builder.privateKeyId;
        this.scopes = builder.scopes == null ? ImmutableSet.of() : ImmutableSet.copyOf(builder.scopes);
        this.defaultScopes = builder.defaultScopes == null ? ImmutableSet.of() : ImmutableSet.copyOf(builder.defaultScopes);
        this.transportFactory = MoreObjects.firstNonNull(builder.transportFactory, ServiceAccountCredentials.getFromServiceLoader(HttpTransportFactory.class, OAuth2Utils.HTTP_TRANSPORT_FACTORY));
        this.transportFactoryClassName = this.transportFactory.getClass().getName();
        this.tokenServerUri = builder.tokenServerUri == null ? OAuth2Utils.TOKEN_SERVER_URI : builder.tokenServerUri;
        this.serviceAccountUser = builder.serviceAccountUser;
        this.projectId = builder.projectId;
        if (builder.lifetime > 43200) {
            throw new IllegalStateException("lifetime must be less than or equal to 43200");
        }
        this.lifetime = builder.lifetime;
        this.useJwtAccessWithScope = builder.useJwtAccessWithScope;
        this.defaultRetriesEnabled = builder.defaultRetriesEnabled;
    }

    static ServiceAccountCredentials fromJson(Map<String, Object> json, HttpTransportFactory transportFactory) throws IOException {
        String clientId = (String)json.get("client_id");
        String clientEmail = (String)json.get("client_email");
        String privateKeyPkcs8 = (String)json.get("private_key");
        String privateKeyId = (String)json.get("private_key_id");
        String projectId = (String)json.get("project_id");
        String tokenServerUriStringFromCreds = (String)json.get("token_uri");
        String quotaProjectId = (String)json.get("quota_project_id");
        String universeDomain = (String)json.get("universe_domain");
        URI tokenServerUriFromCreds = null;
        try {
            if (tokenServerUriStringFromCreds != null) {
                tokenServerUriFromCreds = new URI(tokenServerUriStringFromCreds);
            }
        }
        catch (URISyntaxException e) {
            throw new IOException("Token server URI specified in 'token_uri' could not be parsed.");
        }
        if (clientId == null || clientEmail == null || privateKeyPkcs8 == null || privateKeyId == null) {
            throw new IOException("Error reading service account credential from JSON, expecting  'client_id', 'client_email', 'private_key' and 'private_key_id'.");
        }
        Builder builder = ServiceAccountCredentials.newBuilder().setClientId(clientId).setClientEmail(clientEmail).setPrivateKeyId(privateKeyId).setHttpTransportFactory(transportFactory).setTokenServerUri(tokenServerUriFromCreds).setProjectId(projectId).setQuotaProjectId(quotaProjectId).setUniverseDomain(universeDomain);
        return ServiceAccountCredentials.fromPkcs8(privateKeyPkcs8, builder);
    }

    public static ServiceAccountCredentials fromPkcs8(String clientId, String clientEmail, String privateKeyPkcs8, String privateKeyId, Collection<String> scopes) throws IOException {
        Builder builder = ServiceAccountCredentials.newBuilder().setClientId(clientId).setClientEmail(clientEmail).setPrivateKeyId(privateKeyId).setScopes(scopes);
        return ServiceAccountCredentials.fromPkcs8(privateKeyPkcs8, builder);
    }

    public static ServiceAccountCredentials fromPkcs8(String clientId, String clientEmail, String privateKeyPkcs8, String privateKeyId, Collection<String> scopes, Collection<String> defaultScopes) throws IOException {
        Builder builder = ServiceAccountCredentials.newBuilder().setClientId(clientId).setClientEmail(clientEmail).setPrivateKeyId(privateKeyId).setScopes(scopes, defaultScopes);
        return ServiceAccountCredentials.fromPkcs8(privateKeyPkcs8, builder);
    }

    public static ServiceAccountCredentials fromPkcs8(String clientId, String clientEmail, String privateKeyPkcs8, String privateKeyId, Collection<String> scopes, HttpTransportFactory transportFactory, URI tokenServerUri) throws IOException {
        Builder builder = ServiceAccountCredentials.newBuilder().setClientId(clientId).setClientEmail(clientEmail).setPrivateKeyId(privateKeyId).setScopes(scopes).setHttpTransportFactory(transportFactory).setTokenServerUri(tokenServerUri);
        return ServiceAccountCredentials.fromPkcs8(privateKeyPkcs8, builder);
    }

    public static ServiceAccountCredentials fromPkcs8(String clientId, String clientEmail, String privateKeyPkcs8, String privateKeyId, Collection<String> scopes, Collection<String> defaultScopes, HttpTransportFactory transportFactory, URI tokenServerUri) throws IOException {
        Builder builder = ServiceAccountCredentials.newBuilder().setClientId(clientId).setClientEmail(clientEmail).setPrivateKeyId(privateKeyId).setScopes(scopes, defaultScopes).setHttpTransportFactory(transportFactory).setTokenServerUri(tokenServerUri);
        return ServiceAccountCredentials.fromPkcs8(privateKeyPkcs8, builder);
    }

    public static ServiceAccountCredentials fromPkcs8(String clientId, String clientEmail, String privateKeyPkcs8, String privateKeyId, Collection<String> scopes, HttpTransportFactory transportFactory, URI tokenServerUri, String serviceAccountUser) throws IOException {
        Builder builder = ServiceAccountCredentials.newBuilder().setClientId(clientId).setClientEmail(clientEmail).setPrivateKeyId(privateKeyId).setScopes(scopes).setHttpTransportFactory(transportFactory).setTokenServerUri(tokenServerUri).setServiceAccountUser(serviceAccountUser);
        return ServiceAccountCredentials.fromPkcs8(privateKeyPkcs8, builder);
    }

    public static ServiceAccountCredentials fromPkcs8(String clientId, String clientEmail, String privateKeyPkcs8, String privateKeyId, Collection<String> scopes, Collection<String> defaultScopes, HttpTransportFactory transportFactory, URI tokenServerUri, String serviceAccountUser) throws IOException {
        Builder builder = ServiceAccountCredentials.newBuilder().setClientId(clientId).setClientEmail(clientEmail).setPrivateKeyId(privateKeyId).setScopes(scopes, defaultScopes).setHttpTransportFactory(transportFactory).setTokenServerUri(tokenServerUri).setServiceAccountUser(serviceAccountUser);
        return ServiceAccountCredentials.fromPkcs8(privateKeyPkcs8, builder);
    }

    static ServiceAccountCredentials fromPkcs8(String privateKeyPkcs8, Builder builder) throws IOException {
        PrivateKey privateKey = OAuth2Utils.privateKeyFromPkcs8(privateKeyPkcs8);
        builder.setPrivateKey(privateKey);
        return new ServiceAccountCredentials(builder);
    }

    public static ServiceAccountCredentials fromStream(InputStream credentialsStream) throws IOException {
        return ServiceAccountCredentials.fromStream(credentialsStream, OAuth2Utils.HTTP_TRANSPORT_FACTORY);
    }

    public static ServiceAccountCredentials fromStream(InputStream credentialsStream, HttpTransportFactory transportFactory) throws IOException {
        ServiceAccountCredentials credential = (ServiceAccountCredentials)GoogleCredentials.fromStream(credentialsStream, transportFactory);
        if (credential == null) {
            throw new IOException("Error reading credentials from stream, ServiceAccountCredentials type is not recognized.");
        }
        return credential;
    }

    @Override
    public boolean createScopedRequired() {
        return this.scopes.isEmpty() && this.defaultScopes.isEmpty();
    }

    @VisibleForTesting
    boolean isConfiguredForDomainWideDelegation() {
        return this.serviceAccountUser != null && this.serviceAccountUser.length() > 0;
    }

    private GenericData parseResponseAs(HttpResponse response) throws IOException {
        GenericData genericData = response.parseAs(GenericData.class);
        LoggingUtils.logResponsePayload(genericData, LOGGER_PROVIDER, "Response payload");
        return genericData;
    }

    @Override
    public AccessToken refreshAccessToken() throws IOException {
        HttpResponse response2;
        JsonFactory jsonFactory = OAuth2Utils.JSON_FACTORY;
        long currentTime = this.clock.currentTimeMillis();
        String assertion = this.createAssertion(jsonFactory, currentTime);
        GenericData tokenRequest = new GenericData();
        tokenRequest.set("grant_type", GRANT_TYPE);
        tokenRequest.set("assertion", assertion);
        UrlEncodedContent content = new UrlEncodedContent(tokenRequest);
        HttpRequestFactory requestFactory = this.transportFactory.create().createRequestFactory();
        HttpRequest request = requestFactory.buildPostRequest(new GenericUrl(this.tokenServerUri), content);
        MetricsUtils.setMetricsHeader(request, MetricsUtils.getGoogleCredentialsMetricsHeader(MetricsUtils.RequestType.ACCESS_TOKEN_REQUEST, this.getMetricsCredentialType()));
        if (this.defaultRetriesEnabled) {
            request.setNumberOfRetries(3);
        } else {
            request.setNumberOfRetries(0);
        }
        request.setParser(new JsonObjectParser(jsonFactory));
        LoggingUtils.logRequest(request, LOGGER_PROVIDER, "Sending request to refresh access token");
        ExponentialBackOff backoff = new ExponentialBackOff.Builder().setInitialIntervalMillis(1000).setRandomizationFactor(0.1).setMultiplier(2.0).build();
        request.setUnsuccessfulResponseHandler(new HttpBackOffUnsuccessfulResponseHandler(backoff).setBackOffRequired(response -> {
            int code = response.getStatusCode();
            return OAuth2Utils.TOKEN_ENDPOINT_RETRYABLE_STATUS_CODES.contains(code);
        }));
        request.setIOExceptionHandler(new HttpBackOffIOExceptionHandler(backoff));
        String errorTemplate = "Error getting access token for service account: %s, iss: %s";
        try {
            response2 = request.execute();
            LoggingUtils.logResponse(response2, LOGGER_PROVIDER, "Received response for refresh access token");
        }
        catch (HttpResponseException re) {
            String message = String.format(errorTemplate, re.getMessage(), this.getIssuer());
            throw GoogleAuthException.createWithTokenEndpointResponseException(re, message);
        }
        catch (IOException e) {
            throw GoogleAuthException.createWithTokenEndpointIOException(e, String.format(errorTemplate, e.getMessage(), this.getIssuer()));
        }
        GenericData responseData = this.parseResponseAs(response2);
        String accessToken = OAuth2Utils.validateString(responseData, "access_token", PARSE_ERROR_PREFIX);
        int expiresInSeconds = OAuth2Utils.validateInt32(responseData, "expires_in", PARSE_ERROR_PREFIX);
        long expiresAtMilliseconds = this.clock.currentTimeMillis() + (long)expiresInSeconds * 1000L;
        return new AccessToken(accessToken, new Date(expiresAtMilliseconds));
    }

    @Override
    public IdToken idTokenWithAudience(String targetAudience, List<IdTokenProvider.Option> options) throws IOException {
        return this.isDefaultUniverseDomain() ? this.getIdTokenOauthEndpoint(targetAudience) : this.getIdTokenIamEndpoint(targetAudience);
    }

    private IdToken getIdTokenOauthEndpoint(String targetAudience) throws IOException {
        long currentTime = this.clock.currentTimeMillis();
        String assertion = this.createAssertionForIdToken(currentTime, this.tokenServerUri.toString(), targetAudience);
        ImmutableMap<String, String> requestParams = ImmutableMap.of("grant_type", GRANT_TYPE, "assertion", assertion);
        GenericData tokenRequest = new GenericData();
        requestParams.forEach(tokenRequest::set);
        UrlEncodedContent content = new UrlEncodedContent(tokenRequest);
        HttpRequest request = this.buildIdTokenRequest(this.tokenServerUri, this.transportFactory, content);
        MetricsUtils.setMetricsHeader(request, MetricsUtils.getGoogleCredentialsMetricsHeader(MetricsUtils.RequestType.ID_TOKEN_REQUEST, this.getMetricsCredentialType()));
        LoggingUtils.logRequest(request, LOGGER_PROVIDER, "Sending request to get ID token");
        HttpResponse httpResponse = this.executeRequest(request);
        LoggingUtils.logResponse(httpResponse, LOGGER_PROVIDER, "Received response for ID token request");
        GenericData responseData = this.parseResponseAs(httpResponse);
        String rawToken = OAuth2Utils.validateString(responseData, "id_token", PARSE_ERROR_PREFIX);
        return IdToken.create(rawToken);
    }

    private IdToken getIdTokenIamEndpoint(String targetAudience) throws IOException {
        JwtCredentials selfSignedJwtCredentials = this.createSelfSignedJwtCredentials(null, ImmutableList.of("https://www.googleapis.com/auth/iam"));
        Map<String, List<String>> responseMetadata = selfSignedJwtCredentials.getRequestMetadata(null);
        String accessToken = responseMetadata.get("Authorization").get(0);
        ImmutableMap<String, String> requestParams = ImmutableMap.of("audience", targetAudience, "includeEmail", "true", "useEmailAzp", "true");
        GenericData tokenRequest = new GenericData();
        requestParams.forEach(tokenRequest::set);
        UrlEncodedContent content = new UrlEncodedContent(tokenRequest);
        URI iamIdTokenUri = URI.create(String.format("https://iamcredentials.%s/v1/projects/-/serviceAccounts/%s:generateIdToken", this.getUniverseDomain(), this.clientEmail));
        HttpRequest request = this.buildIdTokenRequest(iamIdTokenUri, this.transportFactory, content);
        request.setHeaders(new HttpHeaders().set("Authorization", accessToken));
        LoggingUtils.logRequest(request, LOGGER_PROVIDER, "Sending request to get ID token");
        HttpResponse httpResponse = this.executeRequest(request);
        LoggingUtils.logResponse(httpResponse, LOGGER_PROVIDER, "Received response for ID token request");
        GenericData responseData = this.parseResponseAs(httpResponse);
        String rawToken = OAuth2Utils.validateString(responseData, "token", PARSE_ERROR_PREFIX);
        return IdToken.create(rawToken);
    }

    private HttpRequest buildIdTokenRequest(URI uri, HttpTransportFactory transportFactory, HttpContent content) throws IOException {
        JsonFactory jsonFactory = OAuth2Utils.JSON_FACTORY;
        HttpRequestFactory requestFactory = transportFactory.create().createRequestFactory();
        HttpRequest request = requestFactory.buildPostRequest(new GenericUrl(uri), content);
        request.setParser(new JsonObjectParser(jsonFactory));
        return request;
    }

    private HttpResponse executeRequest(HttpRequest request) throws IOException {
        HttpResponse response;
        try {
            response = request.execute();
        }
        catch (IOException e) {
            throw new IOException(String.format("Error getting id token for service account: %s, iss: %s", e.getMessage(), this.getIssuer()), e);
        }
        return response;
    }

    @Override
    public ServiceAccountCredentials createWithCustomRetryStrategy(boolean defaultRetriesEnabled) {
        return this.toBuilder().setDefaultRetriesEnabled(defaultRetriesEnabled).build();
    }

    @Override
    public GoogleCredentials createScoped(Collection<String> newScopes) {
        return this.createScoped(newScopes, null);
    }

    @Override
    public GoogleCredentials createScoped(Collection<String> newScopes, Collection<String> newDefaultScopes) {
        return this.toBuilder().setScopes(newScopes, newDefaultScopes).setAccessToken(null).build();
    }

    public ServiceAccountCredentials createWithCustomLifetime(int lifetime) {
        return this.toBuilder().setLifetime(lifetime).build();
    }

    public ServiceAccountCredentials createWithUseJwtAccessWithScope(boolean useJwtAccessWithScope) {
        return this.toBuilder().setUseJwtAccessWithScope(useJwtAccessWithScope).build();
    }

    @Override
    public GoogleCredentials createDelegated(String user) {
        return this.toBuilder().setServiceAccountUser(user).build();
    }

    public final String getClientId() {
        return this.clientId;
    }

    public final String getClientEmail() {
        return this.clientEmail;
    }

    public final PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public final String getPrivateKeyId() {
        return this.privateKeyId;
    }

    public final Collection<String> getScopes() {
        return this.scopes;
    }

    public final Collection<String> getDefaultScopes() {
        return this.defaultScopes;
    }

    public final String getServiceAccountUser() {
        return this.serviceAccountUser;
    }

    public final String getProjectId() {
        return this.projectId;
    }

    public final URI getTokenServerUri() {
        return this.tokenServerUri;
    }

    private String getIssuer() {
        return this.clientEmail;
    }

    @VisibleForTesting
    int getLifetime() {
        return this.lifetime;
    }

    public boolean getUseJwtAccessWithScope() {
        return this.useJwtAccessWithScope;
    }

    @VisibleForTesting
    JwtCredentials getSelfSignedJwtCredentialsWithScope() {
        return this.selfSignedJwtCredentialsWithScope;
    }

    @Override
    public String getAccount() {
        return this.getClientEmail();
    }

    @Override
    public byte[] sign(byte[] toSign) {
        try {
            Signature signer = Signature.getInstance("SHA256withRSA");
            signer.initSign(this.getPrivateKey());
            signer.update(toSign);
            return signer.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException ex) {
            throw new ServiceAccountSigner.SigningException("Failed to sign the provided bytes", ex);
        }
    }

    @Override
    public JwtCredentials jwtWithClaims(JwtClaims newClaims) {
        JwtClaims.Builder claimsBuilder = JwtClaims.newBuilder().setIssuer(this.getIssuer()).setSubject(this.clientEmail);
        return JwtCredentials.newBuilder().setPrivateKey(this.privateKey).setPrivateKeyId(this.privateKeyId).setJwtClaims(claimsBuilder.build().merge(newClaims)).setClock(this.clock).build();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clientId, this.clientEmail, this.privateKey, this.privateKeyId, this.transportFactoryClassName, this.tokenServerUri, this.scopes, this.defaultScopes, this.lifetime, this.useJwtAccessWithScope, this.defaultRetriesEnabled, super.hashCode());
    }

    @Override
    protected MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("clientId", this.clientId).add("clientEmail", this.clientEmail).add("privateKeyId", this.privateKeyId).add("transportFactoryClassName", this.transportFactoryClassName).add("tokenServerUri", this.tokenServerUri).add("scopes", this.scopes).add("defaultScopes", this.defaultScopes).add("serviceAccountUser", this.serviceAccountUser).add("lifetime", this.lifetime).add("useJwtAccessWithScope", this.useJwtAccessWithScope).add("defaultRetriesEnabled", this.defaultRetriesEnabled);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ServiceAccountCredentials)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ServiceAccountCredentials other = (ServiceAccountCredentials)obj;
        return Objects.equals(this.clientId, other.clientId) && Objects.equals(this.clientEmail, other.clientEmail) && Objects.equals(this.privateKey, other.privateKey) && Objects.equals(this.privateKeyId, other.privateKeyId) && Objects.equals(this.transportFactoryClassName, other.transportFactoryClassName) && Objects.equals(this.tokenServerUri, other.tokenServerUri) && Objects.equals(this.scopes, other.scopes) && Objects.equals(this.defaultScopes, other.defaultScopes) && Objects.equals(this.lifetime, other.lifetime) && Objects.equals(this.useJwtAccessWithScope, other.useJwtAccessWithScope) && Objects.equals(this.defaultRetriesEnabled, other.defaultRetriesEnabled);
    }

    String createAssertion(JsonFactory jsonFactory, long currentTime) throws IOException {
        String assertion;
        JsonWebSignature.Header header = new JsonWebSignature.Header();
        header.setAlgorithm("RS256");
        header.setType("JWT");
        header.setKeyId(this.privateKeyId);
        JsonWebToken.Payload payload = new JsonWebToken.Payload();
        payload.setIssuer(this.getIssuer());
        payload.setIssuedAtTimeSeconds(currentTime / 1000L);
        payload.setExpirationTimeSeconds(currentTime / 1000L + (long)this.lifetime);
        payload.setSubject(this.serviceAccountUser);
        if (this.scopes.isEmpty()) {
            payload.put("scope", (Object)Joiner.on(' ').join(this.defaultScopes));
        } else {
            payload.put("scope", (Object)Joiner.on(' ').join(this.scopes));
        }
        payload.setAudience(OAuth2Utils.TOKEN_SERVER_URI.toString());
        try {
            assertion = JsonWebSignature.signUsingRsaSha256(this.privateKey, jsonFactory, header, payload);
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Error signing service account access token request with private key.", e);
        }
        return assertion;
    }

    @VisibleForTesting
    String createAssertionForIdToken(long currentTime, String audience, String targetAudience) throws IOException {
        JsonFactory jsonFactory = OAuth2Utils.JSON_FACTORY;
        JsonWebSignature.Header header = new JsonWebSignature.Header();
        header.setAlgorithm("RS256");
        header.setType("JWT");
        header.setKeyId(this.privateKeyId);
        JsonWebToken.Payload payload = new JsonWebToken.Payload();
        payload.setIssuer(this.getIssuer());
        payload.setIssuedAtTimeSeconds(currentTime / 1000L);
        payload.setExpirationTimeSeconds(currentTime / 1000L + (long)this.lifetime);
        payload.setSubject(this.serviceAccountUser);
        if (audience == null) {
            payload.setAudience(OAuth2Utils.TOKEN_SERVER_URI.toString());
        } else {
            payload.setAudience(audience);
        }
        try {
            payload.set("target_audience", targetAudience);
            return JsonWebSignature.signUsingRsaSha256(this.privateKey, jsonFactory, header, payload);
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Error signing service account access token request with private key.", e);
        }
    }

    @VisibleForTesting
    static URI getUriForSelfSignedJWT(URI uri) {
        if (uri == null || uri.getScheme() == null || uri.getHost() == null) {
            return uri;
        }
        try {
            return new URI(uri.getScheme(), uri.getHost(), "/", null);
        }
        catch (URISyntaxException unused) {
            return uri;
        }
    }

    @VisibleForTesting
    JwtCredentials createSelfSignedJwtCredentials(URI uri) {
        return this.createSelfSignedJwtCredentials(uri, this.scopes.isEmpty() ? this.defaultScopes : this.scopes);
    }

    @VisibleForTesting
    JwtCredentials createSelfSignedJwtCredentials(URI uri, Collection<String> scopes) {
        JwtClaims.Builder claimsBuilder = JwtClaims.newBuilder().setIssuer(this.clientEmail).setSubject(this.clientEmail);
        if (uri == null) {
            String scopeClaim = Joiner.on(' ').join(scopes);
            claimsBuilder.setAdditionalClaims(Collections.singletonMap("scope", scopeClaim));
        } else {
            claimsBuilder.setAudience(ServiceAccountCredentials.getUriForSelfSignedJWT(uri).toString());
        }
        return JwtCredentials.newBuilder().setPrivateKey(this.privateKey).setPrivateKeyId(this.privateKeyId).setJwtClaims(claimsBuilder.build()).setClock(this.clock).build();
    }

    @Override
    public void getRequestMetadata(URI uri, Executor executor, RequestMetadataCallback callback) {
        try {
            if (this.useJwtAccessWithScope || !this.isDefaultUniverseDomain()) {
                this.blockingGetToCallback(uri, callback);
            } else {
                super.getRequestMetadata(uri, executor, callback);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Map<String, List<String>> getRequestMetadata(URI uri) throws IOException {
        if (this.createScopedRequired() && uri == null) {
            throw new IOException("Scopes and uri are not configured for service account. Specify the scopes by calling createScoped or passing scopes to constructor or providing uri to getRequestMetadata.");
        }
        if (this.isDefaultUniverseDomain()) {
            return this.getRequestMetadataForGdu(uri);
        }
        return this.getRequestMetadataForNonGdu(uri);
    }

    @Override
    public CredentialTypeForMetrics getMetricsCredentialType() {
        return this.shouldUseAssertionFlowForGdu() ? CredentialTypeForMetrics.SERVICE_ACCOUNT_CREDENTIALS_AT : CredentialTypeForMetrics.SERVICE_ACCOUNT_CREDENTIALS_JWT;
    }

    boolean shouldUseAssertionFlowForGdu() {
        return !this.createScopedRequired() && !this.useJwtAccessWithScope || this.isConfiguredForDomainWideDelegation();
    }

    private Map<String, List<String>> getRequestMetadataForGdu(URI uri) throws IOException {
        return this.shouldUseAssertionFlowForGdu() ? super.getRequestMetadata(uri) : this.getRequestMetadataWithSelfSignedJwt(uri);
    }

    private Map<String, List<String>> getRequestMetadataForNonGdu(URI uri) throws IOException {
        if (this.isConfiguredForDomainWideDelegation()) {
            throw new IOException(String.format("Service Account user is configured for the credential. Domain-wide delegation is not supported in universes different than %s.", "googleapis.com"));
        }
        return this.getRequestMetadataWithSelfSignedJwt(uri);
    }

    @VisibleForTesting
    private Map<String, List<String>> getRequestMetadataWithSelfSignedJwt(URI uri) throws IOException {
        JwtCredentials jwtCredentials;
        if (!this.createScopedRequired()) {
            if (this.selfSignedJwtCredentialsWithScope == null) {
                this.selfSignedJwtCredentialsWithScope = this.createSelfSignedJwtCredentials(null);
            }
            jwtCredentials = this.selfSignedJwtCredentialsWithScope;
        } else {
            jwtCredentials = this.createSelfSignedJwtCredentials(uri);
        }
        Map<String, List<String>> requestMetadata = jwtCredentials.getRequestMetadata(null);
        return ServiceAccountCredentials.addQuotaProjectIdToRequestMetadata(this.quotaProjectId, requestMetadata);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.transportFactory = (HttpTransportFactory)ServiceAccountCredentials.newInstance(this.transportFactoryClassName);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends GoogleCredentials.Builder {
        private String clientId;
        private String clientEmail;
        private PrivateKey privateKey;
        private String privateKeyId;
        private String serviceAccountUser;
        private String projectId;
        private URI tokenServerUri;
        private Collection<String> scopes;
        private Collection<String> defaultScopes;
        private HttpTransportFactory transportFactory;
        private int lifetime = 3600;
        private boolean useJwtAccessWithScope = false;
        private boolean defaultRetriesEnabled = true;

        protected Builder() {
        }

        protected Builder(ServiceAccountCredentials credentials) {
            super(credentials);
            this.clientId = credentials.clientId;
            this.clientEmail = credentials.clientEmail;
            this.privateKey = credentials.privateKey;
            this.privateKeyId = credentials.privateKeyId;
            this.scopes = credentials.scopes;
            this.defaultScopes = credentials.defaultScopes;
            this.transportFactory = credentials.transportFactory;
            this.tokenServerUri = credentials.tokenServerUri;
            this.serviceAccountUser = credentials.serviceAccountUser;
            this.projectId = credentials.projectId;
            this.lifetime = credentials.lifetime;
            this.useJwtAccessWithScope = credentials.useJwtAccessWithScope;
            this.defaultRetriesEnabled = credentials.defaultRetriesEnabled;
        }

        @CanIgnoreReturnValue
        public Builder setClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setClientEmail(String clientEmail) {
            this.clientEmail = clientEmail;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPrivateKey(PrivateKey privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPrivateKeyString(String privateKeyPkcs8) throws IOException {
            this.privateKey = OAuth2Utils.privateKeyFromPkcs8(privateKeyPkcs8);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPrivateKeyId(String privateKeyId) {
            this.privateKeyId = privateKeyId;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setScopes(Collection<String> scopes) {
            this.scopes = scopes;
            this.defaultScopes = ImmutableSet.of();
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setScopes(Collection<String> scopes, Collection<String> defaultScopes) {
            this.scopes = scopes;
            this.defaultScopes = defaultScopes;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setServiceAccountUser(String serviceAccountUser) {
            this.serviceAccountUser = serviceAccountUser;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setTokenServerUri(URI tokenServerUri) {
            this.tokenServerUri = tokenServerUri;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setHttpTransportFactory(HttpTransportFactory transportFactory) {
            this.transportFactory = transportFactory;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setQuotaProjectId(String quotaProjectId) {
            super.setQuotaProjectId(quotaProjectId);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setLifetime(int lifetime) {
            this.lifetime = lifetime == 0 ? 3600 : lifetime;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setUseJwtAccessWithScope(boolean useJwtAccessWithScope) {
            this.useJwtAccessWithScope = useJwtAccessWithScope;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setDefaultRetriesEnabled(boolean defaultRetriesEnabled) {
            this.defaultRetriesEnabled = defaultRetriesEnabled;
            return this;
        }

        @Override
        public Builder setUniverseDomain(String universeDomain) {
            this.universeDomain = universeDomain;
            return this;
        }

        public String getClientId() {
            return this.clientId;
        }

        public String getClientEmail() {
            return this.clientEmail;
        }

        public PrivateKey getPrivateKey() {
            return this.privateKey;
        }

        public String getPrivateKeyId() {
            return this.privateKeyId;
        }

        public Collection<String> getScopes() {
            return this.scopes;
        }

        public Collection<String> getDefaultScopes() {
            return this.defaultScopes;
        }

        public String getServiceAccountUser() {
            return this.serviceAccountUser;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public URI getTokenServerUri() {
            return this.tokenServerUri;
        }

        public HttpTransportFactory getHttpTransportFactory() {
            return this.transportFactory;
        }

        public int getLifetime() {
            return this.lifetime;
        }

        public boolean getUseJwtAccessWithScope() {
            return this.useJwtAccessWithScope;
        }

        public boolean isDefaultRetriesEnabled() {
            return this.defaultRetriesEnabled;
        }

        @Override
        public ServiceAccountCredentials build() {
            return new ServiceAccountCredentials(this);
        }
    }
}

