/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2;

import com.google.bigtable.repackaged.com.google.api.core.ApiAsyncFunction;
import com.google.bigtable.repackaged.com.google.api.core.ApiFunction;
import com.google.bigtable.repackaged.com.google.api.core.ApiFuture;
import com.google.bigtable.repackaged.com.google.api.core.ApiFutures;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiExceptions;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.NotFoundException;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Cluster;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.DeleteAppProfileRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.DeleteClusterRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.DeleteInstanceRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.DeleteLogicalViewRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.DeleteMaterializedViewRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.GetAppProfileRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.GetClusterRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.GetInstanceRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.GetLogicalViewRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.GetMaterializedViewRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ListAppProfilesRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ListClustersRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ListClustersResponse;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ListInstancesRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ListInstancesResponse;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ListLogicalViewsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ListMaterializedViewsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.PartialUpdateClusterRequest;
import com.google.bigtable.repackaged.com.google.cloud.Policy;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.BaseBigtableInstanceAdminClient;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.BigtableInstanceAdminSettings;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.AppProfile;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.Cluster;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.ClusterAutoscalingConfig;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.CreateAppProfileRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.CreateClusterRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.CreateInstanceRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.CreateLogicalViewRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.CreateMaterializedViewRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.Instance;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.LogicalView;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.MaterializedView;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.PartialListClustersException;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.PartialListInstancesException;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.UpdateAppProfileRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.UpdateInstanceRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.UpdateLogicalViewRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.UpdateMaterializedViewRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.stub.BigtableInstanceAdminStub;
import com.google.bigtable.repackaged.com.google.common.base.Verify;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.common.collect.Lists;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.bigtable.repackaged.com.google.iam.v1.GetIamPolicyRequest;
import com.google.bigtable.repackaged.com.google.iam.v1.SetIamPolicyRequest;
import com.google.bigtable.repackaged.com.google.iam.v1.TestIamPermissionsRequest;
import com.google.bigtable.repackaged.com.google.iam.v1.TestIamPermissionsResponse;
import com.google.bigtable.repackaged.com.google.protobuf.Empty;
import com.google.bigtable.repackaged.com.google.protobuf.util.FieldMaskUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;

public final class BigtableInstanceAdminClient
implements AutoCloseable {
    private final String projectId;
    private final BigtableInstanceAdminStub stub;

    public static BigtableInstanceAdminClient create(@Nonnull String projectId) throws IOException {
        return BigtableInstanceAdminClient.create(BigtableInstanceAdminSettings.newBuilder().setProjectId(projectId).build());
    }

    public static BigtableInstanceAdminClient create(@Nonnull BigtableInstanceAdminSettings settings) throws IOException {
        return BigtableInstanceAdminClient.create(settings.getProjectId(), settings.getStubSettings().createStub());
    }

    public static BigtableInstanceAdminClient create(@Nonnull String projectId, @Nonnull BigtableInstanceAdminStub stub) {
        return new BigtableInstanceAdminClient(projectId, stub);
    }

    private BigtableInstanceAdminClient(@Nonnull String projectId, @Nonnull BigtableInstanceAdminStub stub) {
        this.projectId = projectId;
        this.stub = stub;
    }

    public String getProjectId() {
        return this.projectId;
    }

    @Override
    public void close() {
        this.stub.close();
    }

    public Instance createInstance(CreateInstanceRequest request) {
        return ApiExceptions.callAndTranslateApiException(this.createInstanceAsync(request));
    }

    public ApiFuture<Instance> createInstanceAsync(CreateInstanceRequest request) {
        return ApiFutures.transform(this.stub.createInstanceOperationCallable().futureCall(request.toProto(this.projectId)), new ApiFunction<com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Instance, Instance>(){

            @Override
            public Instance apply(com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Instance proto) {
                return Instance.fromProto(proto);
            }
        }, MoreExecutors.directExecutor());
    }

    public Instance updateInstance(UpdateInstanceRequest request) {
        return ApiExceptions.callAndTranslateApiException(this.updateInstanceAsync(request));
    }

    public ApiFuture<Instance> updateInstanceAsync(UpdateInstanceRequest request) {
        return ApiFutures.transform(this.stub.partialUpdateInstanceOperationCallable().futureCall(request.toProto(this.projectId)), new ApiFunction<com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Instance, Instance>(){

            @Override
            public Instance apply(com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Instance proto) {
                return Instance.fromProto(proto);
            }
        }, MoreExecutors.directExecutor());
    }

    public Instance getInstance(String id) {
        return ApiExceptions.callAndTranslateApiException(this.getInstanceAsync(id));
    }

    public ApiFuture<Instance> getInstanceAsync(String instanceId) {
        String name = NameUtil.formatInstanceName(this.projectId, instanceId);
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setName(name).build();
        return ApiFutures.transform(this.stub.getInstanceCallable().futureCall(request), new ApiFunction<com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Instance, Instance>(){

            @Override
            public Instance apply(com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Instance proto) {
                return Instance.fromProto(proto);
            }
        }, MoreExecutors.directExecutor());
    }

    public List<Instance> listInstances() {
        return ApiExceptions.callAndTranslateApiException(this.listInstancesAsync());
    }

    public ApiFuture<List<Instance>> listInstancesAsync() {
        ListInstancesRequest request = ListInstancesRequest.newBuilder().setParent(NameUtil.formatProjectName(this.projectId)).build();
        ApiFuture<ListInstancesResponse> responseFuture = this.stub.listInstancesCallable().futureCall(request);
        return ApiFutures.transform(responseFuture, new ApiFunction<ListInstancesResponse, List<Instance>>(){

            @Override
            public List<Instance> apply(ListInstancesResponse proto) {
                Verify.verify(proto.getNextPageToken().isEmpty(), "Server returned an unexpected paginated response", new Object[0]);
                ImmutableList.Builder instances = ImmutableList.builder();
                for (com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Instance protoInstance : proto.getInstancesList()) {
                    instances.add(Instance.fromProto(protoInstance));
                }
                ImmutableList.Builder failedZones = ImmutableList.builder();
                for (String locationStr : proto.getFailedLocationsList()) {
                    failedZones.add(NameUtil.extractZoneIdFromLocationName(locationStr));
                }
                if (!failedZones.build().isEmpty()) {
                    throw new PartialListInstancesException((List<String>)((Object)failedZones.build()), (List<Instance>)((Object)instances.build()));
                }
                return instances.build();
            }
        }, MoreExecutors.directExecutor());
    }

    public void deleteInstance(String instanceId) {
        ApiExceptions.callAndTranslateApiException(this.deleteInstanceAsync(instanceId));
    }

    public ApiFuture<Void> deleteInstanceAsync(String instanceId) {
        String instanceName = NameUtil.formatInstanceName(this.projectId, instanceId);
        DeleteInstanceRequest request = DeleteInstanceRequest.newBuilder().setName(instanceName).build();
        return ApiFutures.transform(this.stub.deleteInstanceCallable().futureCall(request), new ApiFunction<Empty, Void>(){

            @Override
            public Void apply(Empty input) {
                return null;
            }
        }, MoreExecutors.directExecutor());
    }

    public boolean exists(String instanceId) {
        return ApiExceptions.callAndTranslateApiException(this.existsAsync(instanceId));
    }

    public ApiFuture<Boolean> existsAsync(String instanceId) {
        ApiFuture<Instance> protoFuture = this.getInstanceAsync(instanceId);
        ApiFuture<Boolean> existsFuture = ApiFutures.transform(protoFuture, new ApiFunction<Instance, Boolean>(){

            @Override
            public Boolean apply(Instance ignored) {
                return true;
            }
        }, MoreExecutors.directExecutor());
        return ApiFutures.catching(existsFuture, NotFoundException.class, new ApiFunction<NotFoundException, Boolean>(){

            @Override
            public Boolean apply(NotFoundException ignored) {
                return false;
            }
        }, MoreExecutors.directExecutor());
    }

    public Cluster createCluster(CreateClusterRequest request) {
        return ApiExceptions.callAndTranslateApiException(this.createClusterAsync(request));
    }

    public ApiFuture<Cluster> createClusterAsync(CreateClusterRequest request) {
        return ApiFutures.transform(this.stub.createClusterOperationCallable().futureCall(request.toProto(this.projectId)), Cluster::fromProto, MoreExecutors.directExecutor());
    }

    public Cluster getCluster(String instanceId, String clusterId) {
        return ApiExceptions.callAndTranslateApiException(this.getClusterAsync(instanceId, clusterId));
    }

    public ApiFuture<Cluster> getClusterAsync(String instanceId, String clusterId) {
        String name = NameUtil.formatClusterName(this.projectId, instanceId, clusterId);
        GetClusterRequest request = GetClusterRequest.newBuilder().setName(name).build();
        return ApiFutures.transform(this.stub.getClusterCallable().futureCall(request), new ApiFunction<com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Cluster, Cluster>(){

            @Override
            public Cluster apply(com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Cluster proto) {
                return Cluster.fromProto(proto);
            }
        }, MoreExecutors.directExecutor());
    }

    public List<Cluster> listClusters(String instanceId) {
        return ApiExceptions.callAndTranslateApiException(this.listClustersAsync(instanceId));
    }

    public ApiFuture<List<Cluster>> listClustersAsync(String instanceId) {
        String name = NameUtil.formatInstanceName(this.projectId, instanceId);
        ListClustersRequest request = ListClustersRequest.newBuilder().setParent(name).build();
        return ApiFutures.transform(this.stub.listClustersCallable().futureCall(request), new ApiFunction<ListClustersResponse, List<Cluster>>(){

            @Override
            public List<Cluster> apply(ListClustersResponse proto) {
                Verify.verify(proto.getNextPageToken().isEmpty(), "Server returned an unexpected paginated response", new Object[0]);
                ImmutableList.Builder clusters = ImmutableList.builder();
                for (com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Cluster cluster : proto.getClustersList()) {
                    clusters.add(Cluster.fromProto(cluster));
                }
                ImmutableList.Builder failedZones = ImmutableList.builder();
                for (String locationStr : proto.getFailedLocationsList()) {
                    failedZones.add(NameUtil.extractZoneIdFromLocationName(locationStr));
                }
                if (!failedZones.build().isEmpty()) {
                    throw new PartialListClustersException((List<String>)((Object)failedZones.build()), (List<Cluster>)((Object)clusters.build()));
                }
                return clusters.build();
            }
        }, MoreExecutors.directExecutor());
    }

    public Cluster resizeCluster(String instanceId, String clusterId, int numServeNodes) {
        return ApiExceptions.callAndTranslateApiException(this.resizeClusterAsync(instanceId, clusterId, numServeNodes));
    }

    public ApiFuture<Cluster> resizeClusterAsync(String instanceId, String clusterId, int numServeNodes) {
        String name = NameUtil.formatClusterName(this.projectId, instanceId, clusterId);
        com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Cluster request = com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Cluster.newBuilder().setName(name).setServeNodes(numServeNodes).build();
        return ApiFutures.transform(this.stub.updateClusterOperationCallable().futureCall(request), new ApiFunction<com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Cluster, Cluster>(){

            @Override
            public Cluster apply(com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Cluster proto) {
                return Cluster.fromProto(proto);
            }
        }, MoreExecutors.directExecutor());
    }

    public Cluster updateClusterAutoscalingConfig(@Nonnull ClusterAutoscalingConfig clusterAutoscalingConfig) {
        return ApiExceptions.callAndTranslateApiException(this.updateClusterAutoscalingConfigAsync(clusterAutoscalingConfig));
    }

    public ApiFuture<Cluster> updateClusterAutoscalingConfigAsync(@Nonnull ClusterAutoscalingConfig clusterAutoscalingConfig) {
        PartialUpdateClusterRequest proto = clusterAutoscalingConfig.toProto(this.projectId);
        return ApiFutures.transform(this.stub.partialUpdateClusterOperationCallable().futureCall(proto), Cluster::fromProto, MoreExecutors.directExecutor());
    }

    public Cluster disableClusterAutoscaling(String instanceId, String clusterId, int staticSize) {
        return ApiExceptions.callAndTranslateApiException(this.disableClusterAutoscalingAsync(instanceId, clusterId, staticSize));
    }

    public ApiFuture<Cluster> disableClusterAutoscalingAsync(String instanceId, String clusterId, int staticSize) {
        String name = NameUtil.formatClusterName(this.projectId, instanceId, clusterId);
        com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Cluster request = com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Cluster.newBuilder().setName(name).setServeNodes(staticSize).setClusterConfig(Cluster.ClusterConfig.getDefaultInstance()).build();
        PartialUpdateClusterRequest partialUpdateClusterRequest = PartialUpdateClusterRequest.newBuilder().setUpdateMask(FieldMaskUtil.fromStringList(com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Cluster.class, Lists.newArrayList("cluster_config.cluster_autoscaling_config", "serve_nodes"))).setCluster(request).build();
        return ApiFutures.transform(this.stub.partialUpdateClusterOperationCallable().futureCall(partialUpdateClusterRequest), Cluster::fromProto, MoreExecutors.directExecutor());
    }

    public void deleteCluster(String instanceId, String clusterId) {
        ApiExceptions.callAndTranslateApiException(this.deleteClusterAsync(instanceId, clusterId));
    }

    public ApiFuture<Void> deleteClusterAsync(String instanceId, String clusterId) {
        String name = NameUtil.formatClusterName(this.projectId, instanceId, clusterId);
        DeleteClusterRequest request = DeleteClusterRequest.newBuilder().setName(name).build();
        return ApiFutures.transform(this.stub.deleteClusterCallable().futureCall(request), new ApiFunction<Empty, Void>(){

            @Override
            public Void apply(Empty input) {
                return null;
            }
        }, MoreExecutors.directExecutor());
    }

    public AppProfile createAppProfile(CreateAppProfileRequest request) {
        return ApiExceptions.callAndTranslateApiException(this.createAppProfileAsync(request));
    }

    public ApiFuture<AppProfile> createAppProfileAsync(CreateAppProfileRequest request) {
        return ApiFutures.transform(this.stub.createAppProfileCallable().futureCall(request.toProto(this.projectId)), new ApiFunction<com.google.bigtable.repackaged.com.google.bigtable.admin.v2.AppProfile, AppProfile>(){

            @Override
            public AppProfile apply(com.google.bigtable.repackaged.com.google.bigtable.admin.v2.AppProfile proto) {
                return AppProfile.fromProto(proto);
            }
        }, MoreExecutors.directExecutor());
    }

    public AppProfile getAppProfile(String instanceId, String appProfileId) {
        return ApiExceptions.callAndTranslateApiException(this.getAppProfileAsync(instanceId, appProfileId));
    }

    public ApiFuture<AppProfile> getAppProfileAsync(String instanceId, String appProfileId) {
        String name = NameUtil.formatAppProfileName(this.projectId, instanceId, appProfileId);
        GetAppProfileRequest request = GetAppProfileRequest.newBuilder().setName(name).build();
        return ApiFutures.transform(this.stub.getAppProfileCallable().futureCall(request), new ApiFunction<com.google.bigtable.repackaged.com.google.bigtable.admin.v2.AppProfile, AppProfile>(){

            @Override
            public AppProfile apply(com.google.bigtable.repackaged.com.google.bigtable.admin.v2.AppProfile proto) {
                return AppProfile.fromProto(proto);
            }
        }, MoreExecutors.directExecutor());
    }

    public List<AppProfile> listAppProfiles(String instanceId) {
        return ApiExceptions.callAndTranslateApiException(this.listAppProfilesAsync(instanceId));
    }

    public ApiFuture<List<AppProfile>> listAppProfilesAsync(String instanceId) {
        String instanceName = NameUtil.formatInstanceName(this.projectId, instanceId);
        ListAppProfilesRequest request = ListAppProfilesRequest.newBuilder().setParent(instanceName).build();
        ApiFuture<BaseBigtableInstanceAdminClient.ListAppProfilesPage> firstPageFuture = ApiFutures.transform(this.stub.listAppProfilesPagedCallable().futureCall(request), new ApiFunction<BaseBigtableInstanceAdminClient.ListAppProfilesPagedResponse, BaseBigtableInstanceAdminClient.ListAppProfilesPage>(){

            @Override
            public BaseBigtableInstanceAdminClient.ListAppProfilesPage apply(BaseBigtableInstanceAdminClient.ListAppProfilesPagedResponse response) {
                return (BaseBigtableInstanceAdminClient.ListAppProfilesPage)response.getPage();
            }
        }, MoreExecutors.directExecutor());
        ApiFuture<List<com.google.bigtable.repackaged.com.google.bigtable.admin.v2.AppProfile>> allProtos = ApiFutures.transformAsync(firstPageFuture, new ApiAsyncFunction<BaseBigtableInstanceAdminClient.ListAppProfilesPage, List<com.google.bigtable.repackaged.com.google.bigtable.admin.v2.AppProfile>>(){
            List<com.google.bigtable.repackaged.com.google.bigtable.admin.v2.AppProfile> responseAccumulator = Lists.newArrayList();

            @Override
            public ApiFuture<List<com.google.bigtable.repackaged.com.google.bigtable.admin.v2.AppProfile>> apply(BaseBigtableInstanceAdminClient.ListAppProfilesPage page) {
                this.responseAccumulator.addAll(Lists.newArrayList(page.getValues()));
                if (!page.hasNextPage()) {
                    return ApiFutures.immediateFuture(this.responseAccumulator);
                }
                return ApiFutures.transformAsync(page.getNextPageAsync(), this, MoreExecutors.directExecutor());
            }
        }, MoreExecutors.directExecutor());
        return ApiFutures.transform(allProtos, new ApiFunction<List<com.google.bigtable.repackaged.com.google.bigtable.admin.v2.AppProfile>, List<AppProfile>>(){

            @Override
            public List<AppProfile> apply(List<com.google.bigtable.repackaged.com.google.bigtable.admin.v2.AppProfile> input) {
                ArrayList<AppProfile> results = Lists.newArrayListWithCapacity(input.size());
                for (com.google.bigtable.repackaged.com.google.bigtable.admin.v2.AppProfile appProfile : input) {
                    results.add(AppProfile.fromProto(appProfile));
                }
                return results;
            }
        }, MoreExecutors.directExecutor());
    }

    public AppProfile updateAppProfile(UpdateAppProfileRequest request) {
        return ApiExceptions.callAndTranslateApiException(this.updateAppProfileAsync(request));
    }

    public ApiFuture<AppProfile> updateAppProfileAsync(UpdateAppProfileRequest request) {
        return ApiFutures.transform(this.stub.updateAppProfileOperationCallable().futureCall(request.toProto(this.projectId)), new ApiFunction<com.google.bigtable.repackaged.com.google.bigtable.admin.v2.AppProfile, AppProfile>(){

            @Override
            public AppProfile apply(com.google.bigtable.repackaged.com.google.bigtable.admin.v2.AppProfile proto) {
                return AppProfile.fromProto(proto);
            }
        }, MoreExecutors.directExecutor());
    }

    public void deleteAppProfile(String instanceId, String appProfileId) {
        ApiExceptions.callAndTranslateApiException(this.deleteAppProfileAsync(instanceId, appProfileId, false));
    }

    public ApiFuture<Void> deleteAppProfileAsync(String instanceId, String appProfileId) {
        return this.deleteAppProfileAsync(instanceId, appProfileId, false);
    }

    public void deleteAppProfile(String instanceId, String appProfileId, boolean forceDelete) {
        ApiExceptions.callAndTranslateApiException(this.deleteAppProfileAsync(instanceId, appProfileId, forceDelete));
    }

    public ApiFuture<Void> deleteAppProfileAsync(String instanceId, String appProfileId, boolean forceDelete) {
        String name = NameUtil.formatAppProfileName(this.projectId, instanceId, appProfileId);
        DeleteAppProfileRequest request = DeleteAppProfileRequest.newBuilder().setName(name).setIgnoreWarnings(forceDelete).build();
        return ApiFutures.transform(this.stub.deleteAppProfileCallable().futureCall(request), new ApiFunction<Empty, Void>(){

            @Override
            public Void apply(Empty input) {
                return null;
            }
        }, MoreExecutors.directExecutor());
    }

    public Policy getIamPolicy(String instanceId) {
        return ApiExceptions.callAndTranslateApiException(this.getIamPolicyAsync(instanceId));
    }

    public ApiFuture<Policy> getIamPolicyAsync(String instanceId) {
        String name = NameUtil.formatInstanceName(this.projectId, instanceId);
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(name).build();
        final IamPolicyMarshaller marshaller = new IamPolicyMarshaller();
        return ApiFutures.transform(this.stub.getIamPolicyCallable().futureCall(request), new ApiFunction<com.google.bigtable.repackaged.com.google.iam.v1.Policy, Policy>(){

            @Override
            public Policy apply(com.google.bigtable.repackaged.com.google.iam.v1.Policy proto) {
                return marshaller.fromPb(proto);
            }
        }, MoreExecutors.directExecutor());
    }

    public Policy setIamPolicy(String instanceId, Policy policy) {
        return ApiExceptions.callAndTranslateApiException(this.setIamPolicyAsync(instanceId, policy));
    }

    public ApiFuture<Policy> setIamPolicyAsync(String instanceId, Policy policy) {
        String name = NameUtil.formatInstanceName(this.projectId, instanceId);
        final IamPolicyMarshaller marshaller = new IamPolicyMarshaller();
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(name).setPolicy(marshaller.toPb(policy)).build();
        return ApiFutures.transform(this.stub.setIamPolicyCallable().futureCall(request), new ApiFunction<com.google.bigtable.repackaged.com.google.iam.v1.Policy, Policy>(){

            @Override
            public Policy apply(com.google.bigtable.repackaged.com.google.iam.v1.Policy proto) {
                return marshaller.fromPb(proto);
            }
        }, MoreExecutors.directExecutor());
    }

    public List<String> testIamPermission(String instanceId, String ... permissions) {
        return ApiExceptions.callAndTranslateApiException(this.testIamPermissionAsync(instanceId, permissions));
    }

    public ApiFuture<List<String>> testIamPermissionAsync(String instanceId, String ... permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(NameUtil.formatInstanceName(this.projectId, instanceId)).addAllPermissions(Arrays.asList(permissions)).build();
        return ApiFutures.transform(this.stub.testIamPermissionsCallable().futureCall(request), new ApiFunction<TestIamPermissionsResponse, List<String>>(){

            @Override
            public List<String> apply(TestIamPermissionsResponse input) {
                return input.getPermissionsList();
            }
        }, MoreExecutors.directExecutor());
    }

    public MaterializedView createMaterializedView(CreateMaterializedViewRequest request) {
        return ApiExceptions.callAndTranslateApiException(this.createMaterializedViewAsync(request));
    }

    public ApiFuture<MaterializedView> createMaterializedViewAsync(CreateMaterializedViewRequest request) {
        return ApiFutures.transform(this.stub.createMaterializedViewOperationCallable().futureCall(request.toProto(this.projectId)), new ApiFunction<com.google.bigtable.repackaged.com.google.bigtable.admin.v2.MaterializedView, MaterializedView>(){

            @Override
            public MaterializedView apply(com.google.bigtable.repackaged.com.google.bigtable.admin.v2.MaterializedView proto) {
                return MaterializedView.fromProto(proto);
            }
        }, MoreExecutors.directExecutor());
    }

    public MaterializedView getMaterializedView(String instanceId, String materializedViewId) {
        return ApiExceptions.callAndTranslateApiException(this.getMaterializedViewAsync(instanceId, materializedViewId));
    }

    public ApiFuture<MaterializedView> getMaterializedViewAsync(String instanceId, String materializedViewId) {
        String name = NameUtil.formatMaterializedViewName(this.projectId, instanceId, materializedViewId);
        GetMaterializedViewRequest request = GetMaterializedViewRequest.newBuilder().setName(name).build();
        return ApiFutures.transform(this.stub.getMaterializedViewCallable().futureCall(request), new ApiFunction<com.google.bigtable.repackaged.com.google.bigtable.admin.v2.MaterializedView, MaterializedView>(){

            @Override
            public MaterializedView apply(com.google.bigtable.repackaged.com.google.bigtable.admin.v2.MaterializedView proto) {
                return MaterializedView.fromProto(proto);
            }
        }, MoreExecutors.directExecutor());
    }

    public List<MaterializedView> listMaterializedViews(String instanceId) {
        return ApiExceptions.callAndTranslateApiException(this.listMaterializedViewsAsync(instanceId));
    }

    public ApiFuture<List<MaterializedView>> listMaterializedViewsAsync(String instanceId) {
        String instanceName = NameUtil.formatInstanceName(this.projectId, instanceId);
        ListMaterializedViewsRequest request = ListMaterializedViewsRequest.newBuilder().setParent(instanceName).build();
        ApiFuture<BaseBigtableInstanceAdminClient.ListMaterializedViewsPage> firstPageFuture = ApiFutures.transform(this.stub.listMaterializedViewsPagedCallable().futureCall(request), new ApiFunction<BaseBigtableInstanceAdminClient.ListMaterializedViewsPagedResponse, BaseBigtableInstanceAdminClient.ListMaterializedViewsPage>(){

            @Override
            public BaseBigtableInstanceAdminClient.ListMaterializedViewsPage apply(BaseBigtableInstanceAdminClient.ListMaterializedViewsPagedResponse response) {
                return (BaseBigtableInstanceAdminClient.ListMaterializedViewsPage)response.getPage();
            }
        }, MoreExecutors.directExecutor());
        ApiFuture<List<com.google.bigtable.repackaged.com.google.bigtable.admin.v2.MaterializedView>> allProtos = ApiFutures.transformAsync(firstPageFuture, new ApiAsyncFunction<BaseBigtableInstanceAdminClient.ListMaterializedViewsPage, List<com.google.bigtable.repackaged.com.google.bigtable.admin.v2.MaterializedView>>(){
            List<com.google.bigtable.repackaged.com.google.bigtable.admin.v2.MaterializedView> responseAccumulator = Lists.newArrayList();

            @Override
            public ApiFuture<List<com.google.bigtable.repackaged.com.google.bigtable.admin.v2.MaterializedView>> apply(BaseBigtableInstanceAdminClient.ListMaterializedViewsPage page) {
                this.responseAccumulator.addAll(Lists.newArrayList(page.getValues()));
                if (!page.hasNextPage()) {
                    return ApiFutures.immediateFuture(this.responseAccumulator);
                }
                return ApiFutures.transformAsync(page.getNextPageAsync(), this, MoreExecutors.directExecutor());
            }
        }, MoreExecutors.directExecutor());
        return ApiFutures.transform(allProtos, new ApiFunction<List<com.google.bigtable.repackaged.com.google.bigtable.admin.v2.MaterializedView>, List<MaterializedView>>(){

            @Override
            public List<MaterializedView> apply(List<com.google.bigtable.repackaged.com.google.bigtable.admin.v2.MaterializedView> input) {
                ArrayList<MaterializedView> results = Lists.newArrayListWithCapacity(input.size());
                for (com.google.bigtable.repackaged.com.google.bigtable.admin.v2.MaterializedView materializedView : input) {
                    results.add(MaterializedView.fromProto(materializedView));
                }
                return results;
            }
        }, MoreExecutors.directExecutor());
    }

    public MaterializedView updateMaterializedView(UpdateMaterializedViewRequest request) {
        return ApiExceptions.callAndTranslateApiException(this.updateMaterializedViewAsync(request));
    }

    public ApiFuture<MaterializedView> updateMaterializedViewAsync(UpdateMaterializedViewRequest request) {
        return ApiFutures.transform(this.stub.updateMaterializedViewOperationCallable().futureCall(request.toProto(this.projectId)), new ApiFunction<com.google.bigtable.repackaged.com.google.bigtable.admin.v2.MaterializedView, MaterializedView>(){

            @Override
            public MaterializedView apply(com.google.bigtable.repackaged.com.google.bigtable.admin.v2.MaterializedView proto) {
                return MaterializedView.fromProto(proto);
            }
        }, MoreExecutors.directExecutor());
    }

    public void deleteMaterializedView(String instanceId, String materializedViewId) {
        ApiExceptions.callAndTranslateApiException(this.deleteMaterializedViewAsync(instanceId, materializedViewId));
    }

    public ApiFuture<Void> deleteMaterializedViewAsync(String instanceId, String materializedViewId) {
        String name = NameUtil.formatMaterializedViewName(this.projectId, instanceId, materializedViewId);
        DeleteMaterializedViewRequest request = DeleteMaterializedViewRequest.newBuilder().setName(name).build();
        return ApiFutures.transform(this.stub.deleteMaterializedViewCallable().futureCall(request), new ApiFunction<Empty, Void>(){

            @Override
            public Void apply(Empty input) {
                return null;
            }
        }, MoreExecutors.directExecutor());
    }

    public LogicalView createLogicalView(CreateLogicalViewRequest request) {
        return ApiExceptions.callAndTranslateApiException(this.createLogicalViewAsync(request));
    }

    public ApiFuture<LogicalView> createLogicalViewAsync(CreateLogicalViewRequest request) {
        return ApiFutures.transform(this.stub.createLogicalViewOperationCallable().futureCall(request.toProto(this.projectId)), new ApiFunction<com.google.bigtable.repackaged.com.google.bigtable.admin.v2.LogicalView, LogicalView>(){

            @Override
            public LogicalView apply(com.google.bigtable.repackaged.com.google.bigtable.admin.v2.LogicalView proto) {
                return LogicalView.fromProto(proto);
            }
        }, MoreExecutors.directExecutor());
    }

    public LogicalView getLogicalView(String instanceId, String logicalViewId) {
        return ApiExceptions.callAndTranslateApiException(this.getLogicalViewAsync(instanceId, logicalViewId));
    }

    public ApiFuture<LogicalView> getLogicalViewAsync(String instanceId, String logicalViewId) {
        String name = NameUtil.formatLogicalViewName(this.projectId, instanceId, logicalViewId);
        GetLogicalViewRequest request = GetLogicalViewRequest.newBuilder().setName(name).build();
        return ApiFutures.transform(this.stub.getLogicalViewCallable().futureCall(request), new ApiFunction<com.google.bigtable.repackaged.com.google.bigtable.admin.v2.LogicalView, LogicalView>(){

            @Override
            public LogicalView apply(com.google.bigtable.repackaged.com.google.bigtable.admin.v2.LogicalView proto) {
                return LogicalView.fromProto(proto);
            }
        }, MoreExecutors.directExecutor());
    }

    public List<LogicalView> listLogicalViews(String instanceId) {
        return ApiExceptions.callAndTranslateApiException(this.listLogicalViewsAsync(instanceId));
    }

    public ApiFuture<List<LogicalView>> listLogicalViewsAsync(String instanceId) {
        String instanceName = NameUtil.formatInstanceName(this.projectId, instanceId);
        ListLogicalViewsRequest request = ListLogicalViewsRequest.newBuilder().setParent(instanceName).build();
        ApiFuture<BaseBigtableInstanceAdminClient.ListLogicalViewsPage> firstPageFuture = ApiFutures.transform(this.stub.listLogicalViewsPagedCallable().futureCall(request), new ApiFunction<BaseBigtableInstanceAdminClient.ListLogicalViewsPagedResponse, BaseBigtableInstanceAdminClient.ListLogicalViewsPage>(){

            @Override
            public BaseBigtableInstanceAdminClient.ListLogicalViewsPage apply(BaseBigtableInstanceAdminClient.ListLogicalViewsPagedResponse response) {
                return (BaseBigtableInstanceAdminClient.ListLogicalViewsPage)response.getPage();
            }
        }, MoreExecutors.directExecutor());
        ApiFuture<List<com.google.bigtable.repackaged.com.google.bigtable.admin.v2.LogicalView>> allProtos = ApiFutures.transformAsync(firstPageFuture, new ApiAsyncFunction<BaseBigtableInstanceAdminClient.ListLogicalViewsPage, List<com.google.bigtable.repackaged.com.google.bigtable.admin.v2.LogicalView>>(){
            List<com.google.bigtable.repackaged.com.google.bigtable.admin.v2.LogicalView> responseAccumulator = Lists.newArrayList();

            @Override
            public ApiFuture<List<com.google.bigtable.repackaged.com.google.bigtable.admin.v2.LogicalView>> apply(BaseBigtableInstanceAdminClient.ListLogicalViewsPage page) {
                this.responseAccumulator.addAll(Lists.newArrayList(page.getValues()));
                if (!page.hasNextPage()) {
                    return ApiFutures.immediateFuture(this.responseAccumulator);
                }
                return ApiFutures.transformAsync(page.getNextPageAsync(), this, MoreExecutors.directExecutor());
            }
        }, MoreExecutors.directExecutor());
        return ApiFutures.transform(allProtos, new ApiFunction<List<com.google.bigtable.repackaged.com.google.bigtable.admin.v2.LogicalView>, List<LogicalView>>(){

            @Override
            public List<LogicalView> apply(List<com.google.bigtable.repackaged.com.google.bigtable.admin.v2.LogicalView> input) {
                ArrayList<LogicalView> results = Lists.newArrayListWithCapacity(input.size());
                for (com.google.bigtable.repackaged.com.google.bigtable.admin.v2.LogicalView logicalView : input) {
                    results.add(LogicalView.fromProto(logicalView));
                }
                return results;
            }
        }, MoreExecutors.directExecutor());
    }

    public LogicalView updateLogicalView(UpdateLogicalViewRequest request) {
        return ApiExceptions.callAndTranslateApiException(this.updateLogicalViewAsync(request));
    }

    public ApiFuture<LogicalView> updateLogicalViewAsync(UpdateLogicalViewRequest request) {
        return ApiFutures.transform(this.stub.updateLogicalViewOperationCallable().futureCall(request.toProto(this.projectId)), new ApiFunction<com.google.bigtable.repackaged.com.google.bigtable.admin.v2.LogicalView, LogicalView>(){

            @Override
            public LogicalView apply(com.google.bigtable.repackaged.com.google.bigtable.admin.v2.LogicalView proto) {
                return LogicalView.fromProto(proto);
            }
        }, MoreExecutors.directExecutor());
    }

    public void deleteLogicalView(String instanceId, String logicalViewId) {
        ApiExceptions.callAndTranslateApiException(this.deleteLogicalViewAsync(instanceId, logicalViewId));
    }

    public ApiFuture<Void> deleteLogicalViewAsync(String instanceId, String logicalViewId) {
        String name = NameUtil.formatLogicalViewName(this.projectId, instanceId, logicalViewId);
        DeleteLogicalViewRequest request = DeleteLogicalViewRequest.newBuilder().setName(name).build();
        return ApiFutures.transform(this.stub.deleteLogicalViewCallable().futureCall(request), new ApiFunction<Empty, Void>(){

            @Override
            public Void apply(Empty input) {
                return null;
            }
        }, MoreExecutors.directExecutor());
    }

    private static class IamPolicyMarshaller
    extends Policy.DefaultMarshaller {
        private IamPolicyMarshaller() {
        }

        @Override
        public Policy fromPb(com.google.bigtable.repackaged.com.google.iam.v1.Policy policyPb) {
            return super.fromPb(policyPb);
        }

        @Override
        public com.google.bigtable.repackaged.com.google.iam.v1.Policy toPb(Policy policy) {
            return super.toPb(policy);
        }
    }
}

