/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.LogicalViewName;
import com.google.bigtable.repackaged.com.google.common.base.Objects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Verify;
import javax.annotation.Nonnull;

public final class LogicalView {
    private final com.google.bigtable.repackaged.com.google.bigtable.admin.v2.LogicalView proto;

    @InternalApi
    public static LogicalView fromProto(@Nonnull com.google.bigtable.repackaged.com.google.bigtable.admin.v2.LogicalView proto) {
        return new LogicalView(proto);
    }

    private LogicalView(@Nonnull com.google.bigtable.repackaged.com.google.bigtable.admin.v2.LogicalView proto) {
        Preconditions.checkNotNull(proto);
        Preconditions.checkArgument(!proto.getName().isEmpty(), "LogicalView must have a name");
        this.proto = proto;
    }

    public String getId() {
        LogicalViewName fullName = LogicalViewName.parse(this.proto.getName());
        return fullName.getLogicalView();
    }

    public String getInstanceId() {
        LogicalViewName fullName = Verify.verifyNotNull(LogicalViewName.parse(this.proto.getName()), "Name can never be null", new Object[0]);
        return fullName.getInstance();
    }

    public String getQuery() {
        return this.proto.getQuery();
    }

    @InternalApi
    public com.google.bigtable.repackaged.com.google.bigtable.admin.v2.LogicalView toProto() {
        return this.proto;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogicalView that = (LogicalView)o;
        return Objects.equal(this.proto, that.proto);
    }

    public int hashCode() {
        return Objects.hashCode(this.proto);
    }
}

