/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.MaterializedViewName;
import com.google.bigtable.repackaged.com.google.common.base.Objects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Verify;
import javax.annotation.Nonnull;

public final class MaterializedView {
    private final com.google.bigtable.repackaged.com.google.bigtable.admin.v2.MaterializedView proto;

    @InternalApi
    public static MaterializedView fromProto(@Nonnull com.google.bigtable.repackaged.com.google.bigtable.admin.v2.MaterializedView proto) {
        return new MaterializedView(proto);
    }

    private MaterializedView(@Nonnull com.google.bigtable.repackaged.com.google.bigtable.admin.v2.MaterializedView proto) {
        Preconditions.checkNotNull(proto);
        Preconditions.checkArgument(!proto.getName().isEmpty(), "MaterializedView must have a name");
        this.proto = proto;
    }

    public String getId() {
        MaterializedViewName fullName = MaterializedViewName.parse(this.proto.getName());
        return fullName.getMaterializedView();
    }

    public String getInstanceId() {
        MaterializedViewName fullName = Verify.verifyNotNull(MaterializedViewName.parse(this.proto.getName()), "Name can never be null", new Object[0]);
        return fullName.getInstance();
    }

    public boolean isDeletionProtected() {
        return this.proto.getDeletionProtection();
    }

    public String getQuery() {
        return this.proto.getQuery();
    }

    @InternalApi
    public com.google.bigtable.repackaged.com.google.bigtable.admin.v2.MaterializedView toProto() {
        return this.proto;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaterializedView that = (MaterializedView)o;
        return Objects.equal(this.proto, that.proto);
    }

    public int hashCode() {
        return Objects.hashCode(this.proto);
    }
}

