/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Table;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.TableName;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.ColumnFamily;
import com.google.bigtable.repackaged.com.google.common.base.Objects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import com.google.bigtable.repackaged.org.threeten.bp.Duration;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public final class Table {
    private final String id;
    private final String instanceId;
    private final Map<String, ReplicationState> replicationStatesByClusterId;
    private final List<ColumnFamily> columnFamilies;
    private final Duration changeStreamRetention;
    private final boolean deletionProtection;
    private static AutomatedBackupPolicy automatedBackupPolicy;

    /*
     * WARNING - void declaration
     */
    @InternalApi
    public static Table fromProto(@Nonnull com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Table proto) {
        void var3_7;
        ImmutableMap.Builder<String, ReplicationState> replicationStates = ImmutableMap.builder();
        for (Map.Entry<String, Table.ClusterState> entry : proto.getClusterStatesMap().entrySet()) {
            replicationStates.put(entry.getKey(), ReplicationState.fromProto(entry.getValue().getReplicationState()));
        }
        ImmutableList.Builder columnFamilies = ImmutableList.builder();
        for (Map.Entry<String, com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ColumnFamily> entry : proto.getColumnFamiliesMap().entrySet()) {
            columnFamilies.add(ColumnFamily.fromProto(entry.getKey(), entry.getValue()));
        }
        Object var3_5 = null;
        if (proto.hasChangeStreamConfig()) {
            Duration duration = Duration.ofSeconds(proto.getChangeStreamConfig().getRetentionPeriod().getSeconds(), proto.getChangeStreamConfig().getRetentionPeriod().getNanos());
        }
        automatedBackupPolicy = proto.hasAutomatedBackupPolicy() ? AutomatedBackupPolicy.fromProto(proto.getAutomatedBackupPolicy()) : null;
        return new Table(TableName.parse(proto.getName()), replicationStates.build(), (List<ColumnFamily>)((Object)columnFamilies.build()), (Duration)var3_7, proto.getDeletionProtection(), automatedBackupPolicy);
    }

    private Table(TableName tableName, Map<String, ReplicationState> replicationStatesByClusterId, List<ColumnFamily> columnFamilies, Duration changeStreamRetention, boolean deletionProtection, AutomatedBackupPolicy automatedBackupPolicy) {
        this.instanceId = tableName.getInstance();
        this.id = tableName.getTable();
        this.replicationStatesByClusterId = replicationStatesByClusterId;
        this.columnFamilies = columnFamilies;
        this.changeStreamRetention = changeStreamRetention;
        this.deletionProtection = deletionProtection;
        Table.automatedBackupPolicy = automatedBackupPolicy;
    }

    public String getId() {
        return this.id;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public Map<String, ReplicationState> getReplicationStatesByClusterId() {
        return this.replicationStatesByClusterId;
    }

    public List<ColumnFamily> getColumnFamilies() {
        return this.columnFamilies;
    }

    public Duration getChangeStreamRetention() {
        return this.changeStreamRetention;
    }

    public boolean isDeletionProtected() {
        return this.deletionProtection;
    }

    public boolean isAutomatedBackupEnabled() {
        return automatedBackupPolicy != null;
    }

    public AutomatedBackupPolicy getAutomatedBackupPolicy() {
        return automatedBackupPolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Table table = (Table)o;
        return Objects.equal(this.id, table.id) && Objects.equal(this.instanceId, table.instanceId) && Objects.equal(this.replicationStatesByClusterId, table.replicationStatesByClusterId) && Objects.equal(this.columnFamilies, table.columnFamilies) && Objects.equal(this.changeStreamRetention, table.changeStreamRetention) && Objects.equal(this.deletionProtection, table.deletionProtection) && Objects.equal(automatedBackupPolicy, automatedBackupPolicy);
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.instanceId, this.replicationStatesByClusterId, this.columnFamilies, this.changeStreamRetention, this.deletionProtection, automatedBackupPolicy);
    }

    public static enum ReplicationState {
        NOT_KNOWN(Table.ClusterState.ReplicationState.STATE_NOT_KNOWN),
        INITIALIZING(Table.ClusterState.ReplicationState.INITIALIZING),
        PLANNED_MAINTENANCE(Table.ClusterState.ReplicationState.PLANNED_MAINTENANCE),
        UNPLANNED_MAINTENANCE(Table.ClusterState.ReplicationState.UNPLANNED_MAINTENANCE),
        READY(Table.ClusterState.ReplicationState.READY),
        READY_OPTIMIZING(Table.ClusterState.ReplicationState.READY_OPTIMIZING),
        UNRECOGNIZED(Table.ClusterState.ReplicationState.UNRECOGNIZED);

        private final Table.ClusterState.ReplicationState proto;

        @InternalApi
        public static ReplicationState fromProto(Table.ClusterState.ReplicationState proto) {
            Preconditions.checkNotNull(proto);
            for (ReplicationState state : ReplicationState.values()) {
                if (!state.proto.equals(proto)) continue;
                return state;
            }
            return UNRECOGNIZED;
        }

        private ReplicationState(Table.ClusterState.ReplicationState proto) {
            this.proto = proto;
        }

        @InternalApi
        public Table.ClusterState.ReplicationState toProto() {
            return this.proto;
        }
    }

    public static class AutomatedBackupPolicy {
        private final Table.AutomatedBackupPolicy proto;

        @InternalApi
        public static AutomatedBackupPolicy fromProto(Table.AutomatedBackupPolicy proto) {
            return new AutomatedBackupPolicy(proto);
        }

        AutomatedBackupPolicy(@Nonnull Table.AutomatedBackupPolicy proto) {
            this.proto = proto;
        }

        @InternalApi
        public Table.AutomatedBackupPolicy toProto() {
            return this.proto;
        }

        public String viewConfig() {
            AutomatedBackupPolicy config = AutomatedBackupPolicy.fromProto(this.proto);
            return config.proto.getAllFields().toString();
        }
    }
}

