/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.UpdateLogicalViewRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.LogicalView;
import com.google.bigtable.repackaged.com.google.common.base.Objects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.protobuf.FieldMask;
import com.google.bigtable.repackaged.com.google.protobuf.util.FieldMaskUtil;
import javax.annotation.Nonnull;

public final class UpdateLogicalViewRequest {
    private final UpdateLogicalViewRequest.Builder requestBuilder;
    private final String instanceId;
    private final String logicalViewId;

    public static UpdateLogicalViewRequest of(@Nonnull LogicalView logicalView) {
        return new UpdateLogicalViewRequest(logicalView.getId(), logicalView.getInstanceId(), com.google.bigtable.repackaged.com.google.bigtable.admin.v2.UpdateLogicalViewRequest.newBuilder().setLogicalView(logicalView.toProto()));
    }

    public static UpdateLogicalViewRequest of(@Nonnull String instanceId, @Nonnull String logicalViewId) {
        return new UpdateLogicalViewRequest(logicalViewId, instanceId, com.google.bigtable.repackaged.com.google.bigtable.admin.v2.UpdateLogicalViewRequest.newBuilder());
    }

    private UpdateLogicalViewRequest(@Nonnull String logicalViewId, @Nonnull String instanceId, @Nonnull UpdateLogicalViewRequest.Builder requestBuilder) {
        Preconditions.checkNotNull(instanceId, "instanceId must be set");
        Preconditions.checkNotNull(logicalViewId, "logicalViewId must be set");
        Preconditions.checkNotNull(requestBuilder, "proto builder must be set");
        this.instanceId = instanceId;
        this.logicalViewId = logicalViewId;
        this.requestBuilder = requestBuilder;
    }

    public UpdateLogicalViewRequest setQuery(String query) {
        this.requestBuilder.getLogicalViewBuilder().setQuery(query);
        this.updateFieldMask(2);
        return this;
    }

    private void updateFieldMask(int fieldNumber) {
        FieldMask newMask = FieldMaskUtil.fromFieldNumbers(com.google.bigtable.repackaged.com.google.bigtable.admin.v2.LogicalView.class, fieldNumber);
        this.requestBuilder.setUpdateMask(FieldMaskUtil.union(this.requestBuilder.getUpdateMask(), newMask, new FieldMask[0]));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateLogicalViewRequest that = (UpdateLogicalViewRequest)o;
        return Objects.equal(this.requestBuilder.build(), that.requestBuilder.build()) && Objects.equal(this.logicalViewId, that.logicalViewId);
    }

    public int hashCode() {
        return Objects.hashCode(this.requestBuilder.build(), this.logicalViewId);
    }

    @InternalApi
    public com.google.bigtable.repackaged.com.google.bigtable.admin.v2.UpdateLogicalViewRequest toProto(@Nonnull String projectId) {
        this.requestBuilder.getLogicalViewBuilder().setName(NameUtil.formatLogicalViewName(projectId, this.instanceId, this.logicalViewId));
        return this.requestBuilder.build();
    }
}

