/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.UpdateMaterializedViewRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.MaterializedView;
import com.google.bigtable.repackaged.com.google.common.base.Objects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.protobuf.FieldMask;
import com.google.bigtable.repackaged.com.google.protobuf.util.FieldMaskUtil;
import javax.annotation.Nonnull;

public final class UpdateMaterializedViewRequest {
    private final UpdateMaterializedViewRequest.Builder requestBuilder;
    private final String instanceId;
    private final String materializedViewId;

    public static UpdateMaterializedViewRequest of(@Nonnull MaterializedView materializedView) {
        return new UpdateMaterializedViewRequest(materializedView.getId(), materializedView.getInstanceId(), com.google.bigtable.repackaged.com.google.bigtable.admin.v2.UpdateMaterializedViewRequest.newBuilder().setMaterializedView(materializedView.toProto()));
    }

    public static UpdateMaterializedViewRequest of(@Nonnull String instanceId, @Nonnull String materializedViewId) {
        return new UpdateMaterializedViewRequest(materializedViewId, instanceId, com.google.bigtable.repackaged.com.google.bigtable.admin.v2.UpdateMaterializedViewRequest.newBuilder());
    }

    private UpdateMaterializedViewRequest(@Nonnull String materializedViewId, @Nonnull String instanceId, @Nonnull UpdateMaterializedViewRequest.Builder requestBuilder) {
        Preconditions.checkNotNull(instanceId, "instanceId must be set");
        Preconditions.checkNotNull(materializedViewId, "materializedViewId must be set");
        Preconditions.checkNotNull(requestBuilder, "proto builder must be set");
        this.instanceId = instanceId;
        this.materializedViewId = materializedViewId;
        this.requestBuilder = requestBuilder;
    }

    public UpdateMaterializedViewRequest setDeletionProtection(boolean deletionProtection) {
        this.requestBuilder.getMaterializedViewBuilder().setDeletionProtection(deletionProtection);
        this.updateFieldMask(6);
        return this;
    }

    private void updateFieldMask(int fieldNumber) {
        FieldMask newMask = FieldMaskUtil.fromFieldNumbers(com.google.bigtable.repackaged.com.google.bigtable.admin.v2.MaterializedView.class, fieldNumber);
        this.requestBuilder.setUpdateMask(FieldMaskUtil.union(this.requestBuilder.getUpdateMask(), newMask, new FieldMask[0]));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateMaterializedViewRequest that = (UpdateMaterializedViewRequest)o;
        return Objects.equal(this.requestBuilder.build(), that.requestBuilder.build()) && Objects.equal(this.materializedViewId, that.materializedViewId);
    }

    public int hashCode() {
        return Objects.hashCode(this.requestBuilder.build(), this.materializedViewId);
    }

    @InternalApi
    public com.google.bigtable.repackaged.com.google.bigtable.admin.v2.UpdateMaterializedViewRequest toProto(@Nonnull String projectId) {
        this.requestBuilder.getMaterializedViewBuilder().setName(NameUtil.formatMaterializedViewName(projectId, this.instanceId, this.materializedViewId));
        return this.requestBuilder.build();
    }
}

