/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.v2.Value;
import com.google.bigtable.repackaged.com.google.cloud.Date;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.ProtoStruct;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.TimestampUtil;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.sql.SqlType;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.sql.Struct;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.sql.StructReader;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@InternalApi
public abstract class AbstractProtoStructReader
implements StructReader {
    abstract List<Value> values();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract int getColumnIndex(String var1);

    public abstract SqlType<?> getColumnType(int var1);

    public SqlType<?> getColumnType(String columnName) {
        return this.getColumnType(this.getColumnIndex(columnName));
    }

    @Override
    public boolean isNull(int columnIndex) {
        Value value = this.values().get(columnIndex);
        return value.getKindCase().equals(Value.KindCase.KIND_NOT_SET);
    }

    @Override
    public boolean isNull(String columnName) {
        return this.isNull(this.getColumnIndex(columnName));
    }

    @Override
    public ByteString getBytes(int columnIndex) {
        this.checkNonNullOfType(columnIndex, SqlType.bytes(), columnIndex);
        Value value = this.values().get(columnIndex);
        return value.getBytesValue();
    }

    @Override
    public ByteString getBytes(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        this.checkNonNullOfType(columnIndex, SqlType.bytes(), columnName);
        Value value = this.values().get(columnIndex);
        return value.getBytesValue();
    }

    @Override
    public String getString(int columnIndex) {
        this.checkNonNullOfType(columnIndex, SqlType.string(), columnIndex);
        Value value = this.values().get(columnIndex);
        return value.getStringValue();
    }

    @Override
    public String getString(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        this.checkNonNullOfType(columnIndex, SqlType.string(), columnName);
        Value value = this.values().get(columnIndex);
        return value.getStringValue();
    }

    @Override
    public long getLong(int columnIndex) {
        this.checkNonNullOfType(columnIndex, SqlType.int64(), columnIndex);
        Value value = this.values().get(columnIndex);
        return value.getIntValue();
    }

    @Override
    public long getLong(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        this.checkNonNullOfType(columnIndex, SqlType.int64(), columnName);
        Value value = this.values().get(columnIndex);
        return value.getIntValue();
    }

    @Override
    public double getDouble(int columnIndex) {
        this.checkNonNullOfType(columnIndex, SqlType.float64(), columnIndex);
        Value value = this.values().get(columnIndex);
        return value.getFloatValue();
    }

    @Override
    public double getDouble(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        this.checkNonNullOfType(columnIndex, SqlType.float64(), columnName);
        Value value = this.values().get(columnIndex);
        return value.getFloatValue();
    }

    @Override
    public float getFloat(int columnIndex) {
        this.checkNonNullOfType(columnIndex, SqlType.float32(), columnIndex);
        Value value = this.values().get(columnIndex);
        return (float)value.getFloatValue();
    }

    @Override
    public float getFloat(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        this.checkNonNullOfType(columnIndex, SqlType.float32(), columnName);
        Value value = this.values().get(columnIndex);
        return (float)value.getFloatValue();
    }

    @Override
    public boolean getBoolean(int columnIndex) {
        this.checkNonNullOfType(columnIndex, SqlType.bool(), columnIndex);
        Value value = this.values().get(columnIndex);
        return value.getBoolValue();
    }

    @Override
    public boolean getBoolean(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        this.checkNonNullOfType(columnIndex, SqlType.bool(), columnName);
        Value value = this.values().get(columnIndex);
        return value.getBoolValue();
    }

    @Override
    public Instant getTimestamp(int columnIndex) {
        this.checkNonNullOfType(columnIndex, SqlType.timestamp(), columnIndex);
        Value value = this.values().get(columnIndex);
        return TimestampUtil.toInstant(value.getTimestampValue());
    }

    @Override
    public Instant getTimestamp(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        this.checkNonNullOfType(columnIndex, SqlType.timestamp(), columnName);
        Value value = this.values().get(columnIndex);
        return TimestampUtil.toInstant(value.getTimestampValue());
    }

    @Override
    public Date getDate(int columnIndex) {
        this.checkNonNullOfType(columnIndex, SqlType.date(), columnIndex);
        Value value = this.values().get(columnIndex);
        return this.fromProto(value.getDateValue());
    }

    @Override
    public Date getDate(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        this.checkNonNullOfType(columnIndex, SqlType.date(), columnName);
        Value value = this.values().get(columnIndex);
        return this.fromProto(value.getDateValue());
    }

    @Override
    public Struct getStruct(int columnIndex) {
        this.checkNonNullOfType(columnIndex, SqlType.struct(), columnIndex);
        Value value = this.values().get(columnIndex);
        SqlType.Struct schema = (SqlType.Struct)this.getColumnType(columnIndex);
        return ProtoStruct.create(schema, value.getArrayValue());
    }

    @Override
    public Struct getStruct(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        this.checkNonNullOfType(columnIndex, SqlType.struct(), columnName);
        Value value = this.values().get(columnIndex);
        SqlType.Struct schema = (SqlType.Struct)this.getColumnType(columnIndex);
        return ProtoStruct.create(schema, value.getArrayValue());
    }

    @Override
    public <ElemType> List<ElemType> getList(int columnIndex, SqlType.Array<ElemType> arrayType) {
        SqlType<?> actualType = this.getColumnType(columnIndex);
        this.checkNonNullOfType(columnIndex, arrayType, actualType, columnIndex);
        Value value = this.values().get(columnIndex);
        return (List)this.decodeValue(value, actualType);
    }

    @Override
    public <ElemType> List<ElemType> getList(String columnName, SqlType.Array<ElemType> arrayType) {
        int columnIndex = this.getColumnIndex(columnName);
        SqlType<?> actualType = this.getColumnType(columnIndex);
        this.checkNonNullOfType(columnIndex, arrayType, actualType, columnName);
        Value value = this.values().get(columnIndex);
        return (List)this.decodeValue(value, actualType);
    }

    @Override
    public <K, V> Map<K, V> getMap(int columnIndex, SqlType.Map<K, V> mapType) {
        SqlType<?> actualType = this.getColumnType(columnIndex);
        this.checkNonNullOfType(columnIndex, mapType, actualType, columnIndex);
        Value value = this.values().get(columnIndex);
        return (Map)this.decodeValue(value, actualType);
    }

    @Override
    public <K, V> Map<K, V> getMap(String columnName, SqlType.Map<K, V> mapType) {
        int columnIndex = this.getColumnIndex(columnName);
        SqlType<?> actualType = this.getColumnType(columnIndex);
        this.checkNonNullOfType(columnIndex, mapType, actualType, columnName);
        Value value = this.values().get(columnIndex);
        return (Map)this.decodeValue(value, actualType);
    }

    Object decodeValue(Value value, SqlType<?> type) {
        if (value.getKindCase().equals(Value.KindCase.KIND_NOT_SET)) {
            return null;
        }
        switch (type.getCode()) {
            case BYTES: {
                return value.getBytesValue();
            }
            case STRING: {
                return value.getStringValue();
            }
            case INT64: {
                return value.getIntValue();
            }
            case FLOAT64: {
                return value.getFloatValue();
            }
            case FLOAT32: {
                return Float.valueOf((float)value.getFloatValue());
            }
            case BOOL: {
                return value.getBoolValue();
            }
            case TIMESTAMP: {
                return TimestampUtil.toInstant(value.getTimestampValue());
            }
            case DATE: {
                return this.fromProto(value.getDateValue());
            }
            case STRUCT: {
                SqlType.Struct schema = (SqlType.Struct)type;
                return ProtoStruct.create(schema, value.getArrayValue());
            }
            case ARRAY: {
                ArrayList<Object> listBuilder = new ArrayList<Object>();
                SqlType.Array arrayType = (SqlType.Array)type;
                SqlType elemType = arrayType.getElementType();
                for (Value elem : value.getArrayValue().getValuesList()) {
                    listBuilder.add(this.decodeValue(elem, elemType));
                }
                return Collections.unmodifiableList(listBuilder);
            }
            case MAP: {
                HashMap<Object, Object> mapBuilder = new HashMap<Object, Object>();
                SqlType.Map mapType = (SqlType.Map)type;
                SqlType keyType = mapType.getKeyType();
                SqlType valType = mapType.getValueType();
                for (Value entry : value.getArrayValue().getValuesList()) {
                    Object key = this.decodeValue(entry.getArrayValue().getValues(0), keyType);
                    Object val = this.decodeValue(entry.getArrayValue().getValues(1), valType);
                    mapBuilder.put(key, val);
                }
                return Collections.unmodifiableMap(mapBuilder);
            }
        }
        throw new IllegalStateException("Unrecognized type: " + type);
    }

    private void checkNonNullOfType(int columnIndex, SqlType<?> expectedType, Object columnNameForError) {
        SqlType<?> actualType = this.getColumnType(columnIndex);
        this.checkNonNullOfType(columnIndex, expectedType, actualType, columnNameForError);
    }

    private void checkNonNullOfType(int columnIndex, SqlType<?> expectedType, SqlType<?> actualType, Object columnNameForError) {
        Preconditions.checkState(SqlType.typesMatch(expectedType, actualType), "Column %s is not of correct type: expected %s but was %s", columnNameForError, (Object)expectedType.toString(), (Object)actualType.toString());
        if (this.isNull(columnIndex)) {
            throw new NullPointerException("Column " + columnNameForError + " contains NULL value");
        }
    }

    private Date fromProto(com.google.bigtable.repackaged.com.google.type.Date proto) {
        return Date.fromYearMonthDay(proto.getYear(), proto.getMonth(), proto.getDay());
    }
}

