/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal;

import com.google.bigtable.repackaged.com.google.api.core.ApiFuture;
import com.google.bigtable.repackaged.com.google.api.core.ApiFutures;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.auto.value.AutoValue;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.AutoValue_PreparedStatementImpl_PrepareQueryState;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.AutoValue_PreparedStatementImpl_PreparedQueryData;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.PrepareQueryRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.PrepareResponse;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.sql.BoundStatement;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.sql.PreparedStatement;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.sql.SqlType;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStub;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.Futures;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;

@InternalApi(value="For internal use only")
public class PreparedStatementImpl
implements PreparedStatement {
    private static final Duration EXPIRY_REFRESH_WINDOW = Duration.ofSeconds(1L);
    private final AtomicReference<PrepareQueryState> currentState;
    private final Map<String, SqlType<?>> paramTypes;
    private final PrepareQueryRequest prepareRequest;
    private final EnhancedBigtableStub stub;

    @VisibleForTesting
    protected PreparedStatementImpl(PrepareResponse response, Map<String, SqlType<?>> paramTypes, PrepareQueryRequest request, EnhancedBigtableStub stub) {
        this.currentState = new AtomicReference<PrepareQueryState>(PrepareQueryState.createInitialState(response));
        this.paramTypes = paramTypes;
        this.prepareRequest = request;
        this.stub = stub;
    }

    public static PreparedStatement create(PrepareResponse response, Map<String, SqlType<?>> paramTypes, PrepareQueryRequest request, EnhancedBigtableStub stub) {
        return new PreparedStatementImpl(response, paramTypes, request, stub);
    }

    @Override
    public BoundStatement.Builder bind() {
        return new BoundStatement.Builder(this, this.paramTypes);
    }

    public void assertUsingSameStub(EnhancedBigtableStub stub) {
        Preconditions.checkArgument(this.stub == stub, "executeQuery must be called from the same client instance that created the PreparedStatement being used.");
    }

    public synchronized PreparedQueryData markExpiredAndStartRefresh(PreparedQueryVersion expiredPreparedQueryVersion) {
        PrepareQueryState localState = this.currentState.get();
        if (localState.current().version() != expiredPreparedQueryVersion) {
            return localState.current();
        }
        this.startBackgroundRefresh(expiredPreparedQueryVersion);
        return this.promoteBackgroundRefreshingPlan(expiredPreparedQueryVersion);
    }

    private synchronized PreparedQueryData promoteBackgroundRefreshingPlan(PreparedQueryVersion expiredPreparedQueryVersion) {
        PrepareQueryState localState = this.currentState.get();
        if (localState.current().version() != expiredPreparedQueryVersion) {
            return localState.current();
        }
        PrepareQueryState nextState = localState.promoteBackgroundPlan();
        this.currentState.set(nextState);
        return nextState.current();
    }

    private synchronized void startBackgroundRefresh(PreparedQueryVersion planVersionNearExpiry) {
        PrepareQueryState localState = this.currentState.get();
        if (localState.current().version() != planVersionNearExpiry) {
            return;
        }
        if (localState.maybeBackgroundRefresh().isPresent()) {
            return;
        }
        ApiFuture<PrepareResponse> nextPlanFuture = this.getFreshPlan();
        PrepareQueryState withRefresh = localState.withBackgroundPlan(nextPlanFuture);
        this.currentState.set(withRefresh);
    }

    ApiFuture<PrepareResponse> getFreshPlan() {
        return this.stub.prepareQueryCallable().futureCall(this.prepareRequest);
    }

    void backgroundRefreshIfNeeded() {
        PrepareQueryState localState = this.currentState.get();
        if (localState.maybeBackgroundRefresh().isPresent()) {
            return;
        }
        PreparedQueryData currentPlan = localState.current();
        if (!currentPlan.prepareFuture().isDone()) {
            return;
        }
        try {
            Instant currentPlanExpireTime = Futures.getDone(currentPlan.prepareFuture()).validUntil();
            Instant backgroundRefreshTime = currentPlanExpireTime.minus(EXPIRY_REFRESH_WINDOW);
            if (Instant.now().isAfter(backgroundRefreshTime)) {
                this.startBackgroundRefresh(currentPlan.version());
            }
        }
        catch (CancellationException | ExecutionException exception) {
            // empty catch block
        }
    }

    public PreparedQueryData getLatestPrepareResponse() {
        PrepareQueryState localState = this.currentState.get();
        if (localState.maybeBackgroundRefresh().isPresent() && localState.maybeBackgroundRefresh().get().prepareFuture().isDone()) {
            return this.promoteBackgroundRefreshingPlan(localState.current().version());
        }
        this.backgroundRefreshIfNeeded();
        return localState.current();
    }

    @AutoValue
    static abstract class PrepareQueryState {
        PrepareQueryState() {
        }

        abstract PreparedQueryData current();

        abstract Optional<PreparedQueryData> maybeBackgroundRefresh();

        static PrepareQueryState createInitialState(PrepareResponse initialPlan) {
            PreparedQueryData initialData = PreparedQueryData.create(ApiFutures.immediateFuture(initialPlan));
            return new AutoValue_PreparedStatementImpl_PrepareQueryState(initialData, Optional.empty());
        }

        PrepareQueryState withBackgroundPlan(ApiFuture<PrepareResponse> backgroundPlan) {
            return new AutoValue_PreparedStatementImpl_PrepareQueryState(this.current(), Optional.of(PreparedQueryData.create(backgroundPlan)));
        }

        PrepareQueryState promoteBackgroundPlan() {
            if (this.maybeBackgroundRefresh().isPresent()) {
                return new AutoValue_PreparedStatementImpl_PrepareQueryState(this.maybeBackgroundRefresh().get(), Optional.empty());
            }
            return this;
        }
    }

    @InternalApi(value="For internal use only")
    @AutoValue
    public static abstract class PreparedQueryData {
        public abstract PreparedQueryVersion version();

        public abstract ApiFuture<PrepareResponse> prepareFuture();

        public static PreparedQueryData create(ApiFuture<PrepareResponse> prepareFuture) {
            return new AutoValue_PreparedStatementImpl_PreparedQueryData(new PreparedQueryVersion(), prepareFuture);
        }
    }

    @InternalApi(value="For internal use only")
    public static class PreparedQueryVersion {
    }
}

