/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.v2.Type;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.sql.SqlType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

@InternalApi(value="For internal use only")
public class QueryParamUtil {
    private static final Type STRING_TYPE = Type.newBuilder().setStringType(Type.String.getDefaultInstance()).build();
    private static final Type BYTES_TYPE = Type.newBuilder().setBytesType(Type.Bytes.getDefaultInstance()).build();
    private static final Type INT64_TYPE = Type.newBuilder().setInt64Type(Type.Int64.getDefaultInstance()).build();
    private static final Type FLOAT32_TYPE = Type.newBuilder().setFloat32Type(Type.Float32.getDefaultInstance()).build();
    private static final Type FLOAT64_TYPE = Type.newBuilder().setFloat64Type(Type.Float64.getDefaultInstance()).build();
    private static final Type BOOL_TYPE = Type.newBuilder().setBoolType(Type.Bool.getDefaultInstance()).build();
    private static final Type TIMESTAMP_TYPE = Type.newBuilder().setTimestampType(Type.Timestamp.getDefaultInstance()).build();
    private static final Type DATE_TYPE = Type.newBuilder().setDateType(Type.Date.getDefaultInstance()).build();
    private static final Set<SqlType.Code> VALID_ARRAY_ELEMENT_TYPES = new HashSet<SqlType.Code>(Arrays.asList(SqlType.Code.STRING, SqlType.Code.BYTES, SqlType.Code.INT64, SqlType.Code.FLOAT64, SqlType.Code.FLOAT32, SqlType.Code.BOOL, SqlType.Code.TIMESTAMP, SqlType.Code.DATE));

    public static Type convertToQueryParamProto(SqlType<?> sqlType) {
        switch (sqlType.getCode()) {
            case BYTES: {
                return BYTES_TYPE;
            }
            case STRING: {
                return STRING_TYPE;
            }
            case INT64: {
                return INT64_TYPE;
            }
            case FLOAT64: {
                return FLOAT64_TYPE;
            }
            case FLOAT32: {
                return FLOAT32_TYPE;
            }
            case BOOL: {
                return BOOL_TYPE;
            }
            case TIMESTAMP: {
                return TIMESTAMP_TYPE;
            }
            case DATE: {
                return DATE_TYPE;
            }
            case STRUCT: {
                throw new IllegalArgumentException("STRUCT is not a supported query parameter type");
            }
            case MAP: {
                throw new IllegalArgumentException("MAP is not a supported query parameter type");
            }
            case ARRAY: {
                SqlType.Array arrayType = (SqlType.Array)sqlType;
                if (!VALID_ARRAY_ELEMENT_TYPES.contains((Object)arrayType.getElementType().getCode())) {
                    throw new IllegalArgumentException("Unsupported query parameter Array element type: " + arrayType.getElementType());
                }
                Type elementType = QueryParamUtil.convertToQueryParamProto(arrayType.getElementType());
                Type.Array arrayProto = Type.Array.newBuilder().setElementType(elementType).build();
                return Type.newBuilder().setArrayType(arrayProto).build();
            }
        }
        throw new IllegalArgumentException("Unsupported Query parameter type: " + sqlType);
    }
}

