/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal;

import com.google.bigtable.repackaged.com.google.api.core.ApiFuture;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiExceptions;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ServerStream;
import com.google.bigtable.repackaged.com.google.cloud.Date;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.SqlRow;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.sql.ResultSet;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.sql.SqlType;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.sql.Struct;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.sql.StructReader;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.sql.SqlServerStream;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@InternalApi(value="For internal use only")
public class ResultSetImpl
implements ResultSet,
StructReader {
    private final ServerStream<SqlRow> serverStream;
    private final Iterator<SqlRow> rowIterator;
    private final ApiFuture<ResultSetMetadata> metadataApiFuture;
    private boolean consumed;
    private SqlRow currentRow;

    public static ResultSet create(SqlServerStream sqlServerStream) {
        return new ResultSetImpl(sqlServerStream);
    }

    private ResultSetImpl(SqlServerStream sqlServerStream) {
        this.serverStream = sqlServerStream.rows();
        this.rowIterator = this.serverStream.iterator();
        this.metadataApiFuture = sqlServerStream.metadataFuture();
        this.consumed = false;
    }

    private SqlRow getCurrentRow() {
        Preconditions.checkState(!this.consumed, "Attempted to access data from closed ResultSet");
        Preconditions.checkState(this.currentRow != null, "Attempted to access data before calling next()");
        return this.currentRow;
    }

    @Override
    public boolean next() {
        if (this.consumed) {
            return false;
        }
        boolean hasNext = this.rowIterator.hasNext();
        if (hasNext) {
            this.currentRow = this.rowIterator.next();
        } else {
            this.consumed = true;
        }
        return hasNext;
    }

    @Override
    public ResultSetMetadata getMetadata() {
        return ApiExceptions.callAndTranslateApiException(this.metadataApiFuture);
    }

    @Override
    public void close() {
        if (!this.consumed) {
            this.serverStream.cancel();
        }
        this.consumed = true;
    }

    @Override
    public boolean isNull(int columnIndex) {
        return this.getCurrentRow().isNull(columnIndex);
    }

    @Override
    public boolean isNull(String columnName) {
        return this.getCurrentRow().isNull(columnName);
    }

    @Override
    public ByteString getBytes(int columnIndex) {
        return this.getCurrentRow().getBytes(columnIndex);
    }

    @Override
    public ByteString getBytes(String columnName) {
        return this.getCurrentRow().getBytes(columnName);
    }

    @Override
    public String getString(int columnIndex) {
        return this.getCurrentRow().getString(columnIndex);
    }

    @Override
    public String getString(String columnName) {
        return this.getCurrentRow().getString(columnName);
    }

    @Override
    public long getLong(int columnIndex) {
        return this.getCurrentRow().getLong(columnIndex);
    }

    @Override
    public long getLong(String columnName) {
        return this.getCurrentRow().getLong(columnName);
    }

    @Override
    public double getDouble(int columnIndex) {
        return this.getCurrentRow().getDouble(columnIndex);
    }

    @Override
    public double getDouble(String columnName) {
        return this.getCurrentRow().getDouble(columnName);
    }

    @Override
    public float getFloat(int columnIndex) {
        return this.getCurrentRow().getFloat(columnIndex);
    }

    @Override
    public float getFloat(String columnName) {
        return this.getCurrentRow().getFloat(columnName);
    }

    @Override
    public boolean getBoolean(int columnIndex) {
        return this.getCurrentRow().getBoolean(columnIndex);
    }

    @Override
    public boolean getBoolean(String columnName) {
        return this.getCurrentRow().getBoolean(columnName);
    }

    @Override
    public Instant getTimestamp(int columnIndex) {
        return this.getCurrentRow().getTimestamp(columnIndex);
    }

    @Override
    public Instant getTimestamp(String columnName) {
        return this.getCurrentRow().getTimestamp(columnName);
    }

    @Override
    public Date getDate(int columnIndex) {
        return this.getCurrentRow().getDate(columnIndex);
    }

    @Override
    public Date getDate(String columnName) {
        return this.getCurrentRow().getDate(columnName);
    }

    @Override
    public Struct getStruct(int columnIndex) {
        return this.getCurrentRow().getStruct(columnIndex);
    }

    @Override
    public Struct getStruct(String columnName) {
        return this.getCurrentRow().getStruct(columnName);
    }

    @Override
    public <ElemType> List<ElemType> getList(int columnIndex, SqlType.Array<ElemType> arrayType) {
        return this.getCurrentRow().getList(columnIndex, arrayType);
    }

    @Override
    public <ElemType> List<ElemType> getList(String columnName, SqlType.Array<ElemType> arrayType) {
        return this.getCurrentRow().getList(columnName, arrayType);
    }

    @Override
    public <K, V> Map<K, V> getMap(int columnIndex, SqlType.Map<K, V> mapType) {
        return this.getCurrentRow().getMap(columnIndex, mapType);
    }

    @Override
    public <K, V> Map<K, V> getMap(String columnName, SqlType.Map<K, V> mapType) {
        return this.getCurrentRow().getMap(columnName, mapType);
    }
}

