/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.auto.value.AutoValue;
import com.google.bigtable.repackaged.com.google.bigtable.v2.RowRange;
import com.google.bigtable.repackaged.com.google.bigtable.v2.RowSet;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.AutoValue_RowSetUtil_Split;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.ByteStringComparator;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Range;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.ComparisonChain;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public final class RowSetUtil {
    private RowSetUtil() {
    }

    public static RowSet eraseLargeRow(RowSet rowSet, ByteString excludePoint) {
        RowSet.Builder newRowSet = RowSet.newBuilder();
        if (rowSet.getRowKeysList().isEmpty() && rowSet.getRowRangesList().isEmpty()) {
            newRowSet.addRowRanges(RowRange.newBuilder().setEndKeyOpen(excludePoint).build());
            newRowSet.addRowRanges(RowRange.newBuilder().setStartKeyOpen(excludePoint).build());
        }
        rowSet.getRowKeysList().stream().filter(k -> !k.equals(excludePoint)).forEach(newRowSet::addRowKeys);
        for (RowRange rowRange : rowSet.getRowRangesList()) {
            List<RowRange> afterSplit = RowSetUtil.splitOnLargeRowKey(rowRange, excludePoint);
            if (afterSplit == null || afterSplit.isEmpty()) continue;
            afterSplit.forEach(newRowSet::addRowRanges);
        }
        if (newRowSet.getRowKeysList().isEmpty() && newRowSet.getRowRangesList().isEmpty()) {
            return null;
        }
        return newRowSet.build();
    }

    public static RowSet erase(RowSet rowSet, ByteString splitPoint, boolean fromStart) {
        RowSet.Builder newRowSet = RowSet.newBuilder();
        if (rowSet.getRowKeysList().isEmpty() && rowSet.getRowRangesList().isEmpty()) {
            rowSet = RowSet.newBuilder().addRowRanges(RowRange.getDefaultInstance()).build();
        }
        for (ByteString key : rowSet.getRowKeysList()) {
            if (fromStart) {
                if (ByteStringComparator.INSTANCE.compare(key, splitPoint) <= 0) continue;
                newRowSet.addRowKeys(key);
                continue;
            }
            if (ByteStringComparator.INSTANCE.compare(key, splitPoint) >= 0) continue;
            newRowSet.addRowKeys(key);
        }
        for (RowRange rowRange : rowSet.getRowRangesList()) {
            RowRange newRange = RowSetUtil.truncateRange(rowRange, splitPoint, fromStart);
            if (newRange == null) continue;
            newRowSet.addRowRanges(newRange);
        }
        RowSet result = newRowSet.build();
        if (result.getRowKeysList().isEmpty() && result.getRowRangesList().isEmpty()) {
            return null;
        }
        return result;
    }

    private static RowRange truncateRange(RowRange range, ByteString split, boolean fromStart) {
        if (fromStart ? EndPoint.extract(range).compareTo(new EndPoint(split, true)) <= 0 : StartPoint.extract(range).compareTo(new StartPoint(split, true)) >= 0) {
            return null;
        }
        RowRange.Builder newRange = range.toBuilder();
        if (fromStart) {
            if (StartPoint.extract(range).compareTo(new StartPoint(split, true)) <= 0) {
                newRange.setStartKeyOpen(split);
            }
        } else if (EndPoint.extract(range).compareTo(new EndPoint(split, true)) >= 0) {
            newRange.setEndKeyOpen(split);
        }
        return newRange.build();
    }

    private static List<RowRange> splitOnLargeRowKey(RowRange range, ByteString largeRowKey) {
        ArrayList<RowRange> rowRanges = new ArrayList<RowRange>();
        ByteString startKey = StartPoint.extract(range).value;
        ByteString endKey = EndPoint.extract(range).value;
        if (ByteStringComparator.INSTANCE.compare(endKey, largeRowKey) < 0) {
            rowRanges.add(range);
            return rowRanges;
        }
        if (ByteStringComparator.INSTANCE.compare(startKey, largeRowKey) > 0) {
            rowRanges.add(range);
            return rowRanges;
        }
        if (ByteStringComparator.INSTANCE.compare(startKey, largeRowKey) < 0) {
            RowRange beforeSplit = range.toBuilder().setEndKeyOpen(largeRowKey).build();
            rowRanges.add(beforeSplit);
        }
        if (ByteStringComparator.INSTANCE.compare(endKey, largeRowKey) > 0) {
            RowRange afterSplit = range.toBuilder().setStartKeyOpen(largeRowKey).build();
            rowRanges.add(afterSplit);
        }
        return rowRanges;
    }

    @Nonnull
    public static List<RowSet> shard(@Nonnull RowSet rowSet, @Nonnull SortedSet<ByteString> splitPoints) {
        RowSet.Builder segment;
        if (rowSet.getRowKeysList().isEmpty() && rowSet.getRowRangesList().isEmpty()) {
            rowSet = RowSet.newBuilder().addRowRanges(RowRange.getDefaultInstance()).build();
        }
        ArrayDeque keys = rowSet.getRowKeysList().stream().sorted(ByteStringComparator.INSTANCE).collect(Collectors.toCollection(ArrayDeque::new));
        ArrayDeque ranges = rowSet.getRowRangesList().stream().sorted(Comparator.comparing(StartPoint::extract)).collect(Collectors.toCollection(ArrayDeque::new));
        ArrayList<RowSet> segments = new ArrayList<RowSet>();
        for (ByteString splitPoint : splitPoints) {
            Preconditions.checkArgument(!splitPoint.isEmpty(), "Can't handle empty splitPoints");
            segment = RowSet.newBuilder();
            boolean currentSegmentIsEmpty = true;
            while (!keys.isEmpty() && ByteStringComparator.INSTANCE.compare((ByteString)keys.peek(), splitPoint) < 0) {
                segment.addRowKeys((ByteString)keys.poll());
                currentSegmentIsEmpty = false;
            }
            while (!ranges.isEmpty()) {
                StartPoint startPoint = StartPoint.extract((RowRange)ranges.peek());
                int startCmp = ComparisonChain.start().compareTrueFirst(startPoint.value.isEmpty(), false).compare(startPoint.value, splitPoint, ByteStringComparator.INSTANCE).result();
                if (startCmp >= 0) break;
                RowRange range = (RowRange)ranges.poll();
                EndPoint endPoint = EndPoint.extract(range);
                int endCmp = ComparisonChain.start().compareFalseFirst(endPoint.value.isEmpty(), false).compare(endPoint.value, splitPoint, ByteStringComparator.INSTANCE).compareFalseFirst(endPoint.isClosed, true).result();
                if (endCmp < 0) {
                    segment.addRowRanges(range);
                    currentSegmentIsEmpty = false;
                    continue;
                }
                segment.addRowRanges(range.toBuilder().setEndKeyOpen(splitPoint));
                currentSegmentIsEmpty = false;
                ranges.addFirst(range.toBuilder().setStartKeyClosed(splitPoint).build());
            }
            if (currentSegmentIsEmpty) continue;
            segments.add(segment.build());
        }
        if (!keys.isEmpty() || !ranges.isEmpty()) {
            segment = RowSet.newBuilder().addAllRowKeys(keys).addAllRowRanges(ranges);
            segments.add(segment.build());
        }
        return segments;
    }

    public static Range.ByteStringRange getBound(RowSet rowSet) {
        ByteString minKey = null;
        ByteString maxKey = null;
        for (ByteString key : rowSet.getRowKeysList()) {
            if (minKey == null || ByteStringComparator.INSTANCE.compare(minKey, key) > 0) {
                minKey = key;
            }
            if (maxKey != null && ByteStringComparator.INSTANCE.compare(maxKey, key) >= 0) continue;
            maxKey = key;
        }
        StartPoint minStartPoint = null;
        EndPoint maxEndPoint = null;
        if (minKey != null) {
            minStartPoint = new StartPoint(minKey, true);
        }
        if (maxKey != null) {
            maxEndPoint = new EndPoint(maxKey, true);
        }
        for (RowRange rowRange : rowSet.getRowRangesList()) {
            StartPoint currentStartPoint = StartPoint.extract(rowRange);
            if (minStartPoint == null || minStartPoint.compareTo(currentStartPoint) > 0) {
                minStartPoint = currentStartPoint;
            }
            EndPoint currentEndpoint = EndPoint.extract(rowRange);
            if (maxEndPoint != null && maxEndPoint.compareTo(currentEndpoint) >= 0) continue;
            maxEndPoint = currentEndpoint;
        }
        Range.ByteStringRange boundingRange = Range.ByteStringRange.unbounded();
        if (minStartPoint != null) {
            if (minStartPoint.isClosed) {
                boundingRange.startClosed(minStartPoint.value);
            } else {
                boundingRange.startOpen(minStartPoint.value);
            }
        }
        if (maxEndPoint != null) {
            if (maxEndPoint.isClosed) {
                boundingRange.endClosed(maxEndPoint.value);
            } else {
                boundingRange.endOpen(maxEndPoint.value);
            }
        }
        return boundingRange;
    }

    private static final class EndPoint
    implements Comparable<EndPoint> {
        private final ByteString value;
        private final boolean isClosed;

        @Nonnull
        static EndPoint extract(@Nonnull RowRange rowRange) {
            switch (rowRange.getEndKeyCase()) {
                case ENDKEY_NOT_SET: {
                    return new EndPoint(ByteString.EMPTY, true);
                }
                case END_KEY_CLOSED: {
                    return new EndPoint(rowRange.getEndKeyClosed(), true);
                }
                case END_KEY_OPEN: {
                    if (rowRange.getEndKeyOpen().isEmpty()) {
                        return new EndPoint(ByteString.EMPTY, true);
                    }
                    return new EndPoint(rowRange.getEndKeyOpen(), false);
                }
            }
            throw new IllegalArgumentException("Unknown endKeyCase: " + rowRange.getEndKeyCase());
        }

        EndPoint(@Nonnull ByteString value, boolean isClosed) {
            this.value = value;
            this.isClosed = isClosed;
        }

        @Override
        public int compareTo(@Nonnull EndPoint o) {
            return ComparisonChain.start().compareFalseFirst(this.value.isEmpty(), o.value.isEmpty()).compare(this.value, o.value, ByteStringComparator.INSTANCE).compareFalseFirst(this.isClosed, o.isClosed).result();
        }
    }

    private static final class StartPoint
    implements Comparable<StartPoint> {
        private final ByteString value;
        private final boolean isClosed;

        @Nonnull
        static StartPoint extract(@Nonnull RowRange rowRange) {
            switch (rowRange.getStartKeyCase()) {
                case STARTKEY_NOT_SET: {
                    return new StartPoint(ByteString.EMPTY, true);
                }
                case START_KEY_CLOSED: {
                    return new StartPoint(rowRange.getStartKeyClosed(), true);
                }
                case START_KEY_OPEN: {
                    if (rowRange.getStartKeyOpen().isEmpty()) {
                        return new StartPoint(ByteString.EMPTY, true);
                    }
                    return new StartPoint(rowRange.getStartKeyOpen(), false);
                }
            }
            throw new IllegalArgumentException("Unknown startKeyCase: " + rowRange.getStartKeyCase());
        }

        StartPoint(@Nonnull ByteString value, boolean isClosed) {
            this.value = value;
            this.isClosed = isClosed;
        }

        @Override
        public int compareTo(@Nonnull StartPoint o) {
            return ComparisonChain.start().compareTrueFirst(this.value.isEmpty(), o.value.isEmpty()).compare(this.value, o.value, ByteStringComparator.INSTANCE).compareTrueFirst(this.isClosed, o.isClosed).result();
        }
    }

    @InternalApi
    @AutoValue
    public static abstract class Split {
        @Nullable
        public abstract RowSet getLeft();

        @Nullable
        public abstract RowSet getRight();

        public static Split of(RowSet left, RowSet right) {
            return new AutoValue_RowSetUtil_Split(left, right);
        }
    }
}

